/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleVersions {
    private static final Pattern GRADLE_JAR_NAME_PATTERN = Pattern.compile("gradle-core-(\\d+(\\.\\d+)*).*\\.jar");

    @NotNull
    public static GradleVersions getInstance() {
        return (GradleVersions)ApplicationManager.getApplication().getService(GradleVersions.class);
    }

    @Nullable
    public GradleVersion getGradleVersion(@NotNull Project project) {
        GradleProjectSettings gradleSettings;
        GradleVersion gradleVersion2;
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        if (syncState.isSyncNeeded() != ThreeState.YES && (gradleVersion2 = syncState.getLastSyncedGradleVersion()) != null) {
            try {
                return GradleVersion.version((String)GradleVersions.inferStableGradleVersion(gradleVersion2.getVersion()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((gradleSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project)) != null) {
            String gradleHome;
            DistributionType distributionType = gradleSettings.getDistributionType();
            if (distributionType == DistributionType.DEFAULT_WRAPPED) {
                GradleWrapper gradleWrapper = GradleWrapper.find(project);
                if (gradleWrapper != null) {
                    try {
                        String wrapperVersion = gradleWrapper.getGradleVersion();
                        if (wrapperVersion != null) {
                            return GradleVersion.version((String)GradleVersions.inferStableGradleVersion(wrapperVersion));
                        }
                    }
                    catch (Exception e) {
                        Logger.getInstance(this.getClass()).info("Failed to read Gradle version in wrapper");
                    }
                }
            } else if (distributionType == DistributionType.LOCAL && StringUtil.isNotEmpty((String)(gradleHome = gradleSettings.getGradleHome()))) {
                File gradleHomePath = new File(gradleHome);
                return this.getGradleVersion(gradleHomePath);
            }
        }
        return null;
    }

    @Nullable
    public GradleVersion getGradleVersion(@NotNull File gradleHomePath) {
        File libFolderPath = new File(gradleHomePath, "lib");
        if (libFolderPath.isDirectory()) {
            for (File child : FileUtil.notNullize((File[])libFolderPath.listFiles())) {
                GradleVersion version2 = GradleVersions.getGradleVersionFromJar(child);
                if (version2 == null) continue;
                return version2;
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static GradleVersion getGradleVersionFromJar(@NotNull File libraryJarFile) {
        String fileName = libraryJarFile.getName();
        Matcher matcher = GRADLE_JAR_NAME_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            try {
                return GradleVersion.version((String)matcher.group(1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    public static String inferStableGradleVersion(@NotNull String gradleVersion2) {
        int dashIndex = gradleVersion2.indexOf(45);
        if (dashIndex != -1) {
            return gradleVersion2.substring(0, dashIndex);
        }
        return gradleVersion2;
    }
}

