/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.imports;

import com.android.tools.idea.imports.AndroidMavenImportIntentionAction;
import com.android.tools.idea.imports.MavenClassRegistry;
import com.android.tools.idea.imports.MavenImportUtilsKt;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/imports/AndroidMavenImportFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "registry", "Lcom/android/tools/idea/imports/MavenClassRegistry;", "className", "", "artifact", "version", "<init>", "(Lcom/android/tools/idea/imports/MavenClassRegistry;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getRegistry", "()Lcom/android/tools/idea/imports/MavenClassRegistry;", "getClassName", "()Ljava/lang/String;", "getArtifact", "getVersion", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.android.core"})
public final class AndroidMavenImportFix
implements LocalQuickFix {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final MavenClassRegistry registry;
    @NotNull
    private final String className;
    @NotNull
    private final String artifact;
    @Nullable
    private final String version;

    public AndroidMavenImportFix(@NotNull MavenClassRegistry registry, @NotNull String className, @NotNull String artifact, @Nullable String version2) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        this.registry = registry;
        this.className = className;
        this.artifact = artifact;
        this.version = version2;
    }

    @NotNull
    public final MavenClassRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final String getArtifact() {
        return this.artifact;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{MavenImportUtilsKt.flagPreview(this.artifact, this.version)};
        String string = AndroidBundle.message("android.suggested.dependency.action.name.prefix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = AndroidBundle.message("android.suggested.dependency.action.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement element = descriptor2.getEndElement();
        Intrinsics.checkNotNull((Object)element);
        AndroidMavenImportIntentionAction.Companion.doImportSuggestion(project, element, this.artifact, this.version, null, true);
    }
}

