/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.imports;

import com.android.tools.idea.imports.GzipUtilsKt;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "readUrlData", "", "url", "intellij.android.core"})
@JvmName(name="UpdateOfflineGMavenIndex")
public final class UpdateOfflineGMavenIndex {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = (String)ArraysKt.singleOrNull((Object[])args);
        if (string == null) {
            throw new IllegalStateException("You have to specify the repo root as only argument.".toString());
        }
        String root = string;
        Path repoRoot = Paths.get(root, new String[0]);
        if (!Files.isDirectory(repoRoot.resolve(".repo"), new LinkOption[0])) {
            throw new IllegalStateException("Invalid directory: should be pointing to the root of a tools checkout directory.".toString());
        }
        byte[] indexData = GzipUtilsKt.ungzip(UpdateOfflineGMavenIndex.readUrlData("https://dl.google.com/android/studio/gmaven/index/release/v0.1/classes-v0.1.json.gz"));
        Path file = repoRoot.resolve("tools/adt/idea/android/resources/gmavenIndex/classes-offline.json");
        Files.write(file, indexData, new OpenOption[0]);
        System.out.println((Object)("Finished updating " + file + "."));
    }

    private static final byte[] readUrlData(String url) {
        byte[] byArray = Resources.asByteSource((URL)new URL(url)).read();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"read(...)");
        return byArray;
    }
}

