/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ai.transform;

import com.android.tools.idea.insights.ai.FixSuggester;
import com.android.tools.idea.insights.ai.transform.CodeTransformation;
import com.android.tools.idea.insights.ai.transform.TransformDiffViewerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/insights/ai/transform/CodeTransformationImpl;", "Lcom/android/tools/idea/insights/ai/transform/CodeTransformation;", "project", "Lcom/intellij/openapi/project/Project;", "instruction", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/List;)V", "getInstruction", "()Ljava/lang/String;", "getFiles", "()Ljava/util/List;", "apply", "Lkotlinx/coroutines/flow/Flow;", "Lcom/android/tools/idea/insights/ai/transform/TransformDiffViewerEvent;", "dispose", "", "intellij.android.app-quality-insights.api"})
public final class CodeTransformationImpl
implements CodeTransformation {
    @NotNull
    private final Project project;
    @NotNull
    private final String instruction;
    @NotNull
    private final List<VirtualFile> files;

    public CodeTransformationImpl(@NotNull Project project, @NotNull String instruction, @NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        this.project = project;
        this.instruction = instruction;
        this.files = files2;
    }

    @NotNull
    public final String getInstruction() {
        return this.instruction;
    }

    @NotNull
    public final List<VirtualFile> getFiles() {
        return this.files;
    }

    @Override
    @NotNull
    public Flow<TransformDiffViewerEvent> apply() {
        if (this.files.isEmpty()) {
            throw new IllegalStateException("Should not call suggestFix on with no target files");
        }
        FixSuggester fixSuggester = (FixSuggester)CollectionsKt.firstOrNull((List)FixSuggester.Companion.getEP_NAME().getExtensionList());
        if (fixSuggester == null) {
            throw new IllegalStateException("Cannot find FixSuggester extension point");
        }
        return fixSuggester.suggestFix(this.project, this.instruction, this.files, this);
    }

    public void dispose() {
    }
}

