/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.completion;

import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.lang.databinding.DataBindingCompletionSupport;
import com.android.tools.idea.lang.databinding.completion.DataBindingCompletionUtilKt;
import com.android.tools.idea.lang.databinding.config.DbFileType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.dom.layout.Layout;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0003J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/lang/databinding/completion/DataBindingCompletionSupportImpl;", "Lcom/android/tools/idea/lang/databinding/DataBindingCompletionSupport;", "<init>", "()V", "addCompletions", "", "params", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "resultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillAliases", "packagePrefix", "", "originalPosition", "Lcom/intellij/psi/PsiElement;", "module", "Lcom/intellij/openapi/module/Module;", "originalParent", "fillClassNames", "getRealContainingFile", "Lcom/intellij/psi/PsiFile;", "file", "getClassReferenceElement", "Lcom/intellij/codeInsight/completion/JavaPsiClassReferenceElement;", "alias", "referenceClass", "Lcom/intellij/psi/PsiClass;", "Companion", "intellij.android.lang-databinding"})
@SourceDebugExtension(value={"SMAP\nDataBindingCompletionSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataBindingCompletionSupportImpl.kt\ncom/android/tools/idea/lang/databinding/completion/DataBindingCompletionSupportImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,217:1\n295#2,2:218\n1869#2,2:224\n1321#3,2:220\n1321#3,2:222\n1069#4,2:226\n*S KotlinDebug\n*F\n+ 1 DataBindingCompletionSupportImpl.kt\ncom/android/tools/idea/lang/databinding/completion/DataBindingCompletionSupportImpl\n*L\n135#1:218,2\n188#1:224,2\n147#1:220,2\n179#1:222,2\n178#1:226,2\n*E\n"})
public final class DataBindingCompletionSupportImpl
implements DataBindingCompletionSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void addCompletions(@NotNull CompletionParameters params2, @NotNull CompletionResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        PsiElement originalPosition = params2.getOriginalPosition();
        PsiElement psiElement = originalPosition;
        if (psiElement == null || (psiElement = psiElement.getParent()) == null) {
            return;
        }
        PsiElement originalParent = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalParent);
        if (module == null) {
            return;
        }
        Module module2 = module;
        if (this.getRealContainingFile(originalParent.getContainingFile()) == null) {
            return;
        }
        String packagePrefix = DataBindingCompletionSupportImpl.Companion.getPackagePrefix(originalParent, params2.getOffset());
        this.fillAliases(resultSet, packagePrefix, originalPosition, module2, originalParent);
        this.fillClassNames(resultSet, packagePrefix, module2);
    }

    /*
     * WARNING - void declaration
     */
    private final void fillAliases(CompletionResultSet resultSet, String packagePrefix, PsiElement originalPosition, Module module, PsiElement originalParent) {
        PsiFile containingFile = this.getRealContainingFile(originalParent.getContainingFile());
        if (!(containingFile instanceof XmlFile)) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DomManager domManager = DomManager.getDomManager((Project)project2);
        Class[] classArray = new Class[]{PsiFile.class};
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, XmlTag.class, (boolean)false, (Class[])classArray);
        if (domManager.getDomElement(tag) instanceof Import) {
            return;
        }
        DomFileElement domFileElement = domManager.getFileElement((XmlFile)containingFile, Layout.class);
        if (domFileElement == null) {
            return;
        }
        DomFileElement file = domFileElement;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        GlobalSearchScope moduleScope = ProjectSystemUtil.getModuleSystem(module).getResolveScope(ScopeType.MAIN);
        for (Data data2 : ((Layout)file.getRootElement()).getDataElements()) {
            void $this$forEach$iv;
            String type;
            String alias;
            Object v4;
            Object element$iv2;
            PsiClass aClass;
            Import import_2;
            block8: {
                if (((CharSequence)packagePrefix).length() == 0) {
                    for (Import import_2 : data2.getImports()) {
                        String alias2;
                        XmlAttributeValue type2;
                        if (DataBindingUtil.getAlias(import_2) == null || import_2.getType().getXmlAttributeValue() == null) continue;
                        String string = type2.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        String typeValue = StringsKt.replace$default((String)string, (char)'$', (char)'.', (boolean)false, (int)4, null);
                        aClass = facade.findClass(typeValue, moduleScope);
                        if (aClass == null) continue;
                        resultSet.addElement((LookupElement)this.getClassReferenceElement(alias2, aClass));
                    }
                    continue;
                }
                String possibleAlias = StringsKt.substringBefore$default((String)packagePrefix, (char)'.', null, (int)2, null);
                List<Import> list = data2.getImports();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getImports(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Import import_3 = (Import)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)DataBindingUtil.getAlias(import_3), (Object)possibleAlias)) continue;
                    v4 = element$iv2;
                    break block8;
                }
                v4 = null;
            }
            if ((Import)v4 == null || import_2.getType().getStringValue() == null) continue;
            Intrinsics.checkNotNull((Object)DataBindingUtil.getAlias(import_2));
            String fqcn = StringsKt.replaceFirst$default((String)packagePrefix, (String)alias, (String)type, (boolean)false, (int)4, null);
            PsiClass psiClass = facade.findClass(fqcn, moduleScope);
            if (psiClass == null) continue;
            aClass = psiClass;
            PsiClass[] psiClassArray = aClass.getInnerClasses();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getInnerClasses(...)");
            element$iv2 = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])psiClassArray), DataBindingCompletionSupportImpl::fillAliases$lambda$1);
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                PsiClass innerClass = (PsiClass)element$iv3;
                boolean bl = false;
                String string = innerClass.getName();
                Intrinsics.checkNotNull((Object)string);
                Intrinsics.checkNotNull((Object)innerClass);
                resultSet.addElement((LookupElement)this.getClassReferenceElement(string, innerClass));
            }
        }
    }

    private final void fillClassNames(CompletionResultSet resultSet, String packagePrefix, Module module) {
        block7: {
            CharSequence $this$forEach$iv;
            GlobalSearchScope moduleScope;
            PsiPackage rootPackage;
            Project project;
            block6: {
                Project project2 = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
                rootPackage = javaPsiFacade.findPackage(packagePrefix);
                moduleScope = ProjectSystemUtil.getModuleSystem(module).getResolveScope(ScopeType.MAIN);
                if (rootPackage != null) break block6;
                PsiClass outerClass = javaPsiFacade.findClass(packagePrefix, moduleScope);
                if (outerClass == null) break block7;
                for (PsiClass innerClass : outerClass.getInnerClasses()) {
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(innerClass));
                }
                break block7;
            }
            PsiPackage[] psiPackageArray = rootPackage.getSubPackages(moduleScope);
            Intrinsics.checkNotNullExpressionValue((Object)psiPackageArray, (String)"getSubPackages(...)");
            Sequence outerClass = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])psiPackageArray), arg_0 -> DataBindingCompletionSupportImpl.fillClassNames$lambda$3(moduleScope, arg_0)), DataBindingCompletionSupportImpl::fillClassNames$lambda$5);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                PsiPackage pkg = (PsiPackage)element$iv;
                boolean bl = false;
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)pkg));
                Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"createWithIcon(...)");
                TailType tailType = TailTypes.dotType();
                Intrinsics.checkNotNullExpressionValue((Object)tailType, (String)"dotType(...)");
                resultSet.addElement((LookupElement)DataBindingCompletionUtilKt.withTypeDecorator(lookupElementBuilder, tailType));
            }
            $this$forEach$iv = rootPackage.getName();
            if ($this$forEach$iv == null || $this$forEach$iv.length() == 0) {
                Query query = AllClassesSearch.search((SearchScope)((SearchScope)moduleScope), (Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                Query query2 = query;
                Iterable $this$forEach$iv2 = query2.findAll();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    PsiClass psiClass = (PsiClass)element$iv;
                    boolean bl = false;
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(psiClass));
                }
            } else {
                for (PsiClass psiClass : rootPackage.getClasses(moduleScope)) {
                    resultSet.addElement((LookupElement)new JavaPsiClassReferenceElement(psiClass));
                }
            }
        }
    }

    @Contract(value="!null -> !null; null -> null")
    private final PsiFile getRealContainingFile(PsiFile file) {
        PsiFile psiFile = file;
        if (Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getFileElementType() : null), (Object)((Object)DbFileType.INSTANCE))) {
            PsiFile psiFile2 = file;
            return psiFile2 != null && (psiFile2 = psiFile2.getContext()) != null ? psiFile2.getContainingFile() : null;
        }
        return file;
    }

    private final JavaPsiClassReferenceElement getClassReferenceElement(String alias, PsiClass referenceClass) {
        JavaPsiClassReferenceElement element = new JavaPsiClassReferenceElement(referenceClass);
        element.setForcedPresentableName(alias);
        element.setInsertHandler(DataBindingCompletionSupportImpl::getClassReferenceElement$lambda$8);
        return element;
    }

    private static final boolean fillAliases$lambda$1(PsiClass innerClass) {
        return innerClass.getName() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean fillClassNames$lambda$3(GlobalSearchScope $moduleScope, PsiPackage pkg) {
        PsiPackage[] psiPackageArray = pkg.getSubPackages($moduleScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiPackageArray, (String)"getSubPackages(...)");
        if (((Object[])psiPackageArray).length != 0) return true;
        boolean bl = true;
        if (!bl) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        PsiClass[] psiClassArray = pkg.getClasses($moduleScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
        if (((Object[])psiClassArray).length != 0) return true;
        return false;
    }

    private static final boolean fillClassNames$lambda$5(PsiPackage pkg) {
        boolean bl;
        block1: {
            String string = pkg.getName();
            Intrinsics.checkNotNull((Object)string);
            CharSequence $this$all$iv = string;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char c = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isJavaIdentifierPart(c)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final void getClassReferenceElement$lambda$8(InsertionContext insertionContext, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/lang/databinding/completion/DataBindingCompletionSupportImpl$Companion;", "", "<init>", "()V", "getPackagePrefix", "", "context", "Lcom/intellij/psi/PsiElement;", "offset", "", "text", "", "intellij.android.lang-databinding"})
    @SourceDebugExtension(value={"SMAP\nDataBindingCompletionSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataBindingCompletionSupportImpl.kt\ncom/android/tools/idea/lang/databinding/completion/DataBindingCompletionSupportImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getPackagePrefix(PsiElement context, int offset) {
            CharSequence charSequence = context.getContainingFile().getViewProvider().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContents(...)");
            return this.getPackagePrefix(charSequence, offset);
        }

        @VisibleForTesting
        @NotNull
        public final String getPackagePrefix(@NotNull CharSequence text2, int offset) {
            String string;
            String startToOffset;
            int lastPeriodIndex;
            int startIndex;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            for (startIndex = offset; startIndex > 0; --startIndex) {
                char c = text2.charAt(startIndex - 1);
                boolean bl = false;
                boolean bl2 = Character.isJavaIdentifierPart(c) || c == '.';
                if (!bl2) break;
            }
            if ((lastPeriodIndex = StringsKt.lastIndexOf$default((CharSequence)(startToOffset = ((Object)text2.subSequence(startIndex, offset)).toString()), (char)'.', (int)0, (boolean)false, (int)6, null)) > 0) {
                String string2 = startToOffset.substring(0, lastPeriodIndex);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = "";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

