/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.proguardR8.inspections;

import com.android.tools.idea.lang.proguardR8.psi.ProguardR8QualifiedName;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/lang/proguardR8/inspections/AffectedClassesProjectService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "affectedClassesForQualifiedName", "", "qualifiedName", "Lcom/android/tools/idea/lang/proguardR8/psi/ProguardR8QualifiedName;", "limit", "qualifiedPattern", "", "applicationModules", "", "Lcom/intellij/openapi/module/Module;", "androidSdkScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "module", "patternRegex", "Lkotlin/text/Regex;", "asRegex", "intellij.android.lang"})
@SourceDebugExtension(value={"SMAP\nAffectedClassesProjectService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AffectedClassesProjectService.kt\ncom/android/tools/idea/lang/proguardR8/inspections/AffectedClassesProjectService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n24#2:171\n3829#3:172\n4344#3,2:173\n4135#3,11:175\n1#4:186\n*S KotlinDebug\n*F\n+ 1 AffectedClassesProjectService.kt\ncom/android/tools/idea/lang/proguardR8/inspections/AffectedClassesProjectService\n*L\n39#1:171\n92#1:172\n92#1:173,2\n100#1:175,11\n*E\n"})
public final class AffectedClassesProjectService {
    @NotNull
    private final Project project;
    @NotNull
    private final Regex patternRegex;

    public AffectedClassesProjectService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.patternRegex = new Regex("((?<prefix>.*)\\.)?\\*\\*(\\.\\*)?$");
    }

    private final Logger getLogger() {
        AffectedClassesProjectService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AffectedClassesProjectService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public final int affectedClassesForQualifiedName(@NotNull ProguardR8QualifiedName qualifiedName, int limit) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        String string = qualifiedName.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return this.affectedClassesForQualifiedName(string, limit);
    }

    @VisibleForTesting
    public final int affectedClassesForQualifiedName(@NotNull String qualifiedPattern, int limit) {
        int n;
        Intrinsics.checkNotNullParameter((Object)qualifiedPattern, (String)"qualifiedPattern");
        Regex regex = this.asRegex(qualifiedPattern);
        if (regex == null) {
            return 0;
        }
        Regex regex2 = regex;
        List<Module> appModules = this.applicationModules();
        if (!((Collection)appModules).isEmpty()) {
            Iterator iterator2 = ((Iterable)appModules).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Module module = (Module)iterator2.next();
            boolean bl = false;
            GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(false).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.androidSdkScope(module)));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"intersectWith(...)");
            GlobalSearchScope searchScope = globalSearchScope;
            Ref.IntRef counter = new Ref.IntRef();
            AllClassesSearch.search((SearchScope)((SearchScope)searchScope), (Project)this.project).forEach(arg_0 -> AffectedClassesProjectService.affectedClassesForQualifiedName$lambda$2$lambda$1(counter, limit, regex2, arg_0));
            int n2 = counter.element;
            while (iterator2.hasNext()) {
                GlobalSearchScope searchScope2;
                Module module2 = (Module)iterator2.next();
                $i$a$-maxOf-AffectedClassesProjectService$affectedClassesForQualifiedName$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)module2.getModuleWithDependenciesAndLibrariesScope(false).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.androidSdkScope(module2))), (String)"intersectWith(...)");
                Ref.IntRef counter2 = new Ref.IntRef();
                AllClassesSearch.search((SearchScope)((SearchScope)searchScope2), (Project)this.project).forEach(arg_0 -> AffectedClassesProjectService.affectedClassesForQualifiedName$lambda$2$lambda$1(counter2, limit, regex2, arg_0));
                int n3 = counter2.element;
                if (n2 >= n3) continue;
                n2 = n3;
            }
            n = n2;
        } else {
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Module> applicationModules() {
        void $this$filterTo$iv$iv;
        Module[] $this$filter$iv = ProjectUtil.getModules((Project)this.project);
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(ProjectSystemUtil.getModuleSystem((Module)it).isProductionAndroidModule() && ModuleSystemUtil.androidProjectType((Module)it) == AndroidModuleSystem.Type.TYPE_APP)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope androidSdkScope(Module module) {
        GlobalSearchScope globalSearchScope;
        void $this$filterIsInstanceTo$iv$iv;
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
        Object[] $this$filterIsInstance$iv = orderEntryArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JdkOrderEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        JdkOrderEntry jdk = (JdkOrderEntry)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        JdkOrderEntry jdkOrderEntry = jdk;
        if (Intrinsics.areEqual(jdkOrderEntry != null && (jdkOrderEntry = jdkOrderEntry.getJdk()) != null && (jdkOrderEntry = jdkOrderEntry.getSdkType()) != null ? jdkOrderEntry.getName() : null, (Object)"Android SDK")) {
            globalSearchScope = (GlobalSearchScope)new JdkScope(module.getProject(), jdk);
        } else {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.EMPTY_SCOPE;
            Intrinsics.checkNotNull((Object)globalSearchScope2);
            globalSearchScope = globalSearchScope2;
        }
        return globalSearchScope;
    }

    private final Regex asRegex(String $this$asRegex) {
        Regex regex;
        Object object;
        Object next;
        MatchResult matchResult = this.patternRegex.matchEntire((CharSequence)$this$asRegex);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"prefix");
        if (object2 == null || (object2 = object2.getValue()) == null) {
            object2 = "";
        }
        Object prefix = object2;
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int groupIndex = 0;
        block6: while (index < ((String)prefix).length()) {
            char c = ((String)prefix).charAt(index);
            switch (c) {
                case '.': {
                    builder.append("\\.");
                    ++index;
                    continue block6;
                }
                case '*': {
                    Object object3 = next = StringsKt.getOrNull((CharSequence)((CharSequence)prefix), (int)(index + 1));
                    char c2 = '*';
                    if (object3 != null && ((Character)object3).charValue() == c2) {
                        builder.append("(?<double" + groupIndex + ">.*)");
                        ++groupIndex;
                        index += 2;
                        continue block6;
                    }
                    builder.append("(?<single" + groupIndex + ">[^.]+)");
                    ++groupIndex;
                    ++index;
                    continue block6;
                }
            }
            builder.append(c);
            ++index;
        }
        builder.append("(?<everyThingElse>.*)");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String prefixPattern = string;
        next = $this$asRegex;
        try {
            Object $this$asRegex_u24lambda_u244 = next;
            boolean bl = false;
            object = Result.constructor-impl((Object)new Regex(prefixPattern));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object regexResult = object;
        if (Result.isFailure-impl((Object)regexResult)) {
            Throwable throwable = Result.exceptionOrNull-impl((Object)regexResult);
            Intrinsics.checkNotNull((Object)throwable);
            Throwable throwable2 = throwable;
            this.getLogger().warnWithDebug("Pattern (" + (String)prefix + ") translated to " + prefixPattern + ".", throwable2);
            regex = null;
        } else {
            regex = (Regex)(Result.isFailure-impl((Object)regexResult) ? null : regexResult);
        }
        return regex;
    }

    private static final boolean affectedClassesForQualifiedName$lambda$2$lambda$1(Ref.IntRef $counter, int $limit, Regex $regex, PsiClass psiClass) {
        block1: {
            String string = psiClass.getQualifiedName();
            if (string == null) break block1;
            String name2 = string;
            boolean bl = false;
            if ($regex.matches((CharSequence)name2)) {
                ++$counter.element;
            }
        }
        return $counter.element < $limit;
    }
}

