/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.model;

import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.DrawViewChild;
import com.android.tools.idea.layoutinspector.model.DrawViewImage;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.layoutinspector.SkiaViewNode;
import java.awt.Image;
import java.awt.Shape;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u0012*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00070\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/layoutinspector/model/ComponentImageLoader;", "", "nodeMap", "", "", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "skiaRoot", "Lcom/android/tools/layoutinspector/SkiaViewNode;", "<init>", "(Ljava/util/Map;Lcom/android/tools/layoutinspector/SkiaViewNode;)V", "skiaNodes", "Ljava/util/LinkedList;", "kotlin.jvm.PlatformType", "checkedTreeIds", "", "getCheckedTreeIds", "()Ljava/util/Set;", "loadImages", "", "window", "Lcom/android/tools/idea/layoutinspector/model/AndroidWindow;", "viewRoot", "clip", "Ljava/awt/Shape;", "addImages", "Lcom/android/tools/idea/layoutinspector/model/ViewNode$WriteAccess;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nComponentImageLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentImageLoader.kt\ncom/android/tools/idea/layoutinspector/model/ComponentImageLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,83:1\n1761#2,3:84\n1869#2,2:89\n2275#3,2:87\n*S KotlinDebug\n*F\n+ 1 ComponentImageLoader.kt\ncom/android/tools/idea/layoutinspector/model/ComponentImageLoader\n*L\n72#1:84,3\n45#1:89,2\n73#1:87,2\n*E\n"})
public final class ComponentImageLoader {
    @NotNull
    private final Map<Long, ViewNode> nodeMap;
    @NotNull
    private final LinkedList<SkiaViewNode> skiaNodes;
    @NotNull
    private final Set<Long> checkedTreeIds;

    public ComponentImageLoader(@NotNull Map<Long, ? extends ViewNode> nodeMap, @NotNull SkiaViewNode skiaRoot) {
        Intrinsics.checkNotNullParameter(nodeMap, (String)"nodeMap");
        Intrinsics.checkNotNullParameter((Object)skiaRoot, (String)"skiaRoot");
        this.nodeMap = nodeMap;
        this.skiaNodes = new LinkedList(SequencesKt.toList((Sequence)SequencesKt.filter(skiaRoot.flatten(), ComponentImageLoader::skiaNodes$lambda$0)));
        this.checkedTreeIds = new LinkedHashSet();
    }

    @NotNull
    public final Set<Long> getCheckedTreeIds() {
        return this.checkedTreeIds;
    }

    public final void loadImages(@NotNull AndroidWindow window2) {
        Intrinsics.checkNotNullParameter((Object)window2, (String)"window");
        this.loadImages(window2.getRoot(), window2.getDeviceClip());
        window2.skpLoadingComplete();
    }

    private final void loadImages(ViewNode viewRoot, Shape clip) {
        ViewNode.Companion.writeAccess(arg_0 -> ComponentImageLoader.loadImages$lambda$2(viewRoot, this, clip, arg_0));
    }

    private final void addImages(ViewNode.WriteAccess $this$addImages, ViewNode viewRoot, Shape clip) {
        while (!((Collection)this.skiaNodes).isEmpty()) {
            ViewNode viewNode;
            Image image;
            if (!SetsKt.plus(this.checkedTreeIds, (Object)viewRoot.getDrawId()).contains(this.skiaNodes.peek().getId())) {
                boolean bl;
                block7: {
                    Object it;
                    boolean bl2;
                    block6: {
                        Iterable $this$any$iv = this.skiaNodes;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (SkiaViewNode)element$iv;
                                boolean bl3 = false;
                                if (!(((SkiaViewNode)it).getId() == viewRoot.getDrawId())) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) break;
                    Sequence<ViewNode> $this$none$iv = $this$addImages.flatten(viewRoot);
                    boolean $i$f$none = false;
                    for (Object element$iv : $this$none$iv) {
                        it = (ViewNode)element$iv;
                        boolean bl4 = false;
                        if (!(((ViewNode)it).getDrawId() == this.skiaNodes.peek().getId())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
                if (!bl) break;
            }
            SkiaViewNode skiaNode = this.skiaNodes.poll();
            ViewNode correspondingNode = this.nodeMap.get(skiaNode.getId());
            if (skiaNode.getImage() == null || correspondingNode == null) continue;
            Shape shape = clip;
            $this$addImages.getDrawChildren(viewRoot).add(new DrawViewImage(image, viewNode, shape));
        }
    }

    private static final boolean skiaNodes$lambda$0(SkiaViewNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getImage() != null;
    }

    private static final boolean loadImages$lambda$2(ViewNode $viewRoot, ComponentImageLoader this$0, Shape $clip, ViewNode.WriteAccess $this$writeAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAccess, (String)"$this$writeAccess");
        $this$writeAccess.getDrawChildren($viewRoot).clear();
        this$0.addImages($this$writeAccess, $viewRoot, $clip);
        SkiaViewNode firstImage = null;
        firstImage = this$0.skiaNodes.peek();
        Iterable $this$forEach$iv = $this$writeAccess.getChildren($viewRoot);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewNode child = (ViewNode)element$iv;
            boolean bl = false;
            $this$writeAccess.getDrawChildren($viewRoot).add(new DrawViewChild(child));
            this$0.loadImages(child, $clip);
            if (this$0.skiaNodes.size() <= 0 || Intrinsics.areEqual((Object)this$0.skiaNodes.get(0), (Object)firstImage)) continue;
            this$0.addImages($this$writeAccess, $viewRoot, $clip);
            firstImage = this$0.skiaNodes.peek();
        }
        return this$0.checkedTreeIds.add($viewRoot.getDrawId());
    }
}

