/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.model;

import icons.StudioIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/layoutinspector/model/IconProvider;", "", "<init>", "()V", "getIconForView", "Ljavax/swing/Icon;", "qualifiedName", "", "isCompose", "", "getIconForViewNode", "viewName", "getIconForComposeViewNode", "nodeName", "intellij.android.layout-inspector"})
public final class IconProvider {
    @NotNull
    public static final IconProvider INSTANCE = new IconProvider();

    private IconProvider() {
    }

    @NotNull
    public final Icon getIconForView(@NotNull String qualifiedName, boolean isCompose) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        return isCompose ? this.getIconForComposeViewNode(qualifiedName) : this.getIconForViewNode(qualifiedName);
    }

    private final Icon getIconForViewNode(String viewName) {
        String simpleName = StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.substringAfterLast$default((String)viewName, (char)'.', null, (int)2, null), (CharSequence)"AppCompat"), (CharSequence)"Material");
        if (Intrinsics.areEqual((Object)simpleName, (Object)"root")) {
            Icon icon = StudioIcons.LayoutEditor.Palette.UNKNOWN_VIEW;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"UNKNOWN_VIEW");
            return icon;
        }
        Icon icon = AndroidDomElementDescriptorProvider.getIconForViewTag(simpleName);
        if (icon == null) {
            Icon icon2 = StudioIcons.LayoutEditor.Palette.UNKNOWN_VIEW;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"UNKNOWN_VIEW");
        }
        return icon;
    }

    private final Icon getIconForComposeViewNode(String nodeName) {
        Icon icon;
        switch (nodeName) {
            case "AppBar": {
                Icon icon2 = StudioIcons.LayoutEditor.Palette.APP_BAR_LAYOUT;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"APP_BAR_LAYOUT");
                break;
            }
            case "BasicText": {
                Icon icon3 = StudioIcons.LayoutEditor.Palette.TEXT_VIEW;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"TEXT_VIEW");
                break;
            }
            case "Box": {
                Icon icon4 = StudioIcons.LayoutEditor.Palette.VIEW;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"VIEW");
                break;
            }
            case "Button": {
                Icon icon5 = StudioIcons.LayoutEditor.Palette.BUTTON;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"BUTTON");
                break;
            }
            case "Card": {
                Icon icon6 = StudioIcons.LayoutEditor.Palette.CARD_VIEW;
                icon = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"CARD_VIEW");
                break;
            }
            case "Checkbox": {
                Icon icon7 = StudioIcons.LayoutEditor.Palette.CHECK_BOX;
                icon = icon7;
                Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"CHECK_BOX");
                break;
            }
            case "Column": {
                Icon icon8 = StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_VERT;
                icon = icon8;
                Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"LINEAR_LAYOUT_VERT");
                break;
            }
            case "CoreText": {
                Icon icon9 = StudioIcons.LayoutEditor.Palette.TEXT_VIEW;
                icon = icon9;
                Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"TEXT_VIEW");
                break;
            }
            case "Divider": {
                Icon icon10 = StudioIcons.LayoutEditor.Palette.HORIZONTAL_DIVIDER;
                icon = icon10;
                Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"HORIZONTAL_DIVIDER");
                break;
            }
            case "Icon": {
                Icon icon11 = StudioIcons.LayoutEditor.Palette.IMAGE_VIEW;
                icon = icon11;
                Intrinsics.checkNotNullExpressionValue((Object)icon11, (String)"IMAGE_VIEW");
                break;
            }
            case "IconButton": {
                Icon icon12 = StudioIcons.LayoutEditor.Palette.IMAGE_BUTTON;
                icon = icon12;
                Intrinsics.checkNotNullExpressionValue((Object)icon12, (String)"IMAGE_BUTTON");
                break;
            }
            case "Image": {
                Icon icon13 = StudioIcons.LayoutEditor.Palette.IMAGE_VIEW;
                icon = icon13;
                Intrinsics.checkNotNullExpressionValue((Object)icon13, (String)"IMAGE_VIEW");
                break;
            }
            case "Layout": {
                Icon icon14 = StudioIcons.LayoutEditor.Palette.VIEW;
                icon = icon14;
                Intrinsics.checkNotNullExpressionValue((Object)icon14, (String)"VIEW");
                break;
            }
            case "Row": {
                Icon icon15 = StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ;
                icon = icon15;
                Intrinsics.checkNotNullExpressionValue((Object)icon15, (String)"LINEAR_LAYOUT_HORZ");
                break;
            }
            case "Scaffold": {
                Icon icon16 = StudioIcons.LayoutEditor.Palette.COORDINATOR_LAYOUT;
                icon = icon16;
                Intrinsics.checkNotNullExpressionValue((Object)icon16, (String)"COORDINATOR_LAYOUT");
                break;
            }
            case "ScrollableColumn": {
                Icon icon17 = StudioIcons.LayoutEditor.Palette.NESTED_SCROLL_VIEW;
                icon = icon17;
                Intrinsics.checkNotNullExpressionValue((Object)icon17, (String)"NESTED_SCROLL_VIEW");
                break;
            }
            case "Surface": {
                Icon icon18 = StudioIcons.LayoutEditor.Palette.VIEW;
                icon = icon18;
                Intrinsics.checkNotNullExpressionValue((Object)icon18, (String)"VIEW");
                break;
            }
            case "Spacer": {
                Icon icon19 = StudioIcons.LayoutEditor.Palette.SPACE;
                icon = icon19;
                Intrinsics.checkNotNullExpressionValue((Object)icon19, (String)"SPACE");
                break;
            }
            case "Tab": {
                Icon icon20 = StudioIcons.LayoutEditor.Palette.TAB_ITEM;
                icon = icon20;
                Intrinsics.checkNotNullExpressionValue((Object)icon20, (String)"TAB_ITEM");
                break;
            }
            case "Text": {
                Icon icon21 = StudioIcons.LayoutEditor.Palette.TEXT_VIEW;
                icon = icon21;
                Intrinsics.checkNotNullExpressionValue((Object)icon21, (String)"TEXT_VIEW");
                break;
            }
            default: {
                Icon icon22 = StudioIcons.Compose.Editor.COMPOSABLE_FUNCTION;
                icon = icon22;
                Intrinsics.checkNotNullExpressionValue((Object)icon22, (String)"COMPOSABLE_FUNCTION");
            }
        }
        return icon;
    }
}

