/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.tree;

import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.tree.TreeSettingsKt;
import com.intellij.ide.util.PropertiesComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0002J \u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR$\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR$\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\r\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/layoutinspector/tree/InspectorTreeSettings;", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "activeClient", "Lkotlin/Function0;", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "value", "", "hideSystemNodes", "getHideSystemNodes", "()Z", "setHideSystemNodes", "(Z)V", "composeAsCallstack", "getComposeAsCallstack", "setComposeAsCallstack", "highlightSemantics", "getHighlightSemantics", "setHighlightSemantics", "supportLines", "getSupportLines", "setSupportLines", "showRecompositions", "getShowRecompositions", "setShowRecompositions", "hasCapability", "capability", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient$Capability;", "get", "key", "", "defaultValue", "set", "", "intellij.android.layout-inspector"})
public final class InspectorTreeSettings
implements TreeSettings {
    @NotNull
    private final Function0<InspectorClient> activeClient;
    private boolean highlightSemantics;

    public InspectorTreeSettings(@NotNull Function0<? extends InspectorClient> activeClient2) {
        Intrinsics.checkNotNullParameter(activeClient2, (String)"activeClient");
        this.activeClient = activeClient2;
    }

    @Override
    public boolean getHideSystemNodes() {
        return this.hasCapability(InspectorClient.Capability.SUPPORTS_SYSTEM_NODES) && this.get("live.layout.inspector.tree.hide.system", true);
    }

    @Override
    public void setHideSystemNodes(boolean value2) {
        this.set("live.layout.inspector.tree.hide.system", value2, true);
    }

    @Override
    public boolean getComposeAsCallstack() {
        return this.get("live.layout.inspector.tree.compose.callstack", true);
    }

    @Override
    public void setComposeAsCallstack(boolean value2) {
        this.set("live.layout.inspector.tree.compose.callstack", value2, true);
    }

    @Override
    public boolean getHighlightSemantics() {
        return this.highlightSemantics;
    }

    @Override
    public void setHighlightSemantics(boolean bl) {
        this.highlightSemantics = bl;
    }

    @Override
    public boolean getSupportLines() {
        return this.get("live.layout.inspector.tree.lines", true);
    }

    @Override
    public void setSupportLines(boolean value2) {
        this.set("live.layout.inspector.tree.lines", value2, true);
    }

    @Override
    public boolean getShowRecompositions() {
        return this.hasCapability(InspectorClient.Capability.SUPPORTS_COMPOSE_RECOMPOSITION_COUNTS) && this.get("live.layout.inspector.tree.recompositions", TreeSettingsKt.getDEFAULT_RECOMPOSITIONS());
    }

    @Override
    public void setShowRecompositions(boolean value2) {
        this.set("live.layout.inspector.tree.recompositions", value2, TreeSettingsKt.getDEFAULT_RECOMPOSITIONS());
    }

    private final boolean hasCapability(InspectorClient.Capability capability) {
        InspectorClient client = (InspectorClient)this.activeClient.invoke();
        if (!client.isConnected()) {
            return true;
        }
        return client.getCapabilities().contains((Object)capability);
    }

    private final boolean get(String key, boolean defaultValue) {
        return PropertiesComponent.getInstance().getBoolean(key, defaultValue);
    }

    private final void set(String key, boolean value2, boolean defaultValue) {
        PropertiesComponent.getInstance().setValue(key, value2, defaultValue);
    }

    @Override
    public boolean isInComponentTree(@NotNull ViewNode node) {
        return TreeSettings.super.isInComponentTree(node);
    }
}

