/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.tree;

import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.pipeline.DisconnectedClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcess;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetection;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessListener;
import com.android.tools.idea.layoutinspector.settings.LayoutInspectorSettings;
import com.android.tools.idea.layoutinspector.tree.RootPanelKt;
import com.android.tools.idea.layoutinspector.ui.AttachProgressProvider;
import com.android.tools.idea.layoutinspector.ui.LayoutInspectorLoadingObserver;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001+B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010'\u001a\u00020\u0010H\u0002J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020!H\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u0013\u001a\u0004\u0018\u00010!8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b#\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/layoutinspector/tree/RootPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "componentTreePanel", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/Disposable;Ljavax/swing/JComponent;)V", "isEmbedded", "", "()Z", "layoutInspectorLoadingObserver", "Lcom/android/tools/idea/layoutinspector/ui/LayoutInspectorLoadingObserver;", "connectionListener", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel$ConnectionListener;", "dispose", "", "attachProgressProvider", "Lcom/android/tools/idea/layoutinspector/ui/AttachProgressProvider;", "value", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "layoutInspector", "getLayoutInspector", "()Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "setLayoutInspector", "(Lcom/android/tools/idea/layoutinspector/LayoutInspector;)V", "foregroundProcessListener", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/ForegroundProcessListener;", "defaultPanel", "Ljavax/swing/JPanel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "processNotDebuggablePanel", "Lcom/android/tools/idea/layoutinspector/tree/RootPanel$UiState;", "uiState", "getUiState$annotations", "()V", "getUiState", "()Lcom/android/tools/idea/layoutinspector/tree/RootPanel$UiState;", "removeListeners", "updateUiState", "newUiState", "createLoadingObserver", "UiState", "intellij.android.layout-inspector"})
public final class RootPanel
extends BorderLayoutPanel
implements Disposable {
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final JComponent componentTreePanel;
    @Nullable
    private LayoutInspectorLoadingObserver layoutInspectorLoadingObserver;
    @NotNull
    private final InspectorModel.ConnectionListener connectionListener;
    @NotNull
    private final AttachProgressProvider attachProgressProvider;
    @Nullable
    private LayoutInspector layoutInspector;
    @NotNull
    private final ForegroundProcessListener foregroundProcessListener;
    @NotNull
    private final JPanel defaultPanel;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @NotNull
    private final JPanel processNotDebuggablePanel;
    @Nullable
    private UiState uiState;

    public RootPanel(@NotNull Disposable parentDisposable, @NotNull JComponent componentTreePanel) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)componentTreePanel, (String)"componentTreePanel");
        this.parentDisposable = parentDisposable;
        this.componentTreePanel = componentTreePanel;
        this.connectionListener = arg_0 -> RootPanel.connectionListener$lambda$0(this, arg_0);
        this.attachProgressProvider = new AttachProgressProvider((Function1<? super String, Unit>)((Function1)arg_0 -> RootPanel.attachProgressProvider$lambda$1(this, arg_0)));
        this.foregroundProcessListener = (arg_0, arg_1, arg_2) -> RootPanel.foregroundProcessListener$lambda$2(this, arg_0, arg_1, arg_2);
        Object[] objectArray = new String[]{"Waiting for Layout Inspector to connect.", LayoutInspectorBundle.INSTANCE.message("navigate.to.debuggable.application", new String[0])};
        this.defaultPanel = RootPanelKt.createCenterTextPanel(CollectionsKt.listOf((Object[])objectArray));
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.parentDisposable, 0);
        objectArray = new String[]{LayoutInspectorBundle.INSTANCE.message("application.not.inspectable", new String[0]), LayoutInspectorBundle.INSTANCE.message("navigate.to.debuggable.application", new String[0])};
        this.processNotDebuggablePanel = RootPanelKt.createCenterTextPanel(CollectionsKt.listOf((Object[])objectArray));
        Disposer.register((Disposable)this.parentDisposable, (Disposable)this);
        this.updateUiState(UiState.WAITING_TO_CONNECT);
    }

    private final boolean isEmbedded() {
        return LayoutInspectorSettings.Companion.getInstance().getEmbeddedLayoutInspectorEnabled();
    }

    public void dispose() {
        this.removeListeners();
    }

    @Nullable
    public final LayoutInspector getLayoutInspector() {
        return this.layoutInspector;
    }

    public final void setLayoutInspector(@Nullable LayoutInspector value2) {
        this.removeListeners();
        this.updateUiState(UiState.WAITING_TO_CONNECT);
        Object object = this.layoutInspector;
        if (object != null && (object = ((LayoutInspector)object).getInspectorModel()) != null) {
            ((InspectorModel)object).removeAttachStageListener(this.attachProgressProvider);
        }
        this.layoutInspector = value2;
        if (value2 == null) {
            return;
        }
        this.layoutInspectorLoadingObserver = this.createLoadingObserver(value2);
        value2.getInspectorModel().addConnectionListener(this.connectionListener);
        if (this.isEmbedded()) {
            ForegroundProcessDetection foregroundProcessDetection = value2.getForegroundProcessDetection();
            if (foregroundProcessDetection != null) {
                foregroundProcessDetection.addForegroundProcessListener(this.foregroundProcessListener);
            }
        }
        value2.getInspectorModel().addAttachStageListener(this.attachProgressProvider);
    }

    @Nullable
    public final UiState getUiState() {
        return this.uiState;
    }

    @VisibleForTesting
    public static /* synthetic */ void getUiState$annotations() {
    }

    private final void removeListeners() {
        block2: {
            ForegroundProcessDetection foregroundProcessDetection;
            Object object;
            Object object2 = this.layoutInspector;
            if (object2 != null && (object2 = ((LayoutInspector)object2).getInspectorModel()) != null) {
                ((InspectorModel)object2).removeConnectionListener(this.connectionListener);
            }
            if ((object = this.layoutInspector) != null && (object = ((LayoutInspector)object).getInspectorModel()) != null) {
                ((InspectorModel)object).removeAttachStageListener(this.attachProgressProvider);
            }
            LayoutInspector layoutInspector = this.layoutInspector;
            if (layoutInspector == null || (foregroundProcessDetection = layoutInspector.getForegroundProcessDetection()) == null) break block2;
            foregroundProcessDetection.removeForegroundProcessListener(this.foregroundProcessListener);
        }
    }

    private final void updateUiState(UiState newUiState) {
        ActionsKt.invokeLater$default(null, () -> RootPanel.updateUiState$lambda$3(this, newUiState), (int)1, null);
    }

    private final LayoutInspectorLoadingObserver createLoadingObserver(LayoutInspector layoutInspector) {
        LayoutInspectorLoadingObserver layoutInspectorLoadingObserver = new LayoutInspectorLoadingObserver(this.parentDisposable, layoutInspector);
        layoutInspectorLoadingObserver.getListeners().add((Object)new LayoutInspectorLoadingObserver.Listener(this){
            final /* synthetic */ RootPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStartLoading() {
                RootPanel.access$updateUiState(this.this$0, UiState.START_LOADING);
            }

            public void onStopLoading() {
            }
        });
        return layoutInspectorLoadingObserver;
    }

    private static final void connectionListener$lambda$0(RootPanel this$0, InspectorClient inspectorClient) {
        Intrinsics.checkNotNullParameter((Object)inspectorClient, (String)"inspectorClient");
        if (Intrinsics.areEqual((Object)inspectorClient, (Object)DisconnectedClient.INSTANCE)) {
            this$0.updateUiState(UiState.WAITING_TO_CONNECT);
        } else if (inspectorClient.isConnected()) {
            this$0.updateUiState(UiState.SHOW_TREE);
        }
    }

    private static final Unit attachProgressProvider$lambda$1(RootPanel this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.loadingPanel.setLoadingText(it);
        return Unit.INSTANCE;
    }

    private static final void foregroundProcessListener$lambda$2(RootPanel this$0, DeviceDescriptor deviceDescriptor, ForegroundProcess foregroundProcess, boolean isDebuggable) {
        Intrinsics.checkNotNullParameter((Object)deviceDescriptor, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)foregroundProcess, (String)"<unused var>");
        Object object = this$0.layoutInspector;
        boolean bl = object != null && (object = ((LayoutInspector)object).getCurrentClient()) != null ? object.isConnected() : false;
        if (bl) {
            return;
        }
        if (isDebuggable) {
            this$0.updateUiState(UiState.WAITING_TO_CONNECT);
        } else {
            this$0.updateUiState(UiState.PROCESS_NOT_DEBUGGABLE);
        }
    }

    private static final Unit updateUiState$lambda$3(RootPanel this$0, UiState $newUiState) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this$0.uiState == $newUiState) {
            return Unit.INSTANCE;
        }
        this$0.uiState = $newUiState;
        this$0.remove(this$0.defaultPanel);
        this$0.remove(this$0.componentTreePanel);
        this$0.remove(this$0.processNotDebuggablePanel);
        this$0.remove((Component)this$0.loadingPanel);
        switch (WhenMappings.$EnumSwitchMapping$0[$newUiState.ordinal()]) {
            case 1: {
                BorderLayoutPanel borderLayoutPanel = this$0.addToCenter(this$0.processNotDebuggablePanel);
                BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
                Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToCenter(...)");
                break;
            }
            case 2: {
                BorderLayoutPanel borderLayoutPanel = this$0.addToCenter(this$0.componentTreePanel);
                BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
                Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToCenter(...)");
                break;
            }
            case 3: {
                BorderLayoutPanel borderLayoutPanel = this$0.addToCenter(this$0.defaultPanel);
                BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
                Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToCenter(...)");
                break;
            }
            case 4: {
                this$0.addToCenter((Component)this$0.loadingPanel);
                this$0.loadingPanel.startLoading();
                BorderLayoutPanel borderLayoutPanel2 = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this$0.revalidate();
        this$0.repaint();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateUiState(RootPanel $this, UiState newUiState) {
        $this.updateUiState(newUiState);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/layoutinspector/tree/RootPanel$UiState;", "", "<init>", "(Ljava/lang/String;I)V", "PROCESS_NOT_DEBUGGABLE", "SHOW_TREE", "WAITING_TO_CONNECT", "START_LOADING", "intellij.android.layout-inspector"})
    public static final class UiState
    extends Enum<UiState> {
        public static final /* enum */ UiState PROCESS_NOT_DEBUGGABLE = new UiState();
        public static final /* enum */ UiState SHOW_TREE = new UiState();
        public static final /* enum */ UiState WAITING_TO_CONNECT = new UiState();
        public static final /* enum */ UiState START_LOADING = new UiState();
        private static final /* synthetic */ UiState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UiState[] values() {
            return (UiState[])$VALUES.clone();
        }

        public static UiState valueOf(String value2) {
            return Enum.valueOf(UiState.class, value2);
        }

        @NotNull
        public static EnumEntries<UiState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = uiStateArray = new UiState[]{UiState.PROCESS_NOT_DEBUGGABLE, UiState.SHOW_TREE, UiState.WAITING_TO_CONNECT, UiState.START_LOADING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UiState.values().length];
            try {
                nArray[UiState.PROCESS_NOT_DEBUGGABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UiState.SHOW_TREE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UiState.WAITING_TO_CONNECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UiState.START_LOADING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

