/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.rendering.webp.ConvertToWebpAction;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.module.AndroidModuleInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;

public class AndroidLintConvertToWebpInspection
extends AndroidLintInspectionBase {
    public AndroidLintConvertToWebpInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.convert.to.webp", new Object[0]), IconDetector.WEBP_ELIGIBLE);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        return new LintIdeQuickFix[]{new DefaultLintQuickFix(this, "Convert images to WebP..."){

            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                return AndroidFacet.getInstance((PsiElement)startElement) != null;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                AndroidFacet facet = AndroidFacet.getInstance((PsiElement)startElement);
                if (facet != null) {
                    AndroidModuleInfo info = StudioAndroidModuleInfo.getInstance(facet);
                    int minSdkVersion2 = info.getMinSdkVersion().getApiLevel();
                    List<VirtualFile> folders = ResourceFolderManager.getInstance(facet).getFolders();
                    ConvertToWebpAction action2 = new ConvertToWebpAction();
                    action2.perform(startElement.getProject(), minSdkVersion2, folders.toArray(VirtualFile.EMPTY_ARRAY));
                }
            }
        }};
    }
}

