/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.repository.WellKnownMavenArtifactId;
import com.android.support.AndroidxName;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.DependencyType;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.RegisteredDependencyId;
import com.android.tools.idea.projectsystem.RegisteredDependencyQueryId;
import com.android.tools.idea.projectsystem.RegisteringModuleSystem;
import com.android.tools.lint.checks.ExifInterfaceDetector;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

public class AndroidLintExifInterfaceInspection
extends AndroidLintInspectionBase {
    private static final AndroidxName NEW_EXIF_INTERFACE = new AndroidxName("android.support.media.ExifInterface", "androidx.exifinterface.media.ExifInterface");
    private static final AndroidxName NEW_EXIF_PACKAGE = new AndroidxName("android.support.media", "androidx.exifinterface.media");

    public AndroidLintExifInterfaceInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.exif.interface", new Object[0]), ExifInterfaceDetector.ISSUE);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        return new LintIdeQuickFix[]{new ReplaceExifFix()};
    }

    private static class ReplaceExifFix
    extends DefaultLintQuickFix {
        ReplaceExifFix() {
            super("Update all references in this file");
        }

        public boolean startInWriteAction() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            Module module = AndroidPsiUtils.getModuleSafely((PsiElement)startElement);
            if (module != null) {
                LocalHistoryAction action2 = LocalHistory.getInstance().startAction(this.getName());
                Project project = module.getProject();
                PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(NEW_EXIF_INTERFACE.newName(), GlobalSearchScope.allScope((Project)project));
                if (cls != null) {
                    ReplaceExifFix.replaceReferences(this.getName(), startElement, cls, true);
                    return;
                }
                cls = JavaPsiFacade.getInstance((Project)project).findClass(NEW_EXIF_INTERFACE.oldName(), GlobalSearchScope.allScope((Project)project));
                if (cls != null) {
                    ReplaceExifFix.replaceReferences(this.getName(), startElement, cls, false);
                    return;
                }
                AndroidModuleSystem androidModuleSystem = ProjectSystemUtil.getModuleSystem(module);
                boolean useAndroidX2 = androidModuleSystem.getUseAndroidX();
                RegisteringModuleSystem<RegisteredDependencyQueryId, RegisteredDependencyId> moduleSystem = androidModuleSystem.getRegisteringModuleSystem();
                WellKnownMavenArtifactId id2 = ReplaceExifFix.getExifArtifactId(useAndroidX2);
                try {
                    WriteCommandAction.writeCommandAction((Project)module.getProject()).withName(this.getName()).run(() -> {
                        if (moduleSystem != null) {
                            moduleSystem.registerDependency(id2, DependencyType.IMPLEMENTATION);
                        }
                        this.syncAndReplaceReferences(project, startElement, useAndroidX2);
                    });
                }
                finally {
                    action2.finish();
                }
            }
        }

        private void syncAndReplaceReferences(final @NotNull Project project, final @NotNull PsiElement startElement, final boolean useAndroidx) {
            assert (ApplicationManager.getApplication().isDispatchThread());
            ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getProjectSystem(project).getSyncManager().requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
            Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

                public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult syncResult) {
                    if (syncResult != null && syncResult.isSuccessful()) {
                        DumbService.getInstance((Project)project).runWhenSmart(() -> ReplaceExifFix.replaceReferences(this.getName(), startElement, null, useAndroidx));
                    }
                }

                public void onFailure(Throwable t) {
                    if (!(t instanceof CancellationException)) {
                        Logger.getInstance(AndroidLintExifInterfaceInspection.class).warn(t);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        @NotNull
        private static WellKnownMavenArtifactId getExifArtifactId(boolean useAndroidX2) {
            return useAndroidX2 ? GoogleMavenArtifactId.ANDROIDX_EXIFINTERFACE : GoogleMavenArtifactId.SUPPORT_EXIFINTERFACE;
        }

        private static void replaceJavaReferences(@NotNull PsiElement element, final @Nullable PsiClass cls, final boolean useAndroidx) {
            Project project = element.getProject();
            final PsiElementFactory factory2 = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiFile file = element.getContainingFile();
            file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement expression) {
                    if ("ExifInterface".equals(expression.getReferenceName()) && expression.isQualified()) {
                        PsiElement context = expression.getParent();
                        if (expression instanceof PsiReferenceExpression) {
                            if (cls != null) {
                                PsiReferenceExpression replacement = factory2.createReferenceExpression(cls);
                                expression.replace((PsiElement)replacement);
                                return;
                            }
                        } else {
                            expression.replace((PsiElement)factory2.createReferenceFromText(useAndroidx ? NEW_EXIF_INTERFACE.newName() : NEW_EXIF_INTERFACE.oldName(), context));
                            return;
                        }
                    }
                    super.visitReferenceElement(expression);
                }
            });
        }

        private static void replaceKotlinReferences(@NotNull PsiElement element, @Nullable PsiClass cls, final boolean useAndroidx) {
            Project project = element.getProject();
            final KtPsiFactory factory2 = new KtPsiFactory(project);
            PsiFile file = element.getContainingFile();
            file.accept((PsiElementVisitor)new KtTreeVisitorVoid(){

                public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
                    KtReferenceExpression reference;
                    KtExpression receiver2 = expression.getReceiverExpression();
                    KtExpression selector = expression.getSelectorExpression();
                    if (selector instanceof KtCallExpression) {
                        KtCallExpression call = (KtCallExpression)selector;
                        KtExpression callee = call.getCalleeExpression();
                        if (callee != null && "ExifInterface".equals(callee.getText()) && "android.media".equals(receiver2.getText())) {
                            KtExpression replacement = factory2.createExpression(useAndroidx ? NEW_EXIF_PACKAGE.newName() : NEW_EXIF_PACKAGE.oldName());
                            receiver2.replace((PsiElement)replacement);
                        }
                    } else if (selector instanceof KtReferenceExpression && "ExifInterface".equals((reference = (KtReferenceExpression)selector).getText())) {
                        KtExpression replacement = factory2.createExpression(useAndroidx ? NEW_EXIF_PACKAGE.newName() : NEW_EXIF_PACKAGE.oldName());
                        receiver2.replace((PsiElement)replacement);
                    }
                    super.visitDotQualifiedExpression(expression);
                }
            });
        }

        private static void replaceReferences(@NotNull String actionName, @NotNull PsiElement element, @Nullable PsiClass cls, boolean useAndroidx) {
            WriteCommandAction.writeCommandAction((Project)element.getProject()).withName(actionName).run(() -> {
                PsiFile file = element.getContainingFile();
                if (file instanceof PsiJavaFile) {
                    ReplaceExifFix.replaceJavaReferences(element, cls, useAndroidx);
                } else if (file instanceof KtFile) {
                    ReplaceExifFix.replaceKotlinReferences(element, cls, useAndroidx);
                }
            });
        }
    }
}

