/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.assistant.OpenAssistSidePanelAction;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.inspections.IgnoreTargetSdkEditFixKt;
import com.android.tools.idea.lint.inspections.LaunchTargetSdkVersionAssistantFixKt;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/lint/inspections/LaunchTargetSdkVersionAssistantFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "<init>", "(Lcom/android/tools/lint/detector/api/LintFix;)V", "tsdkv", "", "sdkUpgradeAssistantHasSupport", "", "getSdkUpgradeAssistantHasSupport", "()Z", "isApplicable", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "apply", "", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.android.lint"})
@SourceDebugExtension(value={"SMAP\nLaunchTargetSdkVersionAssistantFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchTargetSdkVersionAssistantFix.kt\ncom/android/tools/idea/lint/inspections/LaunchTargetSdkVersionAssistantFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class LaunchTargetSdkVersionAssistantFix
extends DefaultLintQuickFix {
    private final int tsdkv;

    /*
     * WARNING - void declaration
     */
    public LaunchTargetSdkVersionAssistantFix(@Nullable LintFix fix) {
        super("Launch Android SDK Upgrade Assistant");
        int n;
        LaunchTargetSdkVersionAssistantFix launchTargetSdkVersionAssistantFix = this;
        LintFix lintFix = fix;
        if (lintFix != null) {
            void it;
            LintFix lintFix2 = lintFix;
            LaunchTargetSdkVersionAssistantFix launchTargetSdkVersionAssistantFix2 = launchTargetSdkVersionAssistantFix;
            boolean bl = false;
            int n2 = LintFix.Companion.getInt((LintFix)it, "currentTargetSdkVersion", -1);
            launchTargetSdkVersionAssistantFix = launchTargetSdkVersionAssistantFix2;
            n = n2;
        } else {
            n = -1;
        }
        launchTargetSdkVersionAssistantFix.tsdkv = n;
    }

    private final boolean getSdkUpgradeAssistantHasSupport() {
        int n = LaunchTargetSdkVersionAssistantFixKt.access$getMaxSdkUpgradeAsstVersion();
        int n2 = this.tsdkv;
        return 26 <= n2 ? n2 <= n : false;
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        return IdeInfo.getInstance().isAndroidStudio() && this.getSdkUpgradeAssistantHasSupport();
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = startElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        IgnoreTargetSdkEditFixKt.stopFlaggingTargetSdkEditsForSession(project);
        new OpenAssistSidePanelAction().openWindow("DeveloperServices.TargetSDKVersionUpgradeAssistant", startElement.getProject());
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

