/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.gradle.model.IdeBuildType;
import com.android.tools.idea.gradle.model.IdeBuildTypeContainer;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.utils.Pair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.EditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveToDebugManifestQuickFix
extends DefaultLintQuickFix {
    public MoveToDebugManifestQuickFix() {
        super("Move to debug-specific manifest");
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag parent;
        XmlAttribute attribute2 = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class);
        if (attribute2 != null && (parent = attribute2.getParent()) != null && parent.getName().equals("uses-permission")) {
            AndroidFacet facet;
            Module module = MoveToDebugManifestQuickFix.getModule((PsiElement)parent);
            assert ("android.permission.ACCESS_MOCK_LOCATION".equals(parent.getAttributeValue("name", "http://schemas.android.com/apk/res/android")));
            parent.delete();
            if (module != null && (facet = AndroidFacet.getInstance((Module)module)) != null) {
                VirtualFile mainManifest = SourceProviderManager.getInstance(facet).getMainManifestFile();
                GradleAndroidModel androidModel = GradleAndroidModel.get(facet);
                if (androidModel != null && mainManifest != null && mainManifest.getParent() != null && mainManifest.getParent().getParent() != null && androidModel.getAndroidProject().getMultiVariantData() != null) {
                    VirtualFile src = mainManifest.getParent().getParent();
                    for (IdeBuildTypeContainer container : androidModel.getAndroidProject().getMultiVariantData().getBuildTypes()) {
                        IdeBuildType buildType = container.getBuildType();
                        if (!buildType.isDebuggable()) continue;
                        this.addManifest(module, src, buildType.getName());
                        return;
                    }
                    Messages.showErrorDialog((Project)module.getProject(), (String)"Did not find a debug build type", (String)"Move Permission");
                }
            }
        }
    }

    private void addManifest(@NotNull Module module, final @NotNull VirtualFile src, final @NotNull String buildTypeName) {
        Project project = module.getProject();
        final VirtualFile manifest = src.findFileByRelativePath(buildTypeName + "/AndroidManifest.xml");
        Pair result2 = (Pair)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Pair<String, VirtualFile>>(){

            public Pair<String, VirtualFile> compute() {
                String text2;
                int index;
                if (manifest == null) {
                    try {
                        VirtualFile newParentFolder = src.findChild(buildTypeName);
                        if (newParentFolder == null && (newParentFolder = src.createChildDirectory((Object)this, buildTypeName)) == null) {
                            String message = String.format("Could not create folder %1$s in %2$s", buildTypeName, src.getPath());
                            return Pair.of((Object)message, null);
                        }
                        VirtualFile newFile = newParentFolder.createChildData((Object)this, "AndroidManifest.xml");
                        String text3 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <uses-permission android:name=\"android.permission.ACCESS_MOCK_LOCATION\" />\n</manifest>\n";
                        VfsUtil.saveText((VirtualFile)newFile, (String)text3);
                        return Pair.of(null, (Object)newFile);
                    }
                    catch (IOException e) {
                        String message = String.format("Failed to create file: %1$s", e.getMessage());
                        return Pair.of((Object)message, null);
                    }
                }
                Document document = FileDocumentManager.getInstance().getDocument(manifest);
                if (document != null && (index = (text2 = document.getText()).lastIndexOf("</manifest>")) != -1) {
                    document.insertString(index, (CharSequence)"    <uses-permission android:name=\"android.permission.ACCESS_MOCK_LOCATION\" />\n");
                    return Pair.of(null, (Object)manifest);
                }
                return Pair.of((Object)("Could not add to " + String.valueOf(VfsUtilCore.virtualToIoFile((VirtualFile)manifest))), null);
            }
        });
        String error = (String)result2.getFirst();
        VirtualFile newFile = (VirtualFile)result2.getSecond();
        if (error != null) {
            Messages.showErrorDialog((Project)project, (String)error, (String)"Move Permission");
        } else {
            EditorUtil.openEditor(project, newFile);
            EditorUtil.selectEditor(project, newFile);
        }
    }

    @Nullable
    private static Module getModule(PsiElement element) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        return index.getModuleForFile(element.getContainingFile().getVirtualFile());
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class) != null;
    }
}

