/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.actions;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.actions.ActionExtensionsKt;
import com.android.tools.idea.logcat.actions.CreateScratchFileActionKt;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "scratchRootType", "Lcom/intellij/ide/scratch/ScratchRootType;", "Lorg/jetbrains/annotations/NotNull;", "navigationSupport", "Lcom/intellij/ide/util/PsiNavigationSupport;", "kotlin.jvm.PlatformType", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "EmbeddedLanguage", "EmbeddedData", "Companion", "intellij.android.logcat"})
public final class CreateScratchFileAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScratchRootType scratchRootType;
    private final PsiNavigationSupport navigationSupport;

    public CreateScratchFileAction() {
        super("Create a Scratch File from JSON/XML");
        ScratchRootType scratchRootType = ScratchRootType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)scratchRootType, (String)"getInstance(...)");
        this.scratchRootType = scratchRootType;
        this.navigationSupport = PsiNavigationSupport.getInstance();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setVisible(false);
        EmbeddedData embeddedData = Companion.findEmbeddedData$intellij_android_logcat(e);
        if (embeddedData == null) {
            return;
        }
        Language language = embeddedData.component2();
        Presentation presentation = e.getPresentation();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)language.getDisplayName(), (String)"getDisplayName(...)");
        presentation.setText(LogcatBundle.message("logcat.open.embedded.data.text", objectArray));
        LanguageFileType languageFileType = language.getAssociatedFileType();
        e.getPresentation().setIcon(languageFileType != null ? languageFileType.getIcon() : null);
        e.getPresentation().setVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        EmbeddedData embeddedData = Companion.findEmbeddedData$intellij_android_logcat(e);
        if (embeddedData == null) {
            return;
        }
        EmbeddedData embeddedData2 = embeddedData;
        String text2 = embeddedData2.component1();
        Language language = embeddedData2.component2();
        String string = ScratchFileCreationHelper.reformat((Project)project2, (Language)language, (String)text2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reformat(...)");
        String formatted = string;
        Object object = language.getAssociatedFileType();
        if (object == null || (object = object.getDefaultExtension()) == null) {
            object = "";
        }
        Object fileExtension = object;
        String string2 = PathUtil.makeFileName((String)"logcat", (String)fileExtension);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"makeFileName(...)");
        String fileName = string2;
        VirtualFile virtualFile = this.scratchRootType.createScratchFile(project2, fileName, language, formatted, ScratchFileService.Option.create_new_always);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        this.navigationSupport.createNavigatable(project2, file, 0).navigate(true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$Companion;", "", "<init>", "()V", "findEmbeddedData", "Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$EmbeddedData;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findEmbeddedData$intellij_android_logcat", "intellij.android.logcat"})
    @SourceDebugExtension(value={"SMAP\nCreateScratchFileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateScratchFileAction.kt\ncom/android/tools/idea/logcat/actions/CreateScratchFileAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1869#2,2:145\n*S KotlinDebug\n*F\n+ 1 CreateScratchFileAction.kt\ncom/android/tools/idea/logcat/actions/CreateScratchFileAction$Companion\n*L\n113#1:145,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final EmbeddedData findEmbeddedData$intellij_android_logcat(@NotNull AnActionEvent $this$findEmbeddedData) {
            Intrinsics.checkNotNullParameter((Object)$this$findEmbeddedData, (String)"<this>");
            Object object = ActionExtensionsKt.getLogcatMessage($this$findEmbeddedData);
            if (object == null || (object = ((LogcatMessage)object).getMessage()) == null) {
                return null;
            }
            Object message = object;
            Iterable $this$forEach$iv = (Iterable)EmbeddedLanguage.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EmbeddedLanguage it = (EmbeddedLanguage)((Object)element$iv);
                boolean bl = false;
                EmbeddedData data2 = it.findInText((String)message);
                if (data2 == null) continue;
                return data2;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$EmbeddedData;", "", "text", "", "language", "Lcom/intellij/lang/Language;", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/Language;)V", "getText", "()Ljava/lang/String;", "getLanguage", "()Lcom/intellij/lang/Language;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.logcat"})
    @VisibleForTesting
    public static final class EmbeddedData {
        @NotNull
        private final String text;
        @NotNull
        private final Language language;

        public EmbeddedData(@NotNull String text2, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this.text = text2;
            this.language = language;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Language component2() {
            return this.language;
        }

        @NotNull
        public final EmbeddedData copy(@NotNull String text2, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return new EmbeddedData(text2, language);
        }

        public static /* synthetic */ EmbeddedData copy$default(EmbeddedData embeddedData, String string, Language language, int n, Object object) {
            if ((n & 1) != 0) {
                string = embeddedData.text;
            }
            if ((n & 2) != 0) {
                language = embeddedData.language;
            }
            return embeddedData.copy(string, language);
        }

        @NotNull
        public String toString() {
            return "EmbeddedData(text=" + this.text + ", language=" + this.language + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.language.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EmbeddedData)) {
                return false;
            }
            EmbeddedData embeddedData = (EmbeddedData)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)embeddedData.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.language, (Object)embeddedData.language);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$EmbeddedLanguage;", "", "language", "Lcom/intellij/lang/Language;", "startChar", "", "endChar", "isValid", "Lkotlin/Function1;", "", "", "<init>", "(Ljava/lang/String;ILcom/intellij/lang/Language;CCLkotlin/jvm/functions/Function1;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getStartChar", "()C", "getEndChar", "()Lkotlin/jvm/functions/Function1;", "JSON", "XML", "findInText", "Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$EmbeddedData;", "text", "intellij.android.logcat"})
    private static final class EmbeddedLanguage
    extends Enum<EmbeddedLanguage> {
        @NotNull
        private final Language language;
        private final char startChar;
        private final char endChar;
        @NotNull
        private final Function1<String, Boolean> isValid;
        public static final /* enum */ EmbeddedLanguage JSON;
        public static final /* enum */ EmbeddedLanguage XML;
        private static final /* synthetic */ EmbeddedLanguage[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private EmbeddedLanguage(Language language, char startChar, char endChar, Function1<? super String, Boolean> isValid) {
            this.language = language;
            this.startChar = startChar;
            this.endChar = endChar;
            this.isValid = isValid;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        public final char getStartChar() {
            return this.startChar;
        }

        public final char getEndChar() {
            return this.endChar;
        }

        @NotNull
        public final Function1<String, Boolean> isValid() {
            return this.isValid;
        }

        @Nullable
        public final EmbeddedData findInText(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            int start2 = StringsKt.indexOf$default((CharSequence)text2, (char)this.startChar, (int)0, (boolean)false, (int)6, null);
            if (start2 < 0) {
                return null;
            }
            int end = StringsKt.lastIndexOf$default((CharSequence)text2, (char)this.endChar, (int)0, (boolean)false, (int)6, null);
            if (end < 0) {
                return null;
            }
            String string = text2.substring(start2, end + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String data2 = string;
            return (Boolean)this.isValid.invoke((Object)data2) != false ? new EmbeddedData(data2, this.language) : null;
        }

        public static EmbeddedLanguage[] values() {
            return (EmbeddedLanguage[])$VALUES.clone();
        }

        public static EmbeddedLanguage valueOf(String value2) {
            return Enum.valueOf(EmbeddedLanguage.class, value2);
        }

        @NotNull
        public static EnumEntries<EmbeddedLanguage> getEntries() {
            return $ENTRIES;
        }

        private static final boolean _init_$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return CreateScratchFileActionKt.access$isJson(it);
        }

        private static final boolean _init_$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return CreateScratchFileActionKt.access$isXml(it);
        }

        static {
            JsonLanguage jsonLanguage = JsonLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonLanguage, (String)"INSTANCE");
            JSON = new EmbeddedLanguage((Language)jsonLanguage, '{', '}', (Function1<? super String, Boolean>)((Function1)EmbeddedLanguage::_init_$lambda$0));
            XML = new EmbeddedLanguage((Language)XMLLanguage.INSTANCE, '<', '>', (Function1<? super String, Boolean>)((Function1)EmbeddedLanguage::_init_$lambda$1));
            $VALUES = embeddedLanguageArray = new EmbeddedLanguage[]{EmbeddedLanguage.JSON, EmbeddedLanguage.XML};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

