/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.actions;

import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.LogcatPresenter;
import com.android.tools.idea.logcat.actions.ActionExtensionsKt;
import com.android.tools.idea.logcat.actions.SaveLogcatActionKt;
import com.android.tools.idea.logcat.devices.Device;
import com.android.tools.idea.logcat.files.LogcatFileIo;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.util.LogcatLoggerKt;
import com.android.tools.idea.projectsystem.ProjectApplicationIdsProvider;
import com.android.tools.idea.run.ShowLogcatListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/logcat/actions/SaveLogcatAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getSavePath", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "OpenInEditorAction", "RevealLogcatFileAction", "OpenInLogcatAction", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nSaveLogcatAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveLogcatAction.kt\ncom/android/tools/idea/logcat/actions/SaveLogcatAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class SaveLogcatAction
extends DumbAwareAction {
    public SaveLogcatAction() {
        super(LogcatBundle.message("logcat.save.log.action.text", new Object[0]), null, AllIcons.ToolbarDecorator.Export);
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        LogcatPresenter logcatPresenter = ActionExtensionsKt.getLogcatPresenter(e);
        if (logcatPresenter != null) {
            void it;
            LogcatPresenter logcatPresenter2 = logcatPresenter;
            Presentation presentation2 = presentation;
            boolean bl2 = false;
            boolean bl3 = it.getSelectedDevice() != null && !it.isLogcatEmpty();
            presentation = presentation2;
            bl = bl3;
        } else {
            bl = false;
        }
        presentation.setEnabled(bl);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        LogcatPresenter logcatPresenter = ActionExtensionsKt.getLogcatPresenter(e);
        if (logcatPresenter == null) {
            return;
        }
        LogcatPresenter logcatPresenter2 = logcatPresenter;
        Device device2 = logcatPresenter2.getSelectedDevice();
        if (device2 == null) {
            return;
        }
        Device device3 = device2;
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(LogcatBundle.message("logcat.save.log.dialog.title", new Object[0]), "", "logcat"), project2);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog dialog2 = fileSaverDialog;
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HHmmss", Locale.ROOT).format(new Date());
        String deviceName = StringsKt.replace$default((String)device3.getName(), (char)' ', (char)'-', (boolean)false, (int)4, null);
        String systemInfo = "Android-" + device3.getRelease();
        String filename = SaveLogcatActionKt.access$adjustedForMac(deviceName + "-" + systemInfo + "_" + timestamp);
        Object object = dialog2.save(this.getSavePath(project2), filename);
        if (object == null || (object = object.getFile()) == null) {
            return;
        }
        Object file = object;
        PropertiesComponent.getInstance((Project)project2).setValue("Logcat.SavePath", ((File)file).getParent());
        List<LogcatMessage> logcatMessages = logcatPresenter2.getBacklogMessages();
        String filter2 = logcatPresenter2.getFilter();
        Object object2 = (ProjectApplicationIdsProvider)project2.getService(ProjectApplicationIdsProvider.class);
        if (object2 == null || (object2 = object2.getPackageNames()) == null) {
            object2 = SetsKt.emptySet();
        }
        Object projectApplicationIds = object2;
        BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.createCoroutineScope$default((Disposable)logcatPresenter2, null, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (int)1, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((File)file, logcatMessages, device3, filter2, (Set<String>)projectApplicationIds, project2, null){
            int label;
            final /* synthetic */ File $file;
            final /* synthetic */ List<LogcatMessage> $logcatMessages;
            final /* synthetic */ Device $device;
            final /* synthetic */ String $filter;
            final /* synthetic */ Set<String> $projectApplicationIds;
            final /* synthetic */ Project $project;
            {
                this.$file = $file;
                this.$logcatMessages = $logcatMessages;
                this.$device = $device;
                this.$filter = $filter;
                this.$projectApplicationIds = $projectApplicationIds;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        LogcatFileIo logcatFileIo = new LogcatFileIo(null, 1, null);
                        Path path = this.$file.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                        logcatFileIo.writeLogcat(path, this.$logcatMessages, this.$device, this.$filter, this.$projectApplicationIds);
                        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.$file);
                        if (virtualFile == null) {
                            LogcatLoggerKt.getLOGGER().warn("Failed to save Logcat file: " + this.$file);
                            return Unit.INSTANCE;
                        }
                        Notification notification = new Notification("Logcat", LogcatBundle.message("logcat.save.log.notification.text", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)new OpenInEditorAction(virtualFile)).addAction((AnAction)new RevealLogcatFileAction(virtualFile)).addAction((AnAction)new OpenInLogcatAction(virtualFile, this.$device.getName() + " Android " + this.$device.getRelease()));
                        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addAction(...)");
                        Notification notification2 = notification;
                        Notifications.Bus.notify((Notification)notification2, (Project)this.$project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private final VirtualFile getSavePath(Project project) {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        String lastPath = properties.getValue("Logcat.SavePath");
        return lastPath != null ? LocalFileSystem.getInstance().findFileByPath(lastPath) : ProjectUtil.guessProjectDir((Project)project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/logcat/actions/SaveLogcatAction$OpenInEditorAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.android.logcat"})
    private static final class OpenInEditorAction
    extends DumbAwareAction {
        @NotNull
        private final VirtualFile file;

        public OpenInEditorAction(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(LogcatBundle.message("logcat.save.log.notification.open.in.editor", new Object[0]));
            this.file = file;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            FileEditorManager.getInstance((Project)project2).openFile(this.file, true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/logcat/actions/SaveLogcatAction$OpenInLogcatAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "tabName", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.android.logcat"})
    private static final class OpenInLogcatAction
    extends DumbAwareAction {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final String tabName;

        public OpenInLogcatAction(@NotNull VirtualFile file, @NotNull String tabName) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
            super(LogcatBundle.message("logcat.save.log.notification.open.in.logcat", new Object[0]));
            this.file = file;
            this.tabName = tabName;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block0: {
                ShowLogcatListener showLogcatListener;
                MessageBus messageBus;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                if (project == null || (messageBus = project.getMessageBus()) == null || (showLogcatListener = (ShowLogcatListener)messageBus.syncPublisher(ShowLogcatListener.TOPIC)) == null) break block0;
                Path path = this.file.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                showLogcatListener.showLogcatFile(path, this.tabName);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/logcat/actions/SaveLogcatAction$RevealLogcatFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.android.logcat"})
    private static final class RevealLogcatFileAction
    extends DumbAwareAction {
        @NotNull
        private final VirtualFile file;

        public RevealLogcatFileAction(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(RevealFileAction.getActionName());
            this.file = file;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RevealFileAction.openFile((Path)this.file.toNioPath());
        }
    }
}

