/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.folding;

import com.android.tools.idea.logcat.folding.EditorFoldingDetector;
import com.android.tools.idea.logcat.folding.EditorFoldingDetectorKt;
import com.android.tools.idea.logcat.folding.ExceptionFolding;
import com.android.tools.idea.logcat.folding.FoldingDetector;
import com.android.tools.idea.logcat.util.EditorUtilsKt;
import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001 B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0015\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b\r2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/logcat/folding/EditorFoldingDetector;", "Lcom/android/tools/idea/logcat/folding/FoldingDetector;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "consoleFoldings", "", "Lcom/intellij/execution/ConsoleFolding;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "foldingModel", "Lcom/intellij/openapi/editor/FoldingModel;", "activeConsoleFoldings", "detectFoldings", "", "startLine", "", "endLine", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findPreviousRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "folding", "line", "shouldFoldLine", "", "addFoldRegion", "getLineText", "", "Folding", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nEditorFoldingDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorFoldingDetector.kt\ncom/android/tools/idea/logcat/folding/EditorFoldingDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n774#2:170\n865#2,2:171\n1563#2:174\n1634#2,3:175\n1#3:173\n*S KotlinDebug\n*F\n+ 1 EditorFoldingDetector.kt\ncom/android/tools/idea/logcat/folding/EditorFoldingDetector\n*L\n82#1:170\n82#1:171,2\n151#1:174\n151#1:175,3\n*E\n"})
public final class EditorFoldingDetector
implements FoldingDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Document document;
    @NotNull
    private final FoldingModel foldingModel;
    @NotNull
    private final List<ConsoleFolding> activeConsoleFoldings;

    /*
     * WARNING - void declaration
     */
    public EditorFoldingDetector(@NotNull Project project, @NotNull Editor editor, @NotNull List<? extends ConsoleFolding> consoleFoldings) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(consoleFoldings, (String)"consoleFoldings");
        this.project = project;
        this.editor = editor;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.document = document;
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        this.foldingModel = foldingModel;
        Iterable iterable = consoleFoldings;
        EditorFoldingDetector editorFoldingDetector = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConsoleFolding it = (ConsoleFolding)element$iv$iv;
            boolean bl = false;
            if (!it.isEnabledForConsole((ConsoleView)EditorFoldingDetectorKt.access$getConsoleView$p())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        editorFoldingDetector.activeConsoleFoldings = (List)destination$iv$iv;
    }

    public /* synthetic */ EditorFoldingDetector(Project project, Editor editor, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.plus((Collection)ConsoleFolding.EP_NAME.getExtensionList(), (Object)((Object)new ExceptionFolding()));
        }
        this(project, editor, list);
    }

    @Override
    @Nullable
    public Object detectFoldings(int startLine, int endLine, @NotNull Continuation<? super Unit> $completion) {
        if (this.activeConsoleFoldings.isEmpty()) {
            return Unit.INSTANCE;
        }
        List addList = new ArrayList();
        List removeList = new ArrayList();
        int version2 = EditorUtilsKt.getVersion(this.document);
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, version2, startLine, endLine, (List<FoldRegion>)removeList, (List<Folding>)addList, null){
            int label;
            final /* synthetic */ EditorFoldingDetector this$0;
            final /* synthetic */ int $version;
            final /* synthetic */ int $startLine;
            final /* synthetic */ int $endLine;
            final /* synthetic */ List<FoldRegion> $removeList;
            final /* synthetic */ List<Folding> $addList;
            {
                this.this$0 = $receiver;
                this.$version = $version;
                this.$startLine = $startLine;
                this.$endLine = $endLine;
                this.$removeList = $removeList;
                this.$addList = $addList;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CoroutinesKt.readAndEdtWriteAction(arg_0 -> detectFoldings.2.invokeSuspend$lambda$4(this.this$0, this.$version, this.$startLine, this.$endLine, this.$removeList, this.$addList, arg_0), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$4$lambda$3$lambda$2(List $removeList, List $addList, EditorFoldingDetector this$0) {
                Object it;
                Iterable $this$forEach$iv = $removeList;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (FoldRegion)element$iv;
                    boolean bl = false;
                    EditorFoldingDetector.access$getFoldingModel$p(this$0).removeFoldRegion((FoldRegion)it);
                }
                $this$forEach$iv = $addList;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (Folding)element$iv;
                    boolean bl = false;
                    EditorFoldingDetector.access$addFoldRegion(this$0, ((Folding)it).getFolding(), ((Folding)it).getStartLine(), ((Folding)it).getEndLine());
                }
            }

            private static final Unit invokeSuspend$lambda$4$lambda$3(EditorFoldingDetector this$0, List $removeList, List $addList) {
                EditorFoldingDetector.access$getFoldingModel$p(this$0).runBatchFoldingOperation(() -> detectFoldings.2.invokeSuspend$lambda$4$lambda$3$lambda$2($removeList, $addList, this$0));
                return Unit.INSTANCE;
            }

            private static final ReadResult invokeSuspend$lambda$4(EditorFoldingDetector this$0, int $version, int $startLine, int $endLine, List $removeList, List $addList, ReadAndWriteScope $this$readAndEdtWriteAction) {
                if (EditorUtilsKt.getVersion(EditorFoldingDetector.access$getDocument$p(this$0)) != $version) {
                    return $this$readAndEdtWriteAction.value((Object)Unit.INSTANCE);
                }
                for (ConsoleFolding folding : EditorFoldingDetector.access$getActiveConsoleFoldings$p(this$0)) {
                    int line = $startLine;
                    while (line <= $endLine) {
                        int n;
                        if (!EditorFoldingDetector.access$shouldFoldLine(this$0, folding, line)) {
                            ++line;
                            continue;
                        }
                        FoldRegion previousRegion = EditorFoldingDetector.access$findPreviousRegion(this$0, folding, line, $startLine);
                        if (previousRegion != null) {
                            int n2;
                            $removeList.add(previousRegion);
                            boolean bl = folding.shouldBeAttachedToThePreviousLine();
                            if (bl) {
                                n2 = previousRegion.getStartOffset() + 1;
                            } else if (!bl) {
                                n2 = previousRegion.getStartOffset();
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            int startOffset = n2;
                            n = EditorFoldingDetector.access$getDocument$p(this$0).getLineNumber(startOffset);
                        } else {
                            n = line;
                        }
                        int foldStartLine = n;
                        ++line;
                        while (line <= $endLine && EditorFoldingDetector.access$shouldFoldLine(this$0, folding, line)) {
                            ++line;
                        }
                        $addList.add(new Folding(folding, foldStartLine, line - 1));
                    }
                }
                return $addList.isEmpty() && $removeList.isEmpty() ? $this$readAndEdtWriteAction.value((Object)Unit.INSTANCE) : $this$readAndEdtWriteAction.writeAction(() -> detectFoldings.2.invokeSuspend$lambda$4$lambda$3(this$0, $removeList, $addList));
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final FoldRegion findPreviousRegion(ConsoleFolding folding, int line, int startLine) {
        if (line == startLine && line > 0 && this.shouldFoldLine(folding, line - 1)) {
            FoldRegion region;
            FoldRegion foldRegion;
            FoldRegion[] foldRegionArray = this.foldingModel.getAllFoldRegions();
            Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
            FoldRegion foldRegion2 = (FoldRegion)ArraysKt.lastOrNull((Object[])foldRegionArray);
            if (foldRegion2 == null) {
                return null;
            }
            FoldRegion it = foldRegion = (region = foldRegion2);
            boolean bl = false;
            return this.document.getLineNumber(region.getEndOffset()) == line - 1 ? foldRegion : null;
        }
        return null;
    }

    private final boolean shouldFoldLine(ConsoleFolding folding, int line) {
        return folding.shouldFoldLine(this.project, this.getLineText(line));
    }

    /*
     * WARNING - void declaration
     */
    private final void addFoldRegion(ConsoleFolding folding, int startLine, int endLine) {
        block2: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)new IntRange(startLine, endLine);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void p0;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.getLineText((int)p0));
            }
            List lines = (List)destination$iv$iv;
            int it = this.document.getLineStartOffset(startLine);
            boolean bl = false;
            int startOffset = folding.shouldBeAttachedToThePreviousLine() && it > 0 ? it - 1 : it;
            int endOffset = this.document.getLineEndOffset(endLine);
            String string = folding.getPlaceholderText(this.project, lines);
            if (string == null) {
                return;
            }
            String placeholder = string;
            FoldRegion foldRegion = this.editor.getFoldingModel().addFoldRegion(startOffset, endOffset, placeholder);
            if (foldRegion == null) break block2;
            FoldRegion it2 = foldRegion;
            boolean bl2 = false;
            it2.setExpanded(false);
        }
    }

    private final String getLineText(int line) {
        String string = EditorHyperlinkSupport.getLineText((Document)this.document, (int)line, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineText(...)");
        return string;
    }

    public static final /* synthetic */ FoldingModel access$getFoldingModel$p(EditorFoldingDetector $this) {
        return $this.foldingModel;
    }

    public static final /* synthetic */ void access$addFoldRegion(EditorFoldingDetector $this, ConsoleFolding folding, int startLine, int endLine) {
        $this.addFoldRegion(folding, startLine, endLine);
    }

    public static final /* synthetic */ Document access$getDocument$p(EditorFoldingDetector $this) {
        return $this.document;
    }

    public static final /* synthetic */ List access$getActiveConsoleFoldings$p(EditorFoldingDetector $this) {
        return $this.activeConsoleFoldings;
    }

    public static final /* synthetic */ boolean access$shouldFoldLine(EditorFoldingDetector $this, ConsoleFolding folding, int line) {
        return $this.shouldFoldLine(folding, line);
    }

    public static final /* synthetic */ FoldRegion access$findPreviousRegion(EditorFoldingDetector $this, ConsoleFolding folding, int line, int startLine) {
        return $this.findPreviousRegion(folding, line, startLine);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/logcat/folding/EditorFoldingDetector$Folding;", "", "folding", "Lcom/intellij/execution/ConsoleFolding;", "startLine", "", "endLine", "<init>", "(Lcom/intellij/execution/ConsoleFolding;II)V", "getFolding", "()Lcom/intellij/execution/ConsoleFolding;", "getStartLine", "()I", "getEndLine", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.logcat"})
    private static final class Folding {
        @NotNull
        private final ConsoleFolding folding;
        private final int startLine;
        private final int endLine;

        public Folding(@NotNull ConsoleFolding folding, int startLine, int endLine) {
            Intrinsics.checkNotNullParameter((Object)folding, (String)"folding");
            this.folding = folding;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @NotNull
        public final ConsoleFolding getFolding() {
            return this.folding;
        }

        public final int getStartLine() {
            return this.startLine;
        }

        public final int getEndLine() {
            return this.endLine;
        }

        @NotNull
        public final ConsoleFolding component1() {
            return this.folding;
        }

        public final int component2() {
            return this.startLine;
        }

        public final int component3() {
            return this.endLine;
        }

        @NotNull
        public final Folding copy(@NotNull ConsoleFolding folding, int startLine, int endLine) {
            Intrinsics.checkNotNullParameter((Object)folding, (String)"folding");
            return new Folding(folding, startLine, endLine);
        }

        public static /* synthetic */ Folding copy$default(Folding folding, ConsoleFolding consoleFolding, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                consoleFolding = folding.folding;
            }
            if ((n3 & 2) != 0) {
                n = folding.startLine;
            }
            if ((n3 & 4) != 0) {
                n2 = folding.endLine;
            }
            return folding.copy(consoleFolding, n, n2);
        }

        @NotNull
        public String toString() {
            return "Folding(folding=" + this.folding + ", startLine=" + this.startLine + ", endLine=" + this.endLine + ")";
        }

        public int hashCode() {
            int result2 = this.folding.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.startLine);
            result2 = result2 * 31 + Integer.hashCode(this.endLine);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Folding)) {
                return false;
            }
            Folding folding = (Folding)other;
            if (!Intrinsics.areEqual((Object)this.folding, (Object)folding.folding)) {
                return false;
            }
            if (this.startLine != folding.startLine) {
                return false;
            }
            return this.endLine == folding.endLine;
        }
    }
}

