/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.download;

import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import com.android.tools.idea.material.icons.common.MaterialIconsUrlProvider;
import com.android.tools.idea.material.icons.download.IconsUpdateData;
import com.android.tools.idea.material.icons.download.MaterialIconsUpdater;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadataBuilder;
import com.android.tools.idea.material.icons.metadata.MaterialMetadataIcon;
import com.android.tools.idea.material.icons.utils.MaterialIconsUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0003\u001a\u0016\u0010\u0019\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "updateIconsAtDir", "", "existingMetadata", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "newMetadata", "targetDir", "Ljava/nio/file/Path;", "iconsUrlProvider", "Lcom/android/tools/idea/material/icons/common/MaterialIconsUrlProvider;", "cleanupUnusedIcons", "", "downloadIconStyles", "metadata", "iconMetadata", "Lcom/android/tools/idea/material/icons/metadata/MaterialMetadataIcon;", "createMaterialIconFileDescription", "Lcom/intellij/util/download/DownloadableFileDescription;", "style", "", "getIconsUpdateData", "Lcom/android/tools/idea/material/icons/download/IconsUpdateData;", "oldMetadata", "cleanUpDownloadDirectories", "downloadedFiles", "", "Ljava/io/File;", "renameDownloadedFiles", "intellij.android.android-material"})
@SourceDebugExtension(value={"SMAP\nMaterialIconsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaterialIconsUpdater.kt\ncom/android/tools/idea/material/icons/download/MaterialIconsUpdaterKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n13472#2,2:344\n11228#2:350\n11563#2,3:351\n11228#2:354\n11563#2,3:355\n3829#2:360\n4344#2,2:361\n3829#2:381\n4344#2,2:382\n1869#3,2:346\n1869#3,2:348\n1869#3,2:358\n1563#3:363\n1634#3,3:364\n1563#3:367\n1634#3,3:368\n1387#3:371\n1475#3,2:372\n774#3:374\n865#3,2:375\n1477#3,3:377\n1869#3:380\n1869#3,2:384\n1870#3:386\n1563#3:387\n1634#3,3:388\n*S KotlinDebug\n*F\n+ 1 MaterialIconsUpdater.kt\ncom/android/tools/idea/material/icons/download/MaterialIconsUpdaterKt\n*L\n89#1:344,2\n135#1:350\n135#1:351,3\n137#1:354\n137#1:355,3\n192#1:360\n192#1:361,2\n304#1:381\n304#1:382,2\n100#1:346,2\n105#1:348,2\n169#1:358,2\n193#1:363\n193#1:364,3\n199#1:367\n199#1:368,3\n256#1:371\n256#1:372,2\n260#1:374\n260#1:375,2\n256#1:377,3\n301#1:380\n305#1:384,2\n301#1:386\n321#1:387\n321#1:388,3\n*E\n"})
public final class MaterialIconsUpdaterKt {
    @NotNull
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public static final boolean updateIconsAtDir(@NotNull MaterialIconsMetadata existingMetadata, @NotNull MaterialIconsMetadata newMetadata, @NotNull Path targetDir, @NotNull MaterialIconsUrlProvider iconsUrlProvider) {
        MaterialMetadataIcon element$iv;
        Intrinsics.checkNotNullParameter((Object)existingMetadata, (String)"existingMetadata");
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter((Object)iconsUrlProvider, (String)"iconsUrlProvider");
        MaterialIconsUpdaterKt.cleanupUnusedIcons(existingMetadata, targetDir);
        MaterialIconsMetadataBuilder metadataBuilder = new MaterialIconsMetadataBuilder(newMetadata.getHost(), newMetadata.getUrlPattern(), newMetadata.getFamilies());
        MaterialMetadataIcon[] $this$forEach$iv = existingMetadata.getIcons();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MaterialMetadataIcon p0 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            metadataBuilder.addIconMetadata(p0);
        }
        IconsUpdateData updateData = MaterialIconsUpdaterKt.getIconsUpdateData(existingMetadata, newMetadata, iconsUrlProvider);
        if (updateData.isEmpty()) {
            log.info("No icons metadata update needed");
            return false;
        }
        try {
            MaterialMetadataIcon it;
            ProgressManager.checkCanceled();
            Iterable $this$forEach$iv2 = updateData.getIconsToRemove();
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl = false;
                ProgressManager.checkCanceled();
                metadataBuilder.removeIconMetadata(it);
            }
            $this$forEach$iv2 = updateData.getIconsToDownload();
            $i$f$forEach2 = false;
            iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl = false;
                ProgressManager.checkCanceled();
                MaterialIconsUpdaterKt.downloadIconStyles(newMetadata, targetDir, it);
                metadataBuilder.addIconMetadata(it);
            }
        }
        catch (ProcessCanceledException $this$forEach$iv3) {}
        catch (CancellationException $this$forEach$iv3) {}
        catch (Exception e) {
            log.warn("Download error", (Throwable)e);
        }
        finally {
            MaterialIconsMetadata materialIconsMetadata = metadataBuilder.build();
            Path path = targetDir.resolve("icons_metadata.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            MaterialIconsMetadata.Companion.writeAsJson(materialIconsMetadata, path, log);
            log.info("Updated icons remove=" + updateData.getIconsToRemove().size() + " download=" + updateData.getIconsToDownload());
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void cleanupUnusedIcons(MaterialIconsMetadata existingMetadata, Path targetDir) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        String[] $this$map$iv = existingMetadata.getFamilies();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        MaterialMetadataIcon[] destination$iv$iv = (MaterialMetadataIcon[])new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv2).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_18 = item$iv$iv = $this$mapTo$iv$iv2[i];
            object = destination$iv$iv;
            boolean bl = false;
            object.add(MaterialIconsUtils.INSTANCE.toDirFormat((String)it));
        }
        Set styleDirNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        MaterialMetadataIcon[] $this$map$iv2 = existingMetadata.getIcons();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
        boolean $i$f$mapTo2 = false;
        int item$iv$iv = ((void)$this$mapTo$iv$iv).length;
        for (n = 0; n < item$iv$iv; ++n) {
            void it;
            void item$iv$iv2;
            void bl = item$iv$iv2 = $this$mapTo$iv$iv[n];
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(it.getName());
        }
        Set iconNamesSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        ArrayList<Path> unusedIconDirPaths = new ArrayList<Path>();
        CancellableFileIo.walkFileTree((Path)targetDir, (Set)SetsKt.emptySet(), (int)2, (FileVisitor)new SimpleFileVisitor<Path>((Set<String>)styleDirNames, targetDir, (Set<String>)iconNamesSet, unusedIconDirPaths){
            final /* synthetic */ Set<String> $styleDirNames;
            final /* synthetic */ Path $targetDir;
            final /* synthetic */ Set<String> $iconNamesSet;
            final /* synthetic */ ArrayList<Path> $unusedIconDirPaths;
            {
                this.$styleDirNames = $styleDirNames;
                this.$targetDir = $targetDir;
                this.$iconNamesSet = $iconNamesSet;
                this.$unusedIconDirPaths = $unusedIconDirPaths;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (this.$styleDirNames.contains(PathsKt.getName((Path)dir)) || Files.isSameFile(this.$targetDir, dir)) {
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (attrs.isDirectory() && !this.$iconNamesSet.contains(PathsKt.getName((Path)file))) {
                    this.$unusedIconDirPaths.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Iterable $this$forEach$iv = unusedIconDirPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path = (Path)element$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            try {
                PathKt.delete((Path)path, (boolean)true);
            }
            catch (Exception e) {
                log.warn("Error deleting unused icon directory: " + PathsKt.getName((Path)path), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void downloadIconStyles(MaterialIconsMetadata metadata, Path targetDir, MaterialMetadataIcon iconMetadata) {
        void $this$mapTo$iv$iv;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        log.info("downloadIconStyles to " + targetDir);
        String[] stringArray = metadata.getFamilies();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (String element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(!ArraysKt.contains((Object[])iconMetadata.getUnsupportedFamilies(), (Object)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void style;
            String element$iv$iv;
            element$iv$iv = (String)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            Path path = targetDir.resolve(MaterialIconsUtils.INSTANCE.toDirFormat((String)style));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            PathKt.createDirectories((Path)path);
            collection2.add(MaterialIconsUpdaterKt.createMaterialIconFileDescription(metadata, iconMetadata, (String)style));
        }
        List fileDescriptions = (List)destination$iv$iv;
        FileDownloader fileDownloader = DownloadableFileService.getInstance().createDownloader(fileDescriptions, "Material Icons");
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"createDownloader(...)");
        FileDownloader downloader = fileDownloader;
        List list = downloader.download(targetDir.toFile());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"download(...)");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add((File)it.first);
        }
        List downloaded = (List)destination$iv$iv2;
        log.info("downloadIconStyles downloaded " + downloaded.size() + " files");
        List<File> renamedFiles = MaterialIconsUpdaterKt.renameDownloadedFiles(downloaded);
        MaterialIconsUpdaterKt.cleanUpDownloadDirectories(renamedFiles);
    }

    private static final DownloadableFileDescription createMaterialIconFileDescription(MaterialIconsMetadata metadata, MaterialMetadataIcon iconMetadata, String style) {
        String styleDirName = MaterialIconsUtils.INSTANCE.toDirFormat(style);
        String iconName = iconMetadata.getName();
        String host = metadata.getHost();
        String basePattern = StringsKt.contains$default((CharSequence)style, (CharSequence)"Symbols", (boolean)false, (int)2, null) ? "/s/i/short-term/release/{family}/{icon}/default/{asset}" : metadata.getUrlPattern();
        String pattern = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)basePattern, (String)"{family}", (String)styleDirName, (boolean)false, (int)4, null), (String)"{icon}", (String)iconName, (boolean)false, (int)4, null), (String)"{version}", (String)String.valueOf(iconMetadata.getVersion()), (boolean)false, (int)4, null), (String)"{asset}", (String)"24px.xml", (boolean)false, (int)4, null);
        String string = "https://%1s%2s";
        Object[] objectArray = new Object[]{host, pattern};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String downloadUrl = string2;
        String fileName = styleDirName + File.separatorChar + iconName + File.separatorChar + MaterialIconsUtils.INSTANCE.getIconFileNameWithoutExtension(iconName, styleDirName) + ".tmp";
        DownloadableFileDescription downloadableFileDescription = DownloadableFileService.getInstance().createFileDescription(downloadUrl, fileName);
        Intrinsics.checkNotNullExpressionValue((Object)downloadableFileDescription, (String)"createFileDescription(...)");
        return downloadableFileDescription;
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    private static final IconsUpdateData getIconsUpdateData(MaterialIconsMetadata oldMetadata, MaterialIconsMetadata newMetadata, MaterialIconsUrlProvider iconsUrlProvider) {
        void $this$flatMapTo$iv$iv;
        Set commonFamilies = ArraysKt.intersect((Object[])oldMetadata.getFamilies(), (Iterable)ArraysKt.asIterable((Object[])newMetadata.getFamilies()));
        Set commonIcons = ArraysKt.intersect((Object[])oldMetadata.getIcons(), (Iterable)ArraysKt.asIterable((Object[])newMetadata.getIcons()));
        Iterable $this$flatMap$iv = commonFamilies;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Sequence sequence;
            String family = (String)element$iv$iv;
            boolean bl = false;
            if (iconsUrlProvider.getStyleUrl(family) == null) {
                sequence = SequencesKt.emptySequence();
            } else {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable2 = commonIcons;
                boolean $i$f$filter = false;
                void var17_17 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    boolean bl2;
                    MaterialMetadataIcon icon = (MaterialMetadataIcon)element$iv$iv2;
                    boolean bl3 = false;
                    if (ArraysKt.contains((Object[])icon.getUnsupportedFamilies(), (Object)family)) {
                        bl2 = false;
                    } else {
                        String expectedFileName = MaterialIconsUtils.INSTANCE.getIconFileNameWithoutExtension(icon.getName(), family) + ".xml";
                        Serializable serializable = iconsUrlProvider.getIconUrl(family, icon.getName(), expectedFileName);
                        if (serializable == null || (serializable = serializable.toURI()) == null) {
                            bl2 = false;
                        } else {
                            Path path;
                            Serializable uri = serializable;
                            Intrinsics.checkNotNullExpressionValue((Object)Path.of((URI)uri), (String)"of(...)");
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            bl2 = !Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                        }
                    }
                    if (!bl2) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                sequence = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv2));
            }
            Sequence list$iv$iv = sequence;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        List brokenIcons = (List)destination$iv$iv;
        Set existingIcons = ArraysKt.toSet((Object[])oldMetadata.getIcons());
        Set newIcons = ArraysKt.toSet((Object[])newMetadata.getIcons());
        Set iconsToRemove = CollectionsKt.subtract((Iterable)existingIcons, (Iterable)newIcons);
        Set iconsToDownload = SetsKt.plus((Set)CollectionsKt.subtract((Iterable)newIcons, (Iterable)existingIcons), (Iterable)brokenIcons);
        if (!((Collection)iconsToRemove).isEmpty()) {
            log.info(iconsToRemove.size() + " icons removed from metadata.");
        }
        if (!((Collection)iconsToDownload).isEmpty()) {
            log.info(iconsToDownload.size() + " icons to download.");
        }
        return new IconsUpdateData(iconsToRemove, iconsToDownload);
    }

    /*
     * WARNING - void declaration
     */
    private static final void cleanUpDownloadDirectories(List<? extends File> downloadedFiles) {
        Iterable $this$forEach$iv = downloadedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list;
            File downloadedFile = (File)element$iv;
            boolean bl = false;
            File iconDirectory = downloadedFile.getParentFile();
            if (iconDirectory.listFiles() != null) {
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv;
                boolean $i$f$filter = false;
                File[] fileArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)downloadedFile.getName()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List filesToCleanUp = list;
            Iterable $this$forEach$iv2 = filesToCleanUp;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File it = (File)element$iv2;
                boolean bl3 = false;
                if (it.delete()) continue;
                throw new IllegalStateException("Unable to delete file: " + it.getName());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<File> renameDownloadedFiles(List<? extends File> downloadedFiles) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = downloadedFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void downloadedFile;
            File file = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            File iconDir = downloadedFile.getParentFile();
            String iconName = iconDir.getName();
            String styleDirName = iconDir.getParentFile().getName();
            Intrinsics.checkNotNull((Object)iconName);
            Intrinsics.checkNotNull((Object)styleDirName);
            String newIconFileName = MaterialIconsUtils.INSTANCE.getIconFileNameWithoutExtension(iconName, styleDirName) + ".xml";
            Intrinsics.checkNotNull((Object)iconDir);
            File destFile = FilesKt.resolve((File)iconDir, (String)newIconFileName);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            collection2.add(Files.move(downloadedFile.toPath(), destFile.toPath(), copyOptionArray).toFile());
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger = Logger.getInstance(MaterialIconsUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

