/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.memorysettings.BuildSystemComponent;
import com.android.tools.idea.memorysettings.MemorySettingsRecommendation;
import com.android.tools.idea.memorysettings.MemorySettingsToken;
import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.MemorySettingsEvent;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class MemorySettingsConfigurable
implements SearchableConfigurable {
    private MyComponent myComponent = new MyComponent();

    @NotNull
    public String getHelpTopic() {
        return "memory.settings";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    public String getDisplayName() {
        return "Memory Settings";
    }

    public void apply() throws ConfigurationException {
        this.myComponent.apply();
    }

    public boolean isModified() {
        return this.myComponent.isModified();
    }

    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyComponent();
        }
        return this.myComponent.myPanel;
    }

    public void reset() {
        this.myComponent.reset();
    }

    public void disposeUIResources() {
        if (this.myComponent.myNeedsRestart && Messages.showYesNoDialog((String)XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.restart.needed", new Object[0])), (String)IdeBundle.message((String)"title.restart.needed", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            Registry.get((String)"ide.instant.shutdown").setValue(false);
            ((ApplicationEx)ApplicationManager.getApplication()).restart(true);
        }
        this.myComponent = null;
    }

    static class MyComponent {
        private static final int MIN_IDE_XMX = 1024;
        private static final int DEFAULT_IDE_XMX = 2048;
        private static final int SIZE_INCREMENT = 1024;
        private static final float MAX_PERCENT_OF_AVAILABLE_RAM = 0.33f;
        private JPanel myPanel;
        private ComboBox<Integer> myIdeXmxBox;
        private JBLabel myInfoLabel;
        private HyperlinkLabel myApplyRecommendationLabel;
        private JPanel myBuildSystemPanel;
        private BuildSystemComponent myBuildSystemComponent;
        private JBLabel myIdeBottomLabel;
        private JBLabel myIdeInfoLabel;
        private Project myProject;
        private int myCurrentIdeXmx;
        private final int myRecommendedIdeXmx;
        private int mySelectedIdeXmx;
        private boolean myNeedsRestart;

        MyComponent() {
            this.setupUI();
            this.mySelectedIdeXmx = this.myCurrentIdeXmx = MemorySettingsUtil.getCurrentXmx();
            this.myRecommendedIdeXmx = MemorySettingsRecommendation.getRecommended(this.myProject, this.myCurrentIdeXmx);
            this.setUI();
            BuildSystemComponent.BuildSystemXmxs currentXmxs = new BuildSystemComponent.BuildSystemXmxs();
            if (this.myBuildSystemComponent != null) {
                this.myBuildSystemComponent.fillCurrent(currentXmxs);
            }
            MemorySettingsUtil.log(MemorySettingsEvent.EventKind.SHOW_CONFIG_DIALOG, this.myCurrentIdeXmx, currentXmxs.gradleXmx, currentXmxs.kotlinXmx, this.myRecommendedIdeXmx, -1, -1, -1, -1, -1);
        }

        private void setUI() {
            this.myInfoLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)("<body>" + AndroidBundle.message("memory.settings.panel.top.message", new Object[0]) + "</body>")));
            this.myIdeBottomLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.ide.bottom.message", new Object[0])));
            this.myIdeBottomLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
            if (this.myRecommendedIdeXmx > this.myCurrentIdeXmx) {
                this.myIdeInfoLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)AndroidBundle.message("memory.settings.panel.ide.info", MyComponent.memSizeText(this.myRecommendedIdeXmx))));
                this.myApplyRecommendationLabel.setHyperlinkText(AndroidBundle.message("memory.settings.panel.use.recommended.values", new Object[0]));
                this.myApplyRecommendationLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                    protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                        myIdeXmxBox.setSelectedItem((Object)myRecommendedIdeXmx);
                        mySelectedIdeXmx = myRecommendedIdeXmx;
                        BuildSystemComponent.BuildSystemXmxs currentXmxs = new BuildSystemComponent.BuildSystemXmxs();
                        if (myBuildSystemComponent != null) {
                            myBuildSystemComponent.fillCurrent(currentXmxs);
                        }
                        MemorySettingsUtil.log(MemorySettingsEvent.EventKind.APPLY_RECOMMENDATION_BUTTON_CLICKED, myCurrentIdeXmx, currentXmxs.gradleXmx, currentXmxs.kotlinXmx, myRecommendedIdeXmx, -1, -1, myRecommendedIdeXmx, -1, -1);
                    }
                });
            } else {
                this.myIdeInfoLabel.setVisible(false);
                this.myApplyRecommendationLabel.setVisible(false);
            }
            int machineMem = MemorySettingsUtil.getMachineMem();
            int maxXmx = MyComponent.getMaxXmxInMB(machineMem);
            MyComponent.setXmxBox(this.myIdeXmxBox, this.myCurrentIdeXmx, this.myRecommendedIdeXmx, 2048, maxXmx, 1024, event -> {
                if (event.getStateChange() == 1 && event.getItem() != null) {
                    this.mySelectedIdeXmx = (Integer)event.getItem();
                }
            });
            if (this.myBuildSystemComponent != null) {
                this.myBuildSystemComponent.setUI();
            } else {
                this.myBuildSystemPanel.setVisible(false);
            }
        }

        private void setupUI() {
            this.createUIComponents();
            this.myPanel = new JPanel();
            this.myPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1));
            JPanel panel1 = new JPanel();
            panel1.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1));
            this.myPanel.add((Component)panel1, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
            panel1.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"IDE Heap Size Settings", (int)0, (int)0, null, null));
            JBLabel jBLabel1 = new JBLabel();
            Font jBLabel1Font = this.getFont(null, -1, 12, jBLabel1.getFont());
            if (jBLabel1Font != null) {
                jBLabel1.setFont(jBLabel1Font);
            }
            jBLabel1.setText("IDE max heap size:");
            panel1.add((Component)jBLabel1, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, new Dimension(190, -1), new Dimension(184, 15), new Dimension(190, -1), 0, false));
            this.myIdeXmxBox = new ComboBox();
            DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
            defaultComboBoxModel1.addElement("1024");
            defaultComboBoxModel1.addElement("1280");
            defaultComboBoxModel1.addElement("2048");
            defaultComboBoxModel1.addElement("3072");
            defaultComboBoxModel1.addElement("4096");
            this.myIdeXmxBox.setModel(defaultComboBoxModel1);
            panel1.add((Component)this.myIdeXmxBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1), 0, false));
            this.myIdeBottomLabel = new JBLabel();
            Font myIdeBottomLabelFont = this.getFont(null, -1, 10, this.myIdeBottomLabel.getFont());
            if (myIdeBottomLabelFont != null) {
                this.myIdeBottomLabel.setFont(myIdeBottomLabelFont);
            }
            this.myIdeBottomLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
            this.myIdeBottomLabel.setOpaque(false);
            this.myIdeBottomLabel.setText("Label");
            panel1.add((Component)this.myIdeBottomLabel, new GridConstraints(5, 1, 1, 2, 8, 0, 4, 0, null, new Dimension(400, -1), null, 0, false));
            this.myIdeInfoLabel = new JBLabel();
            this.myIdeInfoLabel.setText("Label");
            panel1.add((Component)this.myIdeInfoLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, new Dimension(600, -1), null, 0, false));
            this.myApplyRecommendationLabel = new HyperlinkLabel();
            panel1.add((Component)this.myApplyRecommendationLabel, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 3, null, new Dimension(643, 15), null, 0, false));
            Spacer spacer1 = new Spacer();
            panel1.add((Component)spacer1, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10), 0, false));
            Spacer spacer2 = new Spacer();
            panel1.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(184, 10), new Dimension(-1, 10), 0, false));
            Spacer spacer3 = new Spacer();
            panel1.add((Component)spacer3, new GridConstraints(4, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
            this.myPanel.add((Component)this.myBuildSystemPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
            this.myBuildSystemPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Daemon Heap Size Settings", (int)0, (int)0, null, null));
            this.myInfoLabel = new JBLabel();
            this.myInfoLabel.setText("Label");
            this.myPanel.add((Component)this.myInfoLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, new Dimension(600, -1), null, 0, false));
            Spacer spacer4 = new Spacer();
            this.myPanel.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(643, 10), new Dimension(-1, 10), 0, false));
            Spacer spacer5 = new Spacer();
            this.myPanel.add((Component)spacer5, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(643, 15), new Dimension(-1, 15), 0, false));
            Spacer spacer6 = new Spacer();
            this.myPanel.add((Component)spacer6, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        }

        private Font getFont(String fontName, int style, int size, Font currentFont) {
            Font testFont;
            if (currentFont == null) {
                return null;
            }
            String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
            Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
            boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
            Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
            return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
        }

        public JComponent getRootComponent() {
            return this.myPanel;
        }

        public static void setXmxBoxWithOnlyCurrentValue(JComboBox<Integer> box, final int current) {
            box.setEditable(false);
            box.removeAllItems();
            box.addItem(current);
            box.setSelectedItem(current);
            box.setRenderer((ListCellRenderer<Integer>)new ColoredListCellRenderer<Integer>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Integer> list, Integer value2, int index, boolean selected, boolean hasFocus) {
                    this.append(String.format(Locale.US, "%s - current", MyComponent.memSizeText(current)), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                }
            });
        }

        public static void setXmxBox(JComboBox<Integer> box, final int current, final int recommended, final int defaultSize, int max, int increment, ItemListener listener2) {
            box.setEditable(false);
            box.removeAllItems();
            ArrayList<Integer> items = new ArrayList<Integer>();
            items.add(current);
            if (recommended > 0 && recommended != current) {
                items.add(recommended);
            }
            if (defaultSize > 0 && defaultSize != current && defaultSize != recommended) {
                items.add(defaultSize);
            }
            for (int size = 1024; size <= max; size += increment) {
                if (size == current || size == recommended || size == defaultSize) continue;
                items.add(size);
            }
            Collections.sort(items);
            Iterator iterator2 = items.iterator();
            while (iterator2.hasNext()) {
                int item = (Integer)iterator2.next();
                box.addItem(item);
            }
            box.setSelectedItem(current);
            box.addItemListener(listener2);
            box.setRenderer((ListCellRenderer<Integer>)new ColoredListCellRenderer<Integer>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Integer> list, Integer value2, int index, boolean selected, boolean hasFocus) {
                    if (value2.equals(current)) {
                        this.append(String.format(Locale.US, "%s - current", MyComponent.memSizeText(current)), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                    } else if (value2.equals(defaultSize)) {
                        this.append(String.format(Locale.US, "%s - default", MyComponent.memSizeText(defaultSize)), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                    } else if (value2.equals(recommended)) {
                        this.append(String.format(Locale.US, "%s - recommended", MyComponent.memSizeText(recommended)), new SimpleTextAttributes(1, null));
                    } else {
                        this.append(MyComponent.memSizeText(value2), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
        }

        private boolean isModified() {
            return this.isIdeXmxModified() || this.myBuildSystemComponent != null && this.myBuildSystemComponent.isModified();
        }

        private boolean isIdeXmxModified() {
            return this.mySelectedIdeXmx != this.myCurrentIdeXmx;
        }

        private void reset() {
            this.myIdeXmxBox.setSelectedItem((Object)this.myCurrentIdeXmx);
            this.mySelectedIdeXmx = this.myCurrentIdeXmx;
            if (this.myBuildSystemComponent != null) {
                this.myBuildSystemComponent.reset();
            }
        }

        private void apply() {
            BuildSystemComponent.BuildSystemXmxs currentXmxs = new BuildSystemComponent.BuildSystemXmxs();
            BuildSystemComponent.BuildSystemXmxs selectedXmxs = new BuildSystemComponent.BuildSystemXmxs();
            if (this.myBuildSystemComponent != null) {
                this.myBuildSystemComponent.fillCurrent(currentXmxs);
                this.myBuildSystemComponent.fillChanged(selectedXmxs);
            }
            MemorySettingsUtil.log(MemorySettingsEvent.EventKind.SETTINGS_CHANGE_SAVED, this.myCurrentIdeXmx, currentXmxs.gradleXmx, currentXmxs.kotlinXmx, this.myRecommendedIdeXmx, -1, -1, this.mySelectedIdeXmx, selectedXmxs.gradleXmx, selectedXmxs.kotlinXmx);
            boolean needsUpdate = this.isModified();
            if (this.myBuildSystemComponent != null && this.myBuildSystemComponent.isModified()) {
                this.myBuildSystemComponent.apply();
            }
            if (this.isIdeXmxModified()) {
                MemorySettingsUtil.saveXmx(this.mySelectedIdeXmx);
                this.myCurrentIdeXmx = this.mySelectedIdeXmx;
                this.myNeedsRestart = true;
            }
            if (needsUpdate) {
                this.setUI();
            }
        }

        private void createUIComponents() {
            this.myProject = MemorySettingsUtil.getCurrentProject();
            if (this.myProject == null) {
                this.myBuildSystemPanel = new JPanel();
                return;
            }
            AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(this.myProject);
            Optional<MemorySettingsToken> maybeToken = MemorySettingsToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst();
            if (maybeToken.isPresent()) {
                this.myBuildSystemComponent = maybeToken.get().createBuildSystemComponent(projectSystem);
                this.myBuildSystemPanel = this.myBuildSystemComponent != null ? this.myBuildSystemComponent.getPanel() : new JPanel();
            } else {
                this.myBuildSystemPanel = new JPanel();
            }
        }

        private static int getMaxXmxInMB(int machineMemInMB) {
            int ideXmxCap = 8192;
            return Math.min(Math.round((float)machineMemInMB * 0.33f) >> 8 << 8, ideXmxCap);
        }

        private static String memSizeText(int size) {
            return size < 0 ? "unknown" : size + " MB";
        }
    }
}

