/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.memorysettings.MemorySettingsToken;
import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class MemorySettingsRecommendation {
    private static final Logger LOG = Logger.getInstance(MemorySettingsRecommendation.class);
    public static final int DEFAULT_HEAP_SIZE_IN_MB = 2048;
    public static final int LARGE_HEAP_SIZE_RECOMMENDATION_IN_MB = 4096;
    public static final int XLARGE_HEAP_SIZE_RECOMMENDATION_IN_MB = 8192;
    public static final int LARGE_RAM_IN_GB = 16;
    public static final int XLARGE_RAM_IN_GB = 32;

    public static int getRecommended(@Nullable Project project, int currentXmx) {
        if (project == null || currentXmx < 0) {
            return 2048;
        }
        int basedOnMachine = MemorySettingsRecommendation.getRecommendedBasedOnMachine();
        int basedOnProject = MemorySettingsRecommendation.getRecommendedBasedOnProject(project);
        int recommended = Math.min(basedOnMachine, basedOnProject);
        LOG.info(String.format(Locale.US, "recommendation based on machine: %d, on project: %d", basedOnMachine, basedOnProject));
        return Math.max(recommended, currentXmx);
    }

    private static int getRecommendedBasedOnMachine() {
        int machineMemInGB = MemorySettingsUtil.getMachineMem() >> 10;
        if (machineMemInGB >= 32) {
            return 8192;
        }
        if (machineMemInGB >= 16) {
            return 4096;
        }
        return 2048;
    }

    private static int getRecommendedBasedOnProject(Project project) {
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
        Optional<MemorySettingsToken> maybeToken = MemorySettingsToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst();
        if (maybeToken.isPresent()) {
            return maybeToken.get().getRecommendedXmxFor(projectSystem);
        }
        return 2048;
    }
}

