/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.idea.mlkit.MlModelFilesSearchScope;
import com.android.tools.idea.mlkit.MlModelMetadata;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileType;
import com.android.tools.mlkit.ModelInfo;
import com.android.tools.mlkit.TfliteModelException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MlModelFileIndex {
    private static final VirtualFileGist<MlModelMetadata> ourGist = GistManager.getInstance().newVirtualFileGist("MlModelFileGist", 1, (DataExternalizer)new DataExternalizer<MlModelMetadata>(){

        public void save(@NotNull DataOutput out, @NotNull MlModelMetadata value2) throws IOException {
            out.writeUTF(value2.myModelFileUrl);
            value2.myModelInfo.save(out);
        }

        public MlModelMetadata read(@NotNull DataInput in) throws IOException {
            String fileUrl = in.readUTF();
            ModelInfo modelInfo = new ModelInfo(in);
            return new MlModelMetadata(fileUrl, modelInfo);
        }
    }, (project, file) -> {
        try {
            if (file.getLength() > 0xC800000L) {
                return null;
            }
            byte[] bytes2 = Files.readAllBytes(VfsUtilCore.virtualToIoFile((VirtualFile)file).toPath());
            ModelInfo modelInfo = ModelInfo.buildFrom((ByteBuffer)ByteBuffer.wrap(bytes2));
            return new MlModelMetadata(file.getUrl(), modelInfo);
        }
        catch (TfliteModelException e) {
            Logger.getInstance(MlModelFileIndex.class).warn("Failed to gist " + file.getUrl());
        }
        catch (Exception e) {
            Logger.getInstance(MlModelFileIndex.class).warn("Failed to gist " + file.getUrl(), (Throwable)e);
        }
        return null;
    });

    @NotNull
    public static Set<MlModelMetadata> getModelMetadataSet(Module module) {
        GlobalSearchScope searchScope = MlModelFilesSearchScope.inModule(module);
        Collection modelFiles = FilenameIndex.getAllFilesByExt((Project)module.getProject(), (String)TfliteModelFileType.INSTANCE.getDefaultExtension(), (GlobalSearchScope)searchScope);
        return modelFiles.stream().map(it -> (MlModelMetadata)ourGist.getFileData(module.getProject(), it)).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

