/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidViewNodes;
import com.android.tools.idea.navigator.nodes.AndroidViewTypeSortWeight;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestFileNode
extends PsiFileNode
implements FolderGroupNode {
    @NotNull
    private final AndroidFacet myAndroidFacet;

    AndroidManifestFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet androidFacet) {
        super(project, psiFile, settings);
        this.myAndroidFacet = androidFacet;
    }

    public void update(@NotNull PresentationData data2) {
        NamedIdeaSourceProvider sourceProvider;
        super.update(data2);
        PsiFile file = (PsiFile)this.getValue();
        if (file != null && (sourceProvider = this.getSourceProvider(file)) != null && !"main".equals(sourceProvider.getName())) {
            data2.addText(file.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String name2 = sourceProvider.getName();
            if (StringUtil.isNotEmpty((String)name2)) {
                data2.addText(" (" + name2 + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            data2.setPresentableText(file.getName());
        }
    }

    @Nullable
    public NamedIdeaSourceProvider getSourceProvider(@NotNull PsiFile file) {
        return SourceProvidersKt.findByFile(AndroidViewNodes.getSourceProviders(this.myAndroidFacet), file.getVirtualFile());
    }

    @Nullable
    public Comparable getSortKey() {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        NamedIdeaSourceProvider sourceProvider = this.getSourceProvider(file);
        if (sourceProvider == null || "main".equals(sourceProvider.getName())) {
            return "";
        }
        return sourceProvider.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    public int getTypeSortWeight(boolean sortByType) {
        return AndroidViewTypeSortWeight.FILE.getWeight();
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        return Collections.emptyList();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(file.getName());
        NamedIdeaSourceProvider sourceProvider = this.getSourceProvider(file);
        assert (sourceProvider != null);
        String name2 = sourceProvider.getName();
        if (StringUtil.isNotEmpty((String)name2)) {
            buffer.append(" (");
            buffer.append(name2);
            buffer.append(")");
        }
        return buffer.toString();
    }
}

