/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class SourceFolders {
    private SourceFolders() {
    }

    public static boolean isInSourceFolder(@NotNull VirtualFile file, @NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile contentRoot : rootManager.getContentRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInSourceFolder(@NotNull VirtualFile file, @NotNull NativeLibrary library) {
        File filePath = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        for (String path : library.getSourceFolderPaths()) {
            if (!FileUtil.isAncestor((String)path, (String)filePath.getPath(), (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

