/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.resolver;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.RegularExpressionIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.NdkVersionUtilsKt;
import java.io.File;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedRegularExpressionIncludeResolver
extends RegularExpressionIncludeResolver {
    @NotNull
    private final PackageType myKind;
    @NotNull
    private final String myPattern;
    @Nullable
    private final String myLibraryName;

    IndexedRegularExpressionIncludeResolver(@NotNull PackageType kind, @NotNull String pattern, @Nullable String libraryName) {
        this.myKind = kind;
        this.myPattern = pattern;
        this.myLibraryName = libraryName;
    }

    @Override
    @NotNull
    String getMatchRegexTemplate() {
        return this.myPattern;
    }

    private String groupOrNull(Matcher match, String name2) {
        if (this.myPattern.contains(String.format("?<%s>", name2))) {
            return match.group(name2);
        }
        return null;
    }

    @Override
    @Nullable
    public SimpleIncludeValue resolve(@NotNull File includeFolder) {
        Matcher match = LexicalIncludePaths.matchFolderToRegex(this.getCompiledMatchPattern(), includeFolder);
        if (!match.find()) {
            return null;
        }
        try {
            String relativeFolder = match.group("relative");
            String libraryName = this.myLibraryName;
            if (libraryName == null) {
                libraryName = match.group("library");
            }
            String homeFolder = match.group("home");
            Object description2 = this.myKind.myDescription;
            String version2 = this.groupOrNull(match, "ndk");
            if (version2 != null) {
                description2 = (String)description2 + NdkVersionUtilsKt.getNdkVersionName(version2);
            }
            return new SimpleIncludeValue(this.myKind, (String)description2, libraryName, relativeFolder, includeFolder, new File(homeFolder));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("Pattern %s is missing a group name", this.myPattern), e);
        }
    }
}

