/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.utils;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFiles {
    @NotNull
    public static ImmutableList<VirtualFile> convertToVirtualFile(@Nullable Collection<String> names) {
        if (names != null) {
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            return ImmutableList.copyOf((Collection)names.stream().map(exclude -> fileSystem.findFileByIoFile(new File((String)exclude))).filter(exclude -> exclude != null).collect(Collectors.toList()));
        }
        return ImmutableList.of();
    }

    public static boolean isElementAncestorOfExclude(PsiFileSystemItem element, ImmutableList<VirtualFile> files2) {
        for (VirtualFile excluded : files2) {
            if (!VfsUtilCore.isAncestor((VirtualFile)excluded, (VirtualFile)element.getVirtualFile(), (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

