/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.MaterialVdIconsProvider;
import com.android.tools.idea.material.icons.MaterialVdIcons;
import com.android.tools.idea.material.icons.common.MaterialIconsMetadataUrlProvider;
import com.android.tools.idea.material.icons.common.MaterialIconsUrlProvider;
import com.android.tools.idea.npw.assetstudio.ui.IconPickerCellRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class IconPickerDialog
extends DialogWrapper
implements DataProvider {
    private static final String MATERIAL_ICONS_PREFIX = "Material Icons";
    private static final int COLUMN_NUMBER = 6;
    private static final int ICON_ROW_HEIGHT = JBUI.scale((int)64);
    private static final int EXPECTED_NUMBER_OF_ICONS = 1100;
    private MaterialVdIcons myIcons = MaterialVdIcons.EMPTY;
    private final List<VdIcon> myIconList = new ArrayList<VdIcon>(1100);
    private final List<VdIcon> myFilteredIconList = new ArrayList<VdIcon>(1100);
    private final AbstractTableModel myModel = new AbstractTableModel(){

        @Override
        public String getColumnName(int column2) {
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return VdIcon.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int index = rowIndex * 6 + columnIndex;
            if (index < 0) {
                return null;
            }
            return IconPickerDialog.this.myFilteredIconList.size() > index ? IconPickerDialog.this.myFilteredIconList.get(index) : null;
        }

        @Override
        public int getRowCount() {
            return IconPickerDialog.this.myFilteredIconList.size() / 6 + (IconPickerDialog.this.myFilteredIconList.size() % 6 == 0 ? 0 : 1);
        }

        @Override
        public int getColumnCount() {
            return 6;
        }
    };
    private final JBTable myIconTable = new JBTable((TableModel)this.myModel);
    private JPanel myContentPanel;
    private JPanel myIconsPanel;
    private JPanel myLicensePanel;
    private HyperlinkLabel myLicenseLabel;
    private SearchTextField mySearchField;
    private JComboBox<Category> myCategoriesBox;
    private JComboBox<Style> myStylesBox;
    @Nullable
    private VdIcon mySelectedIcon;
    @Nullable
    private VdIcon myIconToSelectInTable;
    private final AtomicBoolean isBusy = new AtomicBoolean(false);

    public IconPickerDialog(@Nullable VdIcon selectedIcon) {
        this(selectedIcon, null, null);
    }

    @VisibleForTesting
    public IconPickerDialog(@Nullable VdIcon selectedIcon, @Nullable MaterialIconsMetadataUrlProvider metadataUrlProvider, @Nullable MaterialIconsUrlProvider iconsUrlProvider) {
        super(false);
        this.myIconToSelectInTable = selectedIcon;
        this.setupUI();
        this.setTitle("Select Icon");
        Color iconBackgroundColor = UIUtil.getListBackground();
        this.myIconTable.setBackground(iconBackgroundColor);
        this.myIconTable.setDefaultRenderer(VdIcon.class, (TableCellRenderer)new IconPickerCellRenderer());
        this.myIconTable.setTableHeader(null);
        this.myIconTable.setRowHeight(ICON_ROW_HEIGHT);
        this.myIconTable.setSelectionMode(0);
        this.myIconTable.setCellSelectionEnabled(true);
        this.myIconsPanel.add((Component)new JBScrollPane((Component)this.myIconTable));
        TableHoverListener.DEFAULT.removeFrom((JComponent)this.myIconTable);
        this.myIconTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (Character.isLetter(keyChar) || Character.isDigit(keyChar)) {
                    IconPickerDialog.this.mySearchField.setText(Character.toString(keyChar));
                    IconPickerDialog.this.mySearchField.requestFocus();
                }
                super.keyPressed(e);
            }
        });
        this.myLicenseLabel.setHyperlinkText("These icons are available under the ", "Apache License Version 2.0", "");
        this.myLicenseLabel.setHyperlinkTarget("http://www.apache.org/licenses/LICENSE-2.0.txt");
        ListSelectionModel selModel = this.myIconTable.getSelectionModel();
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.myIconTable.setGridColor(iconBackgroundColor);
        this.myIconTable.setIntercellSpacing((Dimension)JBUI.size((int)3, (int)3));
        this.myIconTable.setRowMargin(0);
        ListSelectionListener listener2 = e -> {
            VdIcon icon;
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = this.myIconTable.getSelectedRow();
            int col = this.myIconTable.getSelectedColumn();
            this.mySelectedIcon = icon = row != -1 && col != -1 ? (VdIcon)this.myIconTable.getValueAt(row, col) : null;
            if (icon != null) {
                this.myIconToSelectInTable = icon;
            }
            this.setOKActionEnabled(icon != null);
        };
        selModel.addListSelectionListener(listener2);
        ListSelectionModel colSelModel = this.myIconTable.getColumnModel().getSelectionModel();
        colSelModel.addListSelectionListener(listener2);
        selModel.setSelectionMode(0);
        selModel.setSelectionInterval(0, 0);
        this.myIconTable.setColumnSelectionInterval(0, 0);
        this.myIconTable.requestFocusInWindow();
        DataManager.registerDataProvider((JComponent)this.myContentPanel, (DataProvider)this);
        AnAction action2 = ActionManager.getInstance().getAction("Find");
        if (action2 != null) {
            new SearchTextField.FindAction().registerCustomShortcutSet(action2.getShortcutSet(), (JComponent)this.getRootPane(), this.myDisposable);
        }
        this.myContentPanel.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        this.init();
        this.myIconTable.getEmptyText().setText("Loading icons...");
        this.myStylesBox.setVisible(false);
        this.myStylesBox.setName("Styles");
        this.myCategoriesBox.setVisible(false);
        this.myCategoriesBox.setName("Categories");
        ItemListener stylesBoxListener = e -> {
            if (e.getStateChange() == 2 || e.getItem() == null) {
                return;
            }
            int categoryCurrentIndex = this.myCategoriesBox.getSelectedIndex();
            this.setCategoriesBoxModel(this.myStylesBox.getSelectedIndex());
            if (categoryCurrentIndex >= 0 && categoryCurrentIndex < this.myCategoriesBox.getItemCount()) {
                this.myCategoriesBox.setSelectedIndex(categoryCurrentIndex);
            }
        };
        this.myStylesBox.addItemListener(stylesBoxListener);
        ItemListener categoriesBoxListener = e -> {
            if (e.getStateChange() == 2 || e.getItem() == null) {
                return;
            }
            this.updateIconList();
        };
        this.myCategoriesBox.addItemListener(categoriesBoxListener);
        this.myStylesBox.setName("Styles");
        this.myCategoriesBox.setName("Categories");
        this.refreshIconList(metadataUrlProvider, iconsUrlProvider, true);
    }

    private void refreshIconList(@Nullable MaterialIconsMetadataUrlProvider metadataUrlProvider, @Nullable MaterialIconsUrlProvider iconsUrlProvider, boolean isFirstRefresh) {
        this.myIconTable.setPaintBusy(true);
        this.myStylesBox.setEnabled(false);
        this.myCategoriesBox.setEnabled(false);
        this.isBusy.set(true);
        MaterialVdIconsProvider.loadMaterialVdIcons((Function2<? super MaterialVdIcons, ? super MaterialVdIconsProvider.Status, Unit>)((Function2)(materialVdIcons, status2) -> {
            assert (ApplicationManager.getApplication().isDispatchThread());
            this.myIconTable.getEmptyText().setText(StatusText.getDefaultEmptyText());
            this.populateIcons((MaterialVdIcons)materialVdIcons);
            if (status2 == MaterialVdIconsProvider.Status.FINISHED) {
                this.myIconTable.setPaintBusy(false);
                this.myStylesBox.setEnabled(true);
                this.myCategoriesBox.setEnabled(true);
                this.isBusy.set(false);
            }
            this.pack();
            this.repaint();
            return null;
        }), this.getDisposable(), metadataUrlProvider, iconsUrlProvider, (Function0<Unit>)((Function0)() -> {
            if (isFirstRefresh) {
                this.refreshIconList(metadataUrlProvider, iconsUrlProvider, false);
            }
            return null;
        }));
    }

    private void createUIComponents() {
        this.mySearchField = new SearchTextField(false);
        this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                IconPickerDialog.this.updateFilter();
            }
        });
    }

    private void updateFilter() {
        String text2 = this.mySearchField.getText().trim();
        this.myFilteredIconList.clear();
        for (VdIcon icon : this.myIconList) {
            if (!text2.isEmpty() && !StringUtil.containsIgnoreCase((String)icon.getDisplayName(), (String)text2)) continue;
            this.myFilteredIconList.add(icon);
        }
        this.myModel.fireTableDataChanged();
    }

    private boolean tryToSelectIcon() {
        VdIcon iconToSelect = this.myIconToSelectInTable;
        this.myIconToSelectInTable = null;
        if (iconToSelect == null) {
            return false;
        }
        for (int r = 0; r < this.myIconTable.getRowCount(); ++r) {
            for (int c = 0; c < this.myIconTable.getColumnCount(); ++c) {
                VdIcon icon = (VdIcon)this.myIconTable.getValueAt(r, c);
                if (icon == null || !icon.getDisplayName().equals(iconToSelect.getDisplayName())) continue;
                this.myIconTable.changeSelection(r, c, false, false);
                return true;
            }
        }
        return false;
    }

    private void populateIcons(MaterialVdIcons icons) {
        boolean shouldUpdateIconList = this.myIcons == null || this.myIcons == MaterialVdIcons.EMPTY;
        this.myIcons = icons;
        this.setStylesBoxModel();
        if (this.myStylesBox.getItemCount() > 0) {
            if (this.myStylesBox.getSelectedIndex() == -1) {
                this.myStylesBox.setSelectedIndex(0);
            }
            this.myStylesBox.setVisible(true);
            this.setCategoriesBoxModel(this.myStylesBox.getSelectedIndex());
        }
        if (this.myCategoriesBox.getItemCount() > 0) {
            if (this.myCategoriesBox.getSelectedIndex() == -1) {
                this.myCategoriesBox.setSelectedIndex(0);
            }
            this.myCategoriesBox.setVisible(true);
        }
        if (shouldUpdateIconList) {
            this.updateIconList();
        }
    }

    private void setStylesBoxModel() {
        Style[] stylesArray = (Style[])this.myIcons.getStyles().stream().sorted(Comparator.comparingInt(style -> style.startsWith("Material Symbols") ? -1 : 0).thenComparing(Object::toString)).map(Style::new).toArray(Style[]::new);
        this.myStylesBox.setModel(new DefaultComboBoxModel<Style>(stylesArray));
    }

    private void setCategoriesBoxModel(int styleIndex) {
        boolean hasCategories;
        Style style = styleIndex < this.myStylesBox.getItemCount() ? (Style)this.myStylesBox.getModel().getElementAt(styleIndex) : Style.EMPTY;
        ArrayList categoriesArray = this.myIcons.getCategories(style.myName).stream().sorted().map(Category::new).collect(Collectors.toCollection(ArrayList::new));
        boolean bl = hasCategories = !categoriesArray.isEmpty();
        if (hasCategories) {
            categoriesArray.add(0, Category.ALL);
        }
        this.myCategoriesBox.setModel((ComboBoxModel<Category>)new CollectionComboBoxModel((List)categoriesArray, null));
    }

    @Nullable
    public VdIcon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    @VisibleForTesting
    public JTable getTable() {
        return this.myIconTable;
    }

    @VisibleForTesting
    public void setFilter(String text2) {
        this.mySearchField.setText(text2);
    }

    private void updateIconList() {
        this.myIconList.clear();
        Style style = (Style)this.myStylesBox.getSelectedItem();
        if (style != null) {
            Category categoryItem = (Category)this.myCategoriesBox.getSelectedItem();
            if (categoryItem == null || categoryItem == Category.ALL) {
                this.myIconList.addAll(this.myIcons.getAllIcons(style.myName));
            } else {
                this.myIconList.addAll(this.myIcons.getIcons(style.myName, categoryItem.myName));
            }
            this.myIconList.sort(Comparator.comparing(VdIcon::getDisplayName));
        }
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.updateFilter();
        if (!this.tryToSelectIcon()) {
            this.myIconTable.setColumnSelectionInterval(0, 0);
            this.myIconTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @NotNull
    public JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        return SearchTextField.KEY.is(dataId) ? this.mySearchField : null;
    }

    @TestOnly
    boolean isBusy() {
        return this.isBusy.get();
    }

    private void setupUI() {
        this.createUIComponents();
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout(new BorderLayout(20, 10));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        this.myContentPanel.add((Component)panel1, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.fill = 2;
        panel1.add((Component)this.mySearchField, gbc);
        this.myCategoriesBox = new JComboBox();
        this.myCategoriesBox.setMinimumSize(new Dimension(140, 30));
        DefaultComboBoxModel defaultComboBoxModel1 = new DefaultComboBoxModel();
        this.myCategoriesBox.setModel(defaultComboBoxModel1);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel1.add(this.myCategoriesBox, gbc);
        this.myStylesBox = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel1.add(this.myStylesBox, gbc);
        this.myIconsPanel = new JPanel();
        this.myIconsPanel.setLayout(new BorderLayout(0, 0));
        this.myIconsPanel.setMinimumSize(new Dimension(300, 400));
        this.myContentPanel.add((Component)this.myIconsPanel, "Center");
        this.myLicensePanel = new JPanel();
        this.myLicensePanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.add((Component)this.myLicensePanel, "South");
        this.myLicenseLabel = new HyperlinkLabel();
        this.myLicensePanel.add((Component)this.myLicenseLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
    }

    private static class Style {
        private final String myName;
        private final String myDisplayName;
        static final Style EMPTY = new Style("", "");

        private static String getShortenedStyleName(@NotNull String styleName) {
            String styleShortened = StringUtil.trimStart((String)styleName, (String)IconPickerDialog.MATERIAL_ICONS_PREFIX).trim();
            if (styleShortened.isEmpty()) {
                return "Filled";
            }
            return styleShortened;
        }

        private Style(@NotNull String styleName, @NotNull String displayName) {
            this.myName = styleName;
            this.myDisplayName = displayName;
        }

        Style(@NotNull String styleName) {
            this(styleName, Style.getShortenedStyleName(styleName));
        }

        public String toString() {
            return this.myDisplayName;
        }
    }

    private static class Category {
        private final String myName;
        private final String myDisplayName;
        static final Category ALL = new Category("All", "All");

        private Category(@NotNull String name2, @NotNull String displayName) {
            this.myName = name2;
            this.myDisplayName = displayName;
        }

        Category(@NotNull String name2) {
            this(name2, name2.equals("av") ? "Audio/Video" : StringUtil.capitalize((String)name2));
        }

        public String toString() {
            return this.myDisplayName;
        }
    }
}

