/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.adtui.ImageComponent;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.utils.Pair;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewIconsPanel
extends JPanel {
    private static final String GENERATED_IMAGE_KEY = "GeneratedImage";
    @NotNull
    private final Theme myTheme;
    @NotNull
    private final Map<String, ImageComponent> myIconImages = new HashMap<String, ImageComponent>();
    private JPanel myRootPanel;
    private JPanel myIconsPanel;
    private JBLabel myTitleLabel;

    public PreviewIconsPanel(@NotNull String title2, @NotNull Theme theme) {
        super(new BorderLayout());
        this.setupUI();
        this.add(this.myRootPanel);
        this.myTitleLabel.setText(title2);
        this.myTitleLabel.setVisible(!title2.isEmpty());
        this.myTheme = theme;
        this.myRootPanel.setBackground(this.myTheme.getMainColor());
        this.myRootPanel.setOpaque(this.myTheme != Theme.TRANSPARENT);
        this.myTitleLabel.setForeground(this.myTheme.getAltColor());
        this.setName("PreviewIconsPanel");
    }

    private void setupUI() {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myRootPanel.setOpaque(true);
        this.myRootPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        this.myIconsPanel = new JPanel();
        this.myIconsPanel.setLayout(new GridBagLayout());
        this.myIconsPanel.setOpaque(false);
        this.myRootPanel.add((Component)this.myIconsPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myTitleLabel = new JBLabel();
        this.myTitleLabel.setText("(title)");
        this.myRootPanel.add((Component)this.myTitleLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    private static void showPreviewImageImpl(@NotNull ImageComponent imageComponent, @NotNull BufferedImage sourceImage) {
        imageComponent.putClientProperty((Object)GENERATED_IMAGE_KEY, (Object)sourceImage);
        JBImageIcon icon = IconUtil.createImageIcon((Image)sourceImage);
        Dimension d = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        imageComponent.setPreferredSize(d);
        imageComponent.setMinimumSize(d);
        imageComponent.setIcon((Icon)icon);
    }

    @NotNull
    public List<IconPreviewInfo> getIconPreviewInfos() {
        ArrayList<IconPreviewInfo> result2 = new ArrayList<IconPreviewInfo>();
        JPanel icons = this.myIconsPanel;
        for (Component icon : icons.getComponents()) {
            JPanel iconPanel = (JPanel)icon;
            JBLabel label2 = (JBLabel)iconPanel.getComponent(0);
            ImageComponent imageComponent = (ImageComponent)iconPanel.getComponent(1);
            IconPreviewInfo previewInfo = new IconPreviewInfo();
            previewInfo.setLabel(label2.getText());
            BufferedImage bufferedImage = (BufferedImage)imageComponent.getClientProperty((Object)GENERATED_IMAGE_KEY);
            if (bufferedImage != null) {
                previewInfo.setImage(bufferedImage);
            }
            previewInfo.setImageBorder(imageComponent.getBorder());
            previewInfo.setImageBackground(iconPanel.getBackground());
            previewInfo.setImageOpaque(iconPanel.isOpaque());
            result2.add(previewInfo);
        }
        return result2;
    }

    public void showPreviewImages(@NotNull IconGeneratorResult iconGeneratorResult) {
        Collection<GeneratedIcon> generatedIcons = iconGeneratorResult.getIcons();
        List<Pair<String, BufferedImage>> list = generatedIcons.stream().filter(icon -> icon instanceof GeneratedImageIcon && icon.getCategory() == IconCategory.PREVIEW).map(icon -> (GeneratedImageIcon)icon).sorted(Comparator.comparingInt(icon -> -icon.getDensity().getDpiValue())).map(icon -> Pair.of((Object)icon.getName(), (Object)icon.getImage())).collect(Collectors.toList());
        this.showPreviewImagesImpl(list);
    }

    protected void showPreviewImagesImpl(@NotNull List<Pair<String, BufferedImage>> images) {
        this.initializeIconComponents(ContainerUtil.map(images, Pair::getFirst));
        images.forEach(pair -> PreviewIconsPanel.showPreviewImageImpl(this.myIconImages.get(pair.getFirst()), (BufferedImage)pair.getSecond()));
    }

    private void initializeIconComponents(@NotNull List<String> labels) {
        int labelIndex;
        for (labelIndex = 0; labelIndex < labels.size(); ++labelIndex) {
            String label2 = labels.get(labelIndex);
            int iconIndex = this.findIconPanel(labelIndex, label2);
            if (iconIndex < 0) {
                JPanel iconPanel = new JPanel((LayoutManager)new VerticalFlowLayout(false, false));
                iconPanel.setName("IconPanel");
                iconPanel.setBackground(this.myTheme.getMainColor());
                iconPanel.setOpaque(this.myTheme != Theme.TRANSPARENT);
                JBLabel title2 = new JBLabel(label2);
                title2.setForeground(this.myTheme.getAltColor());
                iconPanel.add((Component)title2);
                ImageComponent iconImage = new ImageComponent(null);
                iconImage.setBorder((Border)new LineBorder(this.myTheme.getAltColor()));
                iconImage.setOpaque(false);
                iconPanel.add((Component)iconImage);
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 19;
                this.myIconsPanel.add(iconPanel, c, labelIndex);
                this.myIconImages.put(label2, iconImage);
                continue;
            }
            for (int i = labelIndex; i < iconIndex; ++i) {
                this.removeIconPanel(i);
            }
        }
        assert (labelIndex == labels.size());
        assert (this.myIconsPanel.getComponentCount() >= labels.size());
        assert (this.myIconImages.size() == this.myIconsPanel.getComponentCount());
        while (this.myIconsPanel.getComponentCount() > labels.size()) {
            this.removeIconPanel(labels.size());
        }
    }

    private void removeIconPanel(int i) {
        JPanel iconPanel = (JPanel)this.myIconsPanel.getComponent(i);
        String iconLabel = ((JLabel)iconPanel.getComponent(0)).getText();
        this.myIconsPanel.remove(i);
        this.myIconImages.remove(iconLabel);
    }

    private int findIconPanel(int startIndex, String label2) {
        for (int i = startIndex; i < this.myIconsPanel.getComponentCount(); ++i) {
            JPanel iconPanel = (JPanel)this.myIconsPanel.getComponent(i);
            String iconLabel = ((JLabel)iconPanel.getComponent(0)).getText();
            if (!Objects.equals(label2, iconLabel)) continue;
            return i;
        }
        return -1;
    }

    public static enum Theme {
        DARK(Color.BLACK, Color.WHITE),
        LIGHT(Color.WHITE, Color.BLACK),
        GRAY(Color.DARK_GRAY, Color.LIGHT_GRAY),
        TRANSPARENT(UIUtil.TRANSPARENT_COLOR, (Color)JBColor.BLACK);

        private final Color myMainColor;
        private final Color myAltColor;

        private Theme(Color mainColor, Color altColor) {
            this.myMainColor = mainColor;
            this.myAltColor = altColor;
        }

        @NotNull
        public Color getMainColor() {
            return this.myMainColor;
        }

        @NotNull
        public Color getAltColor() {
            return this.myAltColor;
        }
    }

    public static class IconPreviewInfo {
        @Nullable
        private String myLabel;
        @Nullable
        private BufferedImage myImage;
        @Nullable
        private Border myImageBorder;
        private boolean myImageOpaque;
        @Nullable
        private Color myImageBackground;

        public void setLabel(@Nullable String label2) {
            this.myLabel = label2;
        }

        @Nullable
        public String getLabel() {
            return this.myLabel;
        }

        public void setImageBackground(@Nullable Color imageBackground) {
            this.myImageBackground = imageBackground;
        }

        @Nullable
        public Color getImageBackground() {
            return this.myImageBackground;
        }

        public void setImageOpaque(boolean imageOpaque) {
            this.myImageOpaque = imageOpaque;
        }

        public boolean isImageOpaque() {
            return this.myImageOpaque;
        }

        public void setImage(@Nullable BufferedImage image) {
            this.myImage = image;
        }

        @Nullable
        public BufferedImage getImage() {
            return this.myImage;
        }

        public void setImageBorder(@Nullable Border imageBorder) {
            this.myImageBorder = imageBorder;
        }

        @Nullable
        public Border getImageBorder() {
            return this.myImageBorder;
        }
    }
}

