/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.npw.assetstudio.ui.PreviewIconsPanel;
import com.android.utils.Pair;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class LauncherIconsPreviewPanel
extends PreviewIconsPanel {
    LauncherIconsPreviewPanel() {
        super("", PreviewIconsPanel.Theme.TRANSPARENT);
    }

    @Override
    public void showPreviewImages(@NotNull IconGeneratorResult result2) {
        Collection<GeneratedIcon> generatedIcons = result2.getIcons();
        List<Pair<String, BufferedImage>> list = generatedIcons.stream().filter(icon -> icon instanceof GeneratedImageIcon).map(icon -> (GeneratedImageIcon)icon).filter(icon -> this.filterPreviewIcon((GeneratedImageIcon)icon, ((LauncherIconGenerator.LauncherIconOptions)result2.getOptions()).previewDensity)).map(icon -> Pair.of((Object)((Object)LauncherIconsPreviewPanel.getPreviewShapeFromId(icon.getName())), (Object)icon.getImage())).sorted((pair1, pair2) -> LauncherIconsPreviewPanel.comparePreviewShapes((LauncherIconGenerator.PreviewShape)((Object)((Object)pair1.getFirst())), (LauncherIconGenerator.PreviewShape)((Object)((Object)pair2.getFirst())))).map(pair -> Pair.of((Object)((LauncherIconGenerator.PreviewShape)((Object)((Object)pair.getFirst()))).displayName, (Object)((BufferedImage)pair.getSecond()))).collect(Collectors.toList());
        this.showPreviewImagesImpl(list);
    }

    protected boolean filterPreviewIcon(@NotNull GeneratedImageIcon icon, @NotNull Density density) {
        return icon.getCategory() == IconCategory.PREVIEW && icon.getDensity() == density;
    }

    private static int comparePreviewShapes(@NotNull LauncherIconGenerator.PreviewShape x, @NotNull LauncherIconGenerator.PreviewShape y) {
        return Integer.compare(LauncherIconsPreviewPanel.getPreviewShapeDisplayOrder(x), LauncherIconsPreviewPanel.getPreviewShapeDisplayOrder(y));
    }

    private static int getPreviewShapeDisplayOrder(@NotNull LauncherIconGenerator.PreviewShape previewShape) {
        return switch (previewShape) {
            case LauncherIconGenerator.PreviewShape.MONOCHROME_CIRCLE -> 0;
            case LauncherIconGenerator.PreviewShape.CIRCLE -> 1;
            case LauncherIconGenerator.PreviewShape.SQUIRCLE -> 2;
            case LauncherIconGenerator.PreviewShape.ROUNDED_SQUARE -> 3;
            case LauncherIconGenerator.PreviewShape.SQUARE -> 4;
            case LauncherIconGenerator.PreviewShape.FULL_BLEED -> 5;
            case LauncherIconGenerator.PreviewShape.LEGACY -> 6;
            case LauncherIconGenerator.PreviewShape.LEGACY_ROUND -> 7;
            case LauncherIconGenerator.PreviewShape.PLAY_STORE -> 8;
            default -> 1000;
        };
    }

    @NotNull
    private static LauncherIconGenerator.PreviewShape getPreviewShapeFromId(@NotNull String previewShapeId) {
        for (LauncherIconGenerator.PreviewShape shape : LauncherIconGenerator.PreviewShape.values()) {
            if (!Objects.equals(shape.id, previewShapeId)) continue;
            return shape;
        }
        return LauncherIconGenerator.PreviewShape.SQUARE;
    }
}

