/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.perfetto.config.PerfettoTraceConfigBuilders;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidProfilerLaunchTaskContributor
implements AndroidLaunchTaskContributor {
    private static final String STARTUP_AGENT_CONFIG_NAME = "startupagent.config";

    private static Logger getLogger() {
        return Logger.getInstance(AndroidProfilerLaunchTaskContributor.class);
    }

    @Override
    @NotNull
    public String getAmStartOptions(@NotNull String applicationId2, @NotNull AndroidRunConfigurationBase configuration2, @NotNull IDevice device2, @NotNull Executor executor) {
        return AndroidProfilerLaunchTaskContributor.getAmStartOptions(configuration2.getProject(), applicationId2, configuration2.getProfilerState(), device2, executor);
    }

    public static String getAmStartOptions(@NotNull Project project, @NotNull String applicationId2, @Nullable ProfilerState profilerState, @NotNull IDevice device2, @NotNull Executor executor) {
        Common.Device profilerDevice;
        if (!AndroidProfilerLaunchTaskContributor.isProfilerLaunch(executor)) {
            return "";
        }
        if (profilerState == null) {
            return "";
        }
        TransportService transportService = TransportService.getInstance();
        ProfilerClient client = new ProfilerClient(TransportService.getChannelName());
        try {
            profilerDevice = AndroidProfilerLaunchTaskContributor.waitForDaemon(device2, client);
        }
        catch (TimeoutException | InterruptedException e) {
            client.shutdownChannel();
            AndroidProfilerLaunchTaskContributor.getLogger().debug(e);
            return "";
        }
        TransportFileManager fileManager = new TransportFileManager(device2);
        AndroidProfilerLaunchTaskContributor.pushStartupAgentConfig(fileManager, project);
        String agentArgs = fileManager.configureStartupAgent(applicationId2, STARTUP_AGENT_CONFIG_NAME, executor.getId());
        String startupProfilingResult = AndroidProfilerLaunchTaskContributor.startStartupProfiling(profilerState, applicationId2, project, client, device2, profilerDevice);
        if (((Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get()).booleanValue()) {
            profilerState.disableStartupProfiling();
        }
        client.shutdownChannel();
        return String.format("%s %s", agentArgs, startupProfilingResult);
    }

    private static void pushStartupAgentConfig(@NotNull TransportFileManager fileManager, @NotNull Project project) {
        try {
            fileManager.pushAgentConfig(STARTUP_AGENT_CONFIG_NAME, AndroidProfilerLaunchTaskContributor.getSelectedRunConfiguration(project));
        }
        catch (ShellCommandUnresponsiveException | SyncException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (AdbCommandRejectedException | IOException e) {
            AndroidProfilerLaunchTaskContributor.getLogger().warn("Error when trying to push AgentConfig:", e);
        }
    }

    @NotNull
    private static String startStartupProfiling(@NotNull ProfilerState profilerState, @NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device2, @NotNull Common.Device profilerDevice) {
        if (profilerState.isCpuStartupProfilingEnabled()) {
            return AndroidProfilerLaunchTaskContributor.triggerCpuStartupProfilingAndReturnArtParams(profilerState, appPackageName, project, client, device2, profilerDevice);
        }
        if (profilerState.isNativeMemoryStartupProfilingEnabled()) {
            AndroidProfilerLaunchTaskContributor.triggerMemoryStartupProfiling(profilerState, appPackageName, project, client, device2, profilerDevice);
        }
        return "";
    }

    private static void triggerMemoryStartupProfiling(@NotNull ProfilerState profilerState, @NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device2, @NotNull Common.Device profilerDevice) {
        if (!AndroidProfilerLaunchTaskContributor.isAtLeast(device2, 29)) {
            AndroidNotification.getInstance((Project)project).showBalloon("Startup Native Memory Profiling", "Starting a native memory sampling trace recording on startup is only supported on devices with API levels 29 and higher.", NotificationType.WARNING);
            return;
        }
        if (device2.getAbis().isEmpty()) {
            AndroidNotification.getInstance((Project)project).showBalloon("Startup Native Memory Profiling", "Unable to detect device abi for startup memory profiling.", NotificationType.WARNING);
            return;
        }
        String abi = (String)device2.getAbis().get(0);
        StudioFeatureTracker featureTracker = new StudioFeatureTracker(project);
        featureTracker.trackRecordAllocations();
        String traceFilePath = String.format(Locale.US, "%s/%s.trace", "/data/local/tmp/perfd", appPackageName);
        Trace.TraceConfiguration configuration2 = Trace.TraceConfiguration.newBuilder().setAppName(appPackageName).setInitiationType(Trace.TraceInitiationType.INITIATED_BY_STARTUP).setAbiCpuArch(abi).setPerfettoOptions(PerfettoTraceConfigBuilders.INSTANCE.getMemoryTraceConfig(appPackageName, (long)profilerState.NATIVE_MEMORY_SAMPLE_RATE_BYTES)).setTempPath(traceFilePath).build();
        Commands.Command sampleCommand = Commands.Command.newBuilder().setStreamId(profilerDevice.getDeviceId()).setType(Commands.Command.CommandType.START_TRACE).setStartTrace(Trace.StartTrace.newBuilder().setProfilerType(Trace.ProfilerType.MEMORY).setConfiguration(configuration2)).build();
        Transport.ExecuteResponse response2 = client.getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(sampleCommand).build());
    }

    private static String triggerCpuStartupProfilingAndReturnArtParams(@NotNull ProfilerState profilerState, @NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device2, @NotNull Common.Device profilerDevice) {
        String configName = profilerState.STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
        if (configName == null) {
            return "";
        }
        CpuProfilerConfig startupConfig = CpuProfilerConfigsState.getInstance(project).getConfigByName(configName);
        if (startupConfig == null) {
            return "";
        }
        if (!AndroidProfilerLaunchTaskContributor.isAtLeast(device2, 26)) {
            AndroidNotification.getInstance((Project)project).showBalloon("Startup CPU Profiling", "Starting a method trace recording on startup is only supported on devices with API levels 26 and higher.", NotificationType.WARNING);
            return "";
        }
        String cpuAbi = "";
        switch (startupConfig.getTechnology()) {
            case SAMPLED_NATIVE: {
                cpuAbi = AndroidProfilerLaunchTaskContributor.getAbiDependentLibraryName("simpleperf", "simpleperf", device2);
                break;
            }
            case SYSTEM_TRACE: {
                cpuAbi = AndroidProfilerLaunchTaskContributor.getAbiDependentLibraryName("perfetto", "perfetto", device2);
                break;
            }
        }
        String traceFilePath = String.format(Locale.US, "%s/%s-%d.trace", "/data/local/tmp/perfd", appPackageName, System.nanoTime());
        ProfilingConfiguration profilingConfiguration = CpuProfilerConfigConverter.toProfilingConfiguration(startupConfig, device2.getVersion().getFeatureLevel());
        Trace.TraceConfiguration.Builder configurationBuilder = Trace.TraceConfiguration.newBuilder().setAppName(appPackageName).setInitiationType(Trace.TraceInitiationType.INITIATED_BY_STARTUP).setAbiCpuArch(cpuAbi).setTempPath(traceFilePath);
        profilingConfiguration.addOptions(configurationBuilder, Map.of(ProfilingConfiguration.AdditionalOptions.APP_PKG_NAME, appPackageName));
        Trace.TraceConfiguration configuration2 = configurationBuilder.build();
        try {
            Commands.Command startCommand = Commands.Command.newBuilder().setStreamId(profilerDevice.getDeviceId()).setType(Commands.Command.CommandType.START_TRACE).setStartTrace(Trace.StartTrace.newBuilder().setProfilerType(Trace.ProfilerType.CPU).setConfiguration(configuration2).build()).build();
            Transport.ExecuteResponse executeResponse = client.getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(startCommand).build());
        }
        catch (StatusRuntimeException exception) {
            AndroidProfilerLaunchTaskContributor.getLogger().error((Throwable)exception);
        }
        StudioFeatureTracker featureTracker = new StudioFeatureTracker(project);
        featureTracker.trackCpuStartupProfiling(profilerDevice, ProfilingConfiguration.fromProto((Trace.TraceConfiguration)configuration2, (boolean)((Boolean)StudioFlags.PROFILER_TRACEBOX.get())));
        if (profilingConfiguration.getTraceType() != ProfilingConfiguration.TraceType.ART) {
            return "";
        }
        StringBuilder argsBuilder = new StringBuilder("--start-profiler ").append(traceFilePath);
        if (startupConfig.getTechnology() == CpuProfilerConfig.Technology.SAMPLED_JAVA) {
            argsBuilder.append(" --sampling ").append(startupConfig.getSamplingIntervalUs());
        }
        if (AndroidProfilerLaunchTaskContributor.isAtLeast(device2, 34) && !startupConfig.getDualClock()) {
            argsBuilder.append(" --clock-type wall");
        }
        argsBuilder.append(" --streaming");
        return argsBuilder.toString();
    }

    private static boolean isAtLeast(@NotNull IDevice device2, int version2) {
        return device2.getVersion().getFeatureLevel() >= version2;
    }

    @Nullable
    private static AndroidRunConfigurationBase getSelectedRunConfiguration(@NotNull Project project) {
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings != null && settings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            return (AndroidRunConfigurationBase)settings.getConfiguration();
        }
        return null;
    }

    @NotNull
    private static Common.Device waitForDaemon(@NotNull IDevice device2, @NotNull ProfilerClient client) throws InterruptedException, TimeoutException {
        for (int i = 0; i < 60; ++i) {
            Common.Device profilerDevice = AndroidProfilerLaunchTaskContributor.getProfilerDevice(device2, client);
            if (!Common.Device.getDefaultInstance().equals((Object)profilerDevice)) {
                return profilerDevice;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        throw new TimeoutException("Timeout waiting for daemon");
    }

    @NotNull
    private static Common.Device getProfilerDevice(@NotNull IDevice device2, @NotNull ProfilerClient client) {
        List devices2 = StudioProfilers.getUpToDateDevices((ProfilerClient)client, null, null);
        for (Common.Device profilerDevice : devices2) {
            if (!profilerDevice.getSerial().equals(device2.getSerialNumber()) || profilerDevice.getState() != Common.Device.State.ONLINE) continue;
            return profilerDevice;
        }
        return Common.Device.getDefaultInstance();
    }

    @NotNull
    private static String getAbiDependentLibraryName(String dir, String fileName, IDevice device2) {
        return AndroidProfilerLaunchTaskContributor.getBestAbiCpuArch(device2, "plugins/android/resources/" + dir, "prebuilts/tools/common/" + dir, fileName);
    }

    @NotNull
    private static String getBestAbiCpuArch(@NotNull IDevice device2, @NotNull String releaseDir, @NotNull String devDir, @NotNull String fileName) {
        Path dir = StudioPathManager.isRunningFromSources() ? StudioPathManager.resolvePathFromSourcesRoot((String)devDir) : Paths.get(PathManager.getHomePath(), releaseDir);
        for (String abi : device2.getAbis()) {
            Path candidate = dir.resolve(abi).resolve(fileName);
            if (!Files.exists(candidate, new LinkOption[0])) continue;
            return Abi.getEnum((String)abi).getCpuArch();
        }
        return "";
    }

    public static boolean isProfilerLaunch(@NotNull Executor executor) {
        return "Android Profiler".equals(executor.getId()) || AbstractProfilerExecutorGroup.Companion.getExecutorSetting(executor.getId()) != null;
    }
}

