/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerWindowManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profilers/StudioProfilersView;)V", "isProfilingActiveBalloonShown", "", "wasWindowExpanded", "endedTaskIDs", "", "", "stateChanged", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "Companion", "intellij.android.profilersAndroid"})
public final class AndroidProfilerWindowManagerListener
implements ToolWindowManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final StudioProfilersView profilersView;
    private boolean isProfilingActiveBalloonShown;
    private boolean wasWindowExpanded;
    @NotNull
    private final Set<Long> endedTaskIDs;
    @NotNull
    public static final String HIDE_STOP_PROMPT = "profilers.hide.stop.prompt";

    public AndroidProfilerWindowManagerListener(@NotNull Project project, @NotNull StudioProfilers profilers, @NotNull StudioProfilersView profilersView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profilers, (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)profilersView, (String)"profilersView");
        this.project = project;
        this.profilers = profilers;
        this.profilersView = profilersView;
        this.endedTaskIDs = new LinkedHashSet();
    }

    public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Android Profiler");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window2 = toolWindow;
        boolean isTaskBasedUxEnabled = this.profilers.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled();
        boolean hasAliveSession = isTaskBasedUxEnabled ? this.profilers.getSessionsManager().isSessionAlive() : SessionsManager.isSessionAlive((Common.Session)this.profilers.getSessionsManager().getProfilingSession());
        boolean isWindowTabHidden = !window2.isShowStripeButton();
        boolean isWindowExpanded = window2.isVisible();
        boolean windowVisibilityChanged = isWindowExpanded != this.wasWindowExpanded;
        this.wasWindowExpanded = isWindowExpanded;
        if (isWindowTabHidden) {
            long taskID = this.profilers.getSessionsManager().getSelectedSession().getSessionId();
            if (isTaskBasedUxEnabled && this.endedTaskIDs.contains(taskID)) {
                return;
            }
            if (hasAliveSession) {
                boolean confirm;
                boolean hidePrompt = this.profilers.getIdeServices().getPersistentProfilerPreferences().getBoolean(HIDE_STOP_PROMPT, false);
                boolean bl = hidePrompt || this.profilersView.getIdeProfilerComponents().createUiMessageHandler().displayOkCancelMessage("Confirm Stop " + (isTaskBasedUxEnabled ? "Task" : "Profiling"), "Hiding the window will stop the current " + (isTaskBasedUxEnabled ? "ongoing task" : "profiling session") + ". Are you sure?", "Yes", "Cancel", null, arg_0 -> AndroidProfilerWindowManagerListener.stateChanged$lambda$0(this, arg_0)) ? true : (confirm = false);
                if (!confirm) {
                    window2.setShowStripeButton(true);
                    return;
                }
            }
            if (isTaskBasedUxEnabled) {
                ProfilerTaskHandler profilerTaskHandler = this.profilers.getCurrentTaskHandler();
                if (profilerTaskHandler != null) {
                    ProfilerTaskHandler it = profilerTaskHandler;
                    boolean bl = false;
                    it.stopTask();
                    this.endedTaskIDs.add(taskID);
                }
            } else {
                this.profilers.stop();
            }
            return;
        }
        if (isWindowExpanded) {
            PreferredProcessInfo processInfo;
            this.isProfilingActiveBalloonShown = false;
            if (windowVisibilityChanged && !isTaskBasedUxEnabled && (processInfo = (PreferredProcessInfo)this.project.getUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO)) != null && Intrinsics.areEqual((Object)Common.Session.getDefaultInstance(), (Object)this.profilers.getSession())) {
                this.profilers.setPreferredProcess(processInfo.getDeviceName(), processInfo.getProcessName(), arg_0 -> AndroidProfilerWindowManagerListener.stateChanged$lambda$2(processInfo, arg_0));
            }
        } else {
            this.profilers.setAutoProfilingEnabled(false);
            if (hasAliveSession && !this.isProfilingActiveBalloonShown) {
                this.isProfilingActiveBalloonShown = true;
                String messageHtml = isTaskBasedUxEnabled ? "A task is running in the background.<br>To end the task, open the profiler and click the stop button." : "A profiler session is running in the background.<br>To end the session, open the profiler and click the stop button in the Sessions pane.";
                ToolWindowManager toolWindowManager2 = ToolWindowManager.Companion.getInstance(this.project);
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                toolWindowManager2.notifyByBalloon("Android Profiler", messageType, messageHtml);
            }
        }
    }

    private static final void stateChanged$lambda$0(AndroidProfilerWindowManagerListener this$0, boolean doNotShow) {
        this$0.profilers.getIdeServices().getPersistentProfilerPreferences().setBoolean(HIDE_STOP_PROMPT, doNotShow);
    }

    private static final boolean stateChanged$lambda$2(PreferredProcessInfo $processInfo, Common.Process p) {
        Function1<Common.Process, Boolean> function1 = $processInfo.getProcessFilter();
        Common.Process process2 = p;
        Intrinsics.checkNotNull((Object)process2);
        return (Boolean)function1.invoke((Object)process2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerWindowManagerListener$Companion;", "", "<init>", "()V", "HIDE_STOP_PROMPT", "", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

