/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.adtui.TabularLayout;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListBoxChooserDialog<T>
extends DialogWrapper {
    @Nullable
    private final String myMessage;
    @NotNull
    private T mySelectedOption;
    @NotNull
    private final Presentation myActivePresentation;
    @NotNull
    private final List<T> myOptions;
    @NotNull
    private final Function<T, String> myPresentationAdapter;

    public ListBoxChooserDialog(@NotNull String title2, @Nullable String message, @NotNull List<T> options, @NotNull Function<T, String> presentationAdapter) {
        super(false);
        this.setTitle(title2);
        this.myMessage = message;
        this.myPresentationAdapter = presentationAdapter;
        this.myOptions = options;
        assert (!this.myOptions.isEmpty());
        this.mySelectedOption = this.myOptions.get(0);
        this.myActivePresentation = new Presentation();
        this.init();
    }

    private void updateActivePresentation() {
        this.myActivePresentation.setText(this.myPresentationAdapter.apply(this.mySelectedOption));
    }

    @NotNull
    public T getSelectedValue() {
        return this.mySelectedOption;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel((LayoutManager)new TabularLayout("*", "Fit-,5px,*,5px")){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }
        };
        if (this.myMessage != null) {
            panel2.add((Component)new JLabel(this.myMessage), new TabularLayout.Constraint(0, 0));
        }
        this.updateActivePresentation();
        panel2.add((Component)new OptionsSelectorComboBox().createCustomComponent(this.myActivePresentation, "unknown"), new TabularLayout.Constraint(2, 0));
        return panel2;
    }

    private class OptionsSelectorComboBox
    extends ComboBoxAction {
        NonOpaquePanel myPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());

        private OptionsSelectorComboBox() {
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            ComboBoxAction.ComboBoxButton button = new ComboBoxAction.ComboBoxButton(presentation){

                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = Math.max(d.width, JBUI.scale((int)75));
                    return d;
                }
            };
            this.myPanel.setBorder((Border)JBUI.Borders.emptyRight((int)2));
            this.myPanel.add((Component)button);
            return this.myPanel;
        }

        protected int getMaxRows() {
            return 10;
        }

        protected int getMinWidth() {
            return this.myPanel.getWidth();
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
            DefaultActionGroup allActionsGroup = new DefaultActionGroup();
            for (Object option : ListBoxChooserDialog.this.myOptions) {
                SelectTargetAction action2 = new SelectTargetAction(option);
                allActionsGroup.add((AnAction)action2);
            }
            return allActionsGroup;
        }
    }

    private class SelectTargetAction
    extends AnAction {
        private final T myOption;

        private SelectTargetAction(T option) {
            this.myOption = option;
            String name2 = ListBoxChooserDialog.this.myPresentationAdapter.apply(option);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name2, false);
        }

        public void actionPerformed(AnActionEvent e) {
            ListBoxChooserDialog.this.mySelectedOption = this.myOption;
            ListBoxChooserDialog.this.updateActivePresentation();
        }
    }
}

