/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutor;", "Lcom/intellij/execution/executors/DefaultRunExecutor;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "getDisabledIcon", "getDescription", "", "getActionName", "getId", "getStartActionText", "getContextActionId", "getHelpId", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.android.profilersAndroid"})
public final class ProfileRunExecutor
extends DefaultRunExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EXECUTOR_ID = "Android Profiler";

    @NotNull
    public Icon getIcon() {
        Icon icon = StudioIcons.Shell.Toolbar.PROFILER;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PROFILER");
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = StudioIcons.Shell.ToolWindows.ANDROID_PROFILER;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ANDROID_PROFILER");
        return icon;
    }

    @NotNull
    public String getDescription() {
        return "Profile selected configuration";
    }

    @NotNull
    public String getActionName() {
        return "Profile";
    }

    @NotNull
    public String getId() {
        return EXECUTOR_ID;
    }

    @NotNull
    public String getStartActionText() {
        return "Profile";
    }

    @NotNull
    public String getContextActionId() {
        return "ProfileRunClass";
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public boolean isApplicable(@NotNull Project project) {
        boolean isProfilingModeSupported;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = isProfilingModeSupported = ProjectSystemUtil.getProjectSystem(project).supportsProfilingMode();
        if (isProfilingModeSupported) {
            return false;
        }
        return CommonAndroidUtil.getInstance().isAndroidProject(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutor$Companion;", "", "<init>", "()V", "EXECUTOR_ID", "", "getInstance", "Lcom/intellij/execution/Executor;", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Executor getInstance() {
            return ExecutorRegistry.getInstance().getExecutorById(ProfileRunExecutor.EXECUTOR_ID);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

