/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.profilers.AndroidProfilerWindowManagerListener;
import com.android.tools.idea.profilers.StudioProfilersTab;
import com.android.tools.idea.profilers.ToolWindowWrapper;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.TaskProfilersView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import icons.StudioIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/profilers/StudioProfilersTaskTab;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/android/tools/idea/profilers/StudioProfilersTab;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "window", "Lcom/android/tools/idea/profilers/ToolWindowWrapper;", "ideProfilerComponents", "Lcom/android/tools/profilers/IdeProfilerComponents;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/idea/profilers/ToolWindowWrapper;Lcom/android/tools/profilers/IdeProfilerComponents;Lcom/intellij/openapi/project/Project;)V", "view", "Lcom/android/tools/profilers/StudioProfilersView;", "getView", "()Lcom/android/tools/profilers/StudioProfilersView;", "selectedSessionChanged", "", "dispose", "intellij.android.profilersAndroid"})
public final class StudioProfilersTaskTab
extends AspectObserver
implements StudioProfilersTab {
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final ToolWindowWrapper window;
    @NotNull
    private final StudioProfilersView view;

    public StudioProfilersTaskTab(@NotNull StudioProfilers profilers, @NotNull ToolWindowWrapper window2, @NotNull IdeProfilerComponents ideProfilerComponents, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)profilers, (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)window2, (String)"window");
        Intrinsics.checkNotNullParameter((Object)ideProfilerComponents, (String)"ideProfilerComponents");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.profilers = profilers;
        this.window = window2;
        this.profilers.getSessionsManager().addDependency((AspectObserver)this).onChange((Enum)SessionAspect.SELECTED_SESSION, () -> StudioProfilersTaskTab._init_$lambda$0(this));
        this.view = (StudioProfilersView)new TaskProfilersView(this.profilers, ideProfilerComponents, (Disposable)this);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AndroidProfilerWindowManagerListener(project, this.profilers, this.getView()));
    }

    @Override
    @NotNull
    public StudioProfilersView getView() {
        return this.view;
    }

    private final void selectedSessionChanged() {
        Icon icon = this.profilers.getSessionsManager().isSessionAlive() ? ExecutionUtil.getLiveIndicator((Icon)StudioIcons.Shell.ToolWindows.ANDROID_PROFILER) : StudioIcons.Shell.ToolWindows.ANDROID_PROFILER;
        Intrinsics.checkNotNull((Object)icon);
        this.window.setIcon(icon);
    }

    public void dispose() {
        this.profilers.getSessionsManager().removeDependencies((AspectObserver)this);
    }

    private static final void _init_$lambda$0(StudioProfilersTaskTab this$0) {
        this$0.selectedSessionChanged();
    }
}

