/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfetto.traceprocessor;

import com.android.tools.idea.profilers.perfetto.traceprocessor.NameDemangler;
import com.android.tools.idea.profilers.perfetto.traceprocessor.NameHolder;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/WindowsNameDemangler;", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/NameDemangler;", "timeoutMsc", "", "<init>", "(J)V", "getTimeoutMsc", "()J", "getLlvmCppFiltPath", "", "demangleInplace", "", "stackFrames", "", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/NameHolder;", "start", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/WindowsNameDemangler$ProcessHolder;", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$intellij_android_profilersAndroid", "ProcessHolder", "intellij.android.profilersAndroid"})
public final class WindowsNameDemangler
implements NameDemangler {
    private final long timeoutMsc;

    public WindowsNameDemangler(long timeoutMsc) {
        this.timeoutMsc = timeoutMsc;
    }

    public /* synthetic */ WindowsNameDemangler(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 5000L;
        }
        this(l);
    }

    public final long getTimeoutMsc() {
        return this.timeoutMsc;
    }

    private final String getLlvmCppFiltPath() {
        Path path;
        String exe = "x86_64-linux-android-c++filt.exe";
        if (StudioPathManager.isRunningFromSources()) {
            path = StudioPathManager.resolvePathFromSourcesRoot((String)("prebuilts/tools/windows-x86_64/lldb/bin/" + exe));
        } else {
            String[] stringArray = new String[]{"plugins/android-ndk/resources/lldb/bin/" + exe};
            path = Paths.get(PathManager.getHomePath(), stringArray);
        }
        Path result2 = path;
        return ((Object)result2).toString();
    }

    @Override
    public void demangleInplace(@NotNull Collection<? extends NameHolder> stackFrames) {
        Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
        if (!SystemInfo.isWindows) {
            return;
        }
        ProcessHolder holder = this.start();
        if (holder == null) {
            return;
        }
        HashMap duplicatesMap = new HashMap();
        for (NameHolder nameHolder : stackFrames) {
            try {
                if (duplicatesMap.containsKey(nameHolder.getName())) {
                    Object v = duplicatesMap.get(nameHolder.getName());
                    Intrinsics.checkNotNull(v);
                    nameHolder.setName((String)v);
                    continue;
                }
                if (!StringsKt.startsWith$default((String)nameHolder.getName(), (String)"_Z", (boolean)false, (int)2, null)) continue;
                holder.getStdin().write(nameHolder.getName() + "\n");
                holder.getStdin().flush();
                String string = holder.getStdout().readLine();
                if (string == null) {
                    string = nameHolder.getName();
                }
                String response2 = string;
                ((Map)duplicatesMap).put(nameHolder.getName(), response2);
                nameHolder.setName(response2);
            }
            catch (Exception ex) {
                this.getLogger$intellij_android_profilersAndroid().error((Throwable)ex);
            }
        }
        holder.dispose();
    }

    private final ProcessHolder start() {
        ProcessHolder procHolder = null;
        try {
            String llvmfiltPath = this.getLlvmCppFiltPath();
            String[] stringArray = new String[]{llvmfiltPath};
            ProcessBuilder builder = new ProcessBuilder(stringArray);
            Process process2 = builder.start();
            if (!process2.isAlive()) {
                throw new IOException("C++ filt process is not alive. Executable: " + llvmfiltPath);
            }
            OutputStreamWriter stdin = new OutputStreamWriter(process2.getOutputStream(), Charsets.UTF_8);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(process2.getInputStream(), Charsets.UTF_8));
            Intrinsics.checkNotNull((Object)process2);
            procHolder = new ProcessHolder(process2, stdout, stdin, this.timeoutMsc);
        }
        catch (Exception e) {
            Logger.getInstance((String)"CppNameDemangler").error((Throwable)e);
            procHolder = null;
        }
        return procHolder;
    }

    @NotNull
    public final Logger getLogger$intellij_android_profilersAndroid() {
        Logger logger = Logger.getInstance((String)"CppNameDemangler");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public WindowsNameDemangler() {
        this(0L, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/WindowsNameDemangler$ProcessHolder;", "Lcom/intellij/openapi/Disposable;", "process", "Ljava/lang/Process;", "stdout", "Ljava/io/BufferedReader;", "stdin", "Ljava/io/OutputStreamWriter;", "timeoutMsc", "", "<init>", "(Ljava/lang/Process;Ljava/io/BufferedReader;Ljava/io/OutputStreamWriter;J)V", "getProcess", "()Ljava/lang/Process;", "getStdout", "()Ljava/io/BufferedReader;", "getStdin", "()Ljava/io/OutputStreamWriter;", "getTimeoutMsc", "()J", "dispose", "", "intellij.android.profilersAndroid"})
    private static final class ProcessHolder
    implements Disposable {
        @NotNull
        private final Process process;
        @NotNull
        private final BufferedReader stdout;
        @NotNull
        private final OutputStreamWriter stdin;
        private final long timeoutMsc;

        public ProcessHolder(@NotNull Process process2, @NotNull BufferedReader stdout, @NotNull OutputStreamWriter stdin, long timeoutMsc) {
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
            this.process = process2;
            this.stdout = stdout;
            this.stdin = stdin;
            this.timeoutMsc = timeoutMsc;
        }

        @NotNull
        public final Process getProcess() {
            return this.process;
        }

        @NotNull
        public final BufferedReader getStdout() {
            return this.stdout;
        }

        @NotNull
        public final OutputStreamWriter getStdin() {
            return this.stdin;
        }

        public final long getTimeoutMsc() {
            return this.timeoutMsc;
        }

        public void dispose() {
            this.process.destroy();
            this.process.waitFor(this.timeoutMsc, TimeUnit.MILLISECONDS);
        }
    }
}

