/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueEvent;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueFileEvent;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.project.hyperlink.SyncMessageFragment;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class AbstractSyncMessages
implements Disposable {
    private Project myProject;
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final List<SyncMessage> myCurrentMessages = new ArrayList<SyncMessage>();
    @NotNull
    private static final String PENDING_TASK_ID = "Pending taskId";

    protected AbstractSyncMessages(@NotNull Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getErrorDescription() {
        LinkedHashSet<String> errorGroups = new LinkedHashSet<String>();
        Object object = this.myLock;
        synchronized (object) {
            for (SyncMessage message : this.myCurrentMessages) {
                if (message.getType() != MessageType.ERROR) continue;
                errorGroups.add(message.getGroup());
            }
        }
        return String.join((CharSequence)", ", errorGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentMessages.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMessages() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(@NotNull SyncMessage message) {
        Object taskId;
        String title2 = message.getGroup();
        String text2 = message.getText();
        NotificationCategory category = message.getType().convertToCategory();
        PositionInFile position = message.getPosition();
        NotificationData notification = this.createNotification(title2, text2, category, position);
        Navigatable navigatable2 = message.getNavigatable();
        notification.setNavigatable(navigatable2);
        List<SyncMessageFragment> quickFixes = message.getQuickFixes();
        if (!quickFixes.isEmpty()) {
            this.updateNotification(notification, text2, quickFixes);
        }
        if ((taskId = GradleSyncState.getInstance(this.myProject).getExternalSystemTaskId()) == null) {
            taskId = PENDING_TASK_ID;
        } else {
            this.showNotification(notification, taskId, ContainerUtil.flatMap(quickFixes, AndroidSyncIssueQuickFix::create));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentMessages.add(message);
        }
    }

    @NotNull
    public NotificationData createNotification(@NotNull String title2, @NotNull String text2, @NotNull NotificationCategory category, @Nullable PositionInFile position) {
        NotificationSource source2 = NotificationSource.PROJECT_SYNC;
        if (position != null) {
            String filePath = VfsUtilCore.virtualToIoFile((VirtualFile)position.file).getPath();
            return new NotificationData(title2, text2, category, source2, filePath, position.line, position.column, false);
        }
        return new NotificationData(title2, text2, category, source2);
    }

    private void updateNotification(@NotNull NotificationData notification, @NotNull String text2, @NotNull List<? extends SyncMessageFragment> quickFixes) {
        Object message = text2;
        StringBuilder b = new StringBuilder();
        for (SyncMessageFragment syncMessageFragment : quickFixes) {
            String html = syncMessageFragment.toHtml();
            if (html.isEmpty()) continue;
            if (b.length() > 0) {
                b.append("\n");
            }
            b.append(html);
        }
        if (b.length() > 0) {
            message = (String)message + "\n" + b.toString();
        }
        notification.setMessage((String)message);
        this.addNotificationListener(notification, quickFixes);
    }

    private void addNotificationListener(@NotNull NotificationData notification, @NotNull List<? extends SyncMessageFragment> quickFixes) {
        for (SyncMessageFragment syncMessageFragment : quickFixes) {
            for (String url : syncMessageFragment.getUrls()) {
                notification.setListener(url, (NotificationListener)new QuickFixNotificationListener(this.myProject, syncMessageFragment));
            }
        }
    }

    private void showNotification(@NotNull NotificationData notification, @NotNull Object taskId, @NotNull List<? extends BuildIssueQuickFix> quickFixes) {
        String title2 = notification.getMessage().lines().findFirst().orElse(notification.getTitle());
        AndroidSyncIssueEvent issueEvent = notification.getFilePath() != null ? new AndroidSyncIssueFileEvent(taskId, notification, title2, quickFixes) : new AndroidSyncIssueEvent(taskId, notification, title2, quickFixes);
        ((SyncViewManager)this.myProject.getService(SyncViewManager.class)).onEvent(taskId, (BuildEvent)issueEvent);
    }

    @NotNull
    protected abstract ProjectSystemId getProjectSystemId();

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @NotNull
    public List<SyncMessage> getReportedMessages() {
        Object object = this.myLock;
        synchronized (object) {
            return new ArrayList<SyncMessage>(this.myCurrentMessages);
        }
    }

    public void dispose() {
        this.myProject = null;
    }
}

