/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem;

import com.google.common.base.Strings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AndroidProjectRootUtil {
    private AndroidProjectRootUtil() {
    }

    @Nullable
    public static @SystemIndependent String getModuleDirPath(@NotNull Module module) {
        String linkedProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (!Strings.isNullOrEmpty((String)linkedProjectPath)) {
            return linkedProjectPath;
        }
        @SystemIndependent String moduleFilePath = module.getModuleFilePath();
        return VfsUtil.getParentDir((String)moduleFilePath);
    }

    @Nullable
    public static VirtualFile getFileByRelativeModulePath(Module module, String relativePath, boolean lookInContentRoot) {
        if (module.isDisposed() || relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        ProgressManager.checkCanceled();
        String moduleDirPath = AndroidProjectRootUtil.getModuleDirPath(module);
        if (moduleDirPath != null) {
            String absPath = FileUtil.toSystemIndependentName((String)(moduleDirPath + relativePath));
            ProgressManager.checkCanceled();
            VirtualFile file = VirtualFileManager.getInstance().getFileSystem("file").findFileByPath(absPath);
            if (file != null) {
                return file;
            }
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (lookInContentRoot) {
            for (VirtualFile contentRoot : contentRoots) {
                String absPath = FileUtil.toSystemIndependentName((String)(contentRoot.getPath() + relativePath));
                ProgressManager.checkCanceled();
                VirtualFile file = VirtualFileManager.getInstance().getFileSystem("file").findFileByPath(absPath);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAptGenSourceRootPath(@NotNull AndroidFacet facet) {
        String path = facet.getProperties().GEN_FOLDER_RELATIVE_PATH_APT;
        if (path.isEmpty()) {
            return null;
        }
        @SystemIndependent String moduleDirPath = AndroidProjectRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? moduleDirPath + path : null;
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAidlGenSourceRootPath(@NotNull AndroidFacet facet) {
        String path = facet.getProperties().GEN_FOLDER_RELATIVE_PATH_AIDL;
        if (path.isEmpty()) {
            return null;
        }
        @SystemIndependent String moduleDirPath = AndroidProjectRootUtil.getModuleDirPath(facet.getModule());
        return moduleDirPath != null ? moduleDirPath + path : null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAidlGenDir(@NotNull AndroidFacet facet) {
        String genPath = AndroidProjectRootUtil.getAidlGenSourceRootPath(facet);
        return genPath != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    @Deprecated
    @Nullable
    public static String getRenderscriptGenSourceRootPath(@NotNull AndroidFacet facet) {
        return AndroidProjectRootUtil.getAidlGenSourceRootPath(facet);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getRenderscriptGenDir(@NotNull AndroidFacet facet) {
        String path = AndroidProjectRootUtil.getRenderscriptGenSourceRootPath(facet);
        return path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAssetsDir(@NotNull AndroidFacet facet) {
        return AndroidProjectRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().ASSETS_FOLDER_RELATIVE_PATH, false);
    }
}

