/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.IdeNetworkCacheUtils;
import com.android.ide.common.repository.NetworkCache;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.gradle.IdeGooglePlaySdkIndexKt;
import com.android.tools.lint.checks.GooglePlaySdkIndex;
import com.android.tools.lint.detector.api.LintFix;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.SdkIndexLibraryDetails;
import com.google.wireless.android.sdk.stats.SdkIndexLoadingDetails;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0015J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016J*\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J*\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J*\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J*\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J*\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0014J,\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010\u001bH\u0016J\u0006\u0010*\u001a\u00020\u0012J0\u0010+\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J:\u00100\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u00101\u001a\u0002022\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u00103\u001a\u000204H\u0002J \u00105\u001a\u00020\u00122\u0006\u00103\u001a\u0002042\u0006\u0010$\u001a\u00020%2\u0006\u00106\u001a\u00020\"H\u0002J\u001a\u00107\u001a\u0002082\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u00103\u001a\u000204H\u0002J\f\u00109\u001a\u00020:*\u00020\"H\u0002J\f\u00109\u001a\u00020;*\u00020<H\u0002R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006="}, d2={"Lcom/android/tools/idea/projectsystem/gradle/IdeGooglePlaySdkIndex;", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "readUrlData", "Lcom/android/ide/common/repository/NetworkCache$ReadUrlDataResult;", "url", "", "timeout", "", "lastModified", "", "error", "", "throwable", "", "message", "logNonCompliant", "groupId", "artifactId", "versionString", "file", "Ljava/io/File;", "logHasCriticalIssues", "logOutdated", "logVulnerability", "logDeprecated", "logIndexLoadedCorrectly", "dataSourceType", "Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "logCachingError", "readResult", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataResult;", "logErrorInDefaultData", "generateSdkLinkLintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "buildFile", "initializeAndSetFlags", "logUpdateLibraryVersionFixApplied", "oldVersionString", "newVersionString", "findProject", "Lcom/intellij/openapi/project/Project;", "logTrackerEventForLibraryVersion", "isBlocking", "", "kind", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$EventKind;", "logTrackerEventForIndexLoadingError", "dataSource", "createTrackerEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "toTrackerType", "Lcom/google/wireless/android/sdk/stats/SdkIndexLoadingDetails$SourceType;", "Lcom/google/wireless/android/sdk/stats/SdkIndexLoadingDetails$ReadErrorType;", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nIdeGooglePlaySdkIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeGooglePlaySdkIndex.kt\ncom/android/tools/idea/projectsystem/gradle/IdeGooglePlaySdkIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,267:1\n1869#2,2:268\n*S KotlinDebug\n*F\n+ 1 IdeGooglePlaySdkIndex.kt\ncom/android/tools/idea/projectsystem/gradle/IdeGooglePlaySdkIndex\n*L\n98#1:268,2\n*E\n"})
public final class IdeGooglePlaySdkIndex
extends GooglePlaySdkIndex {
    @NotNull
    public static final IdeGooglePlaySdkIndex INSTANCE = new IdeGooglePlaySdkIndex();
    @NotNull
    private static final Logger logger;

    private IdeGooglePlaySdkIndex() {
        super(IdeGooglePlaySdkIndexKt.getCacheDir());
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @Slow
    @NotNull
    protected NetworkCache.ReadUrlDataResult readUrlData(@NotNull String url, int timeout, long lastModified) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return IdeNetworkCacheUtils.Companion.readHttpUrlData$default(IdeNetworkCacheUtils.Companion, url, timeout, lastModified, null, 8, null);
    }

    public void error(@NotNull Throwable throwable, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        logger.error(message, throwable);
    }

    protected void logNonCompliant(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        super.logNonCompliant(groupId, artifactId, versionString, file);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        if (isBlocking) {
            logger.warn(this.generateBlockingPolicyMessage(groupId, artifactId, versionString));
        } else {
            logger.warn(this.generatePolicyMessage(groupId, artifactId, versionString));
        }
        this.logTrackerEventForLibraryVersion(groupId, artifactId, versionString, isBlocking, file, AndroidStudioEvent.EventKind.SDK_INDEX_LIBRARY_IS_NON_COMPLIANT);
    }

    protected void logHasCriticalIssues(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        super.logHasCriticalIssues(groupId, artifactId, versionString, file);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        String warnMsg = isBlocking ? this.generateBlockingCriticalMessage(groupId, artifactId, versionString) : this.generateCriticalMessage(groupId, artifactId, versionString);
        logger.warn(warnMsg);
        this.logTrackerEventForLibraryVersion(groupId, artifactId, versionString, isBlocking, file, AndroidStudioEvent.EventKind.SDK_INDEX_LIBRARY_HAS_CRITICAL_ISSUES);
    }

    protected void logOutdated(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        super.logOutdated(groupId, artifactId, versionString, file);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        String warnMsg = isBlocking ? this.generateBlockingOutdatedMessage(groupId, artifactId, versionString) : this.generateOutdatedMessage(groupId, artifactId, versionString);
        logger.warn(warnMsg);
        this.logTrackerEventForLibraryVersion(groupId, artifactId, versionString, isBlocking, file, AndroidStudioEvent.EventKind.SDK_INDEX_LIBRARY_IS_OUTDATED);
    }

    protected void logVulnerability(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        super.logVulnerability(groupId, artifactId, versionString, file);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        Iterable $this$forEach$iv = this.generateVulnerabilityMessages(groupId, artifactId, versionString);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GooglePlaySdkIndex.Companion.VulnerabilityDescription it = (GooglePlaySdkIndex.Companion.VulnerabilityDescription)element$iv;
            boolean bl = false;
            logger.warn(it.getDescription());
        }
        this.logTrackerEventForLibraryVersion(groupId, artifactId, versionString, isBlocking, file, AndroidStudioEvent.EventKind.SDK_INDEX_LIBRARY_HAS_VULNERABILITY_ISSUES);
    }

    protected void logDeprecated(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        super.logDeprecated(groupId, artifactId, versionString, file);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        String warnMsg = this.generateDeprecatedMessage(groupId, artifactId);
        logger.warn(warnMsg);
        this.logTrackerEventForLibraryVersion(groupId, artifactId, versionString, isBlocking, file, AndroidStudioEvent.EventKind.SDK_INDEX_LIBRARY_IS_DEPRECATED);
    }

    protected void logIndexLoadedCorrectly(@NotNull NetworkCache.DataSourceType dataSourceType) {
        Intrinsics.checkNotNullParameter((Object)dataSourceType, (String)"dataSourceType");
        super.logIndexLoadedCorrectly(dataSourceType);
        logger.info("SDK Index data loaded correctly from " + dataSourceType);
        AndroidStudioEvent.Builder event = this.createTrackerEvent(null, AndroidStudioEvent.EventKind.SDK_INDEX_LOADED_CORRECTLY);
        event.setSdkIndexLoadingDetails(SdkIndexLoadingDetails.newBuilder().setSourceType(this.toTrackerType(dataSourceType)));
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    protected void logCachingError(@NotNull GooglePlaySdkIndex.ReadDataResult readResult, @NotNull NetworkCache.DataSourceType dataSourceType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
        Intrinsics.checkNotNullParameter((Object)dataSourceType, (String)"dataSourceType");
        super.logCachingError(readResult, dataSourceType);
        Exception exception = readResult.getException();
        CharSequence charSequence = exception != null ? exception.getMessage() : null;
        if (charSequence == null || charSequence.length() == 0) {
            object = "";
        } else {
            Exception exception2 = readResult.getException();
            object = ": " + (exception2 != null ? exception2.getMessage() : null);
        }
        String warnMsg = object;
        logger.warn("Could not use data from cache" + warnMsg + " (error: " + readResult.getReadDataErrorType() + ", source: " + dataSourceType + ")");
        this.logTrackerEventForIndexLoadingError(AndroidStudioEvent.EventKind.SDK_INDEX_CACHING_ERROR, readResult, dataSourceType);
    }

    protected void logErrorInDefaultData(@NotNull GooglePlaySdkIndex.ReadDataResult readResult) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
        super.logErrorInDefaultData(readResult);
        Exception exception = readResult.getException();
        CharSequence charSequence = exception != null ? exception.getMessage() : null;
        if (charSequence == null || charSequence.length() == 0) {
            object = "";
        } else {
            Exception exception2 = readResult.getException();
            object = ": " + (exception2 != null ? exception2.getMessage() : null);
        }
        String warnMsg = object;
        logger.warn("Could not use default SDK Index" + warnMsg + " (" + readResult.getReadDataErrorType() + ")");
        this.logTrackerEventForIndexLoadingError(AndroidStudioEvent.EventKind.SDK_INDEX_DEFAULT_DATA_ERROR, readResult, NetworkCache.DataSourceType.DEFAULT_DATA);
    }

    @Nullable
    public LintFix generateSdkLinkLintFix(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String url = this.getSdkUrl(groupId, artifactId);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        return url != null ? (LintFix)new LintFix.ShowUrl("View details in Google Play SDK Index", null, url, () -> IdeGooglePlaySdkIndex.generateSdkLinkLintFix$lambda$1(groupId, artifactId, versionString, isBlocking, buildFile)) : null;
    }

    public final void initializeAndSetFlags() {
        this.initialize();
        Object t = StudioFlags.SHOW_SDK_INDEX_NOTES_FROM_DEVELOPER.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        this.setShowNotesFromDeveloper((Boolean)t);
        Object t2 = StudioFlags.SHOW_SDK_INDEX_RECOMMENDED_VERSIONS.get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
        this.setShowRecommendedVersions((Boolean)t2);
        Object t3 = StudioFlags.SHOW_SDK_INDEX_DEPRECATION_ISSUES.get();
        Intrinsics.checkNotNullExpressionValue(t3, (String)"get(...)");
        this.setShowDeprecationIssues((Boolean)t3);
    }

    public final void logUpdateLibraryVersionFixApplied(@NotNull String groupId, @NotNull String artifactId, @NotNull String oldVersionString, @NotNull String newVersionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)oldVersionString, (String)"oldVersionString");
        Intrinsics.checkNotNullParameter((Object)newVersionString, (String)"newVersionString");
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, oldVersionString);
        AndroidStudioEvent.Builder event = this.createTrackerEvent(file, AndroidStudioEvent.EventKind.SDK_INDEX_LIBRARY_UPDATED);
        event.setSdkIndexLibraryDetails(SdkIndexLibraryDetails.newBuilder().setGroupId(groupId).setArtifactId(artifactId).setVersionString(oldVersionString).setUpdatedVersionString(newVersionString).setIsBlocking(isBlocking));
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    private final Project findProject(File file) {
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(file.toPath());
        return virtualFile == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
    }

    private final void logTrackerEventForLibraryVersion(String groupId, String artifactId, String versionString, boolean isBlocking, File file, AndroidStudioEvent.EventKind kind) {
        AndroidStudioEvent.Builder event = this.createTrackerEvent(file, kind);
        event.setSdkIndexLibraryDetails(SdkIndexLibraryDetails.newBuilder().setGroupId(groupId).setArtifactId(artifactId).setVersionString(versionString).setIsBlocking(isBlocking));
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    private final void logTrackerEventForIndexLoadingError(AndroidStudioEvent.EventKind kind, GooglePlaySdkIndex.ReadDataResult readResult, NetworkCache.DataSourceType dataSource) {
        AndroidStudioEvent.Builder event = this.createTrackerEvent(null, kind);
        event.setSdkIndexLoadingDetails(SdkIndexLoadingDetails.newBuilder().setReadErrorType(this.toTrackerType(readResult.getReadDataErrorType())).setSourceType(this.toTrackerType(dataSource)));
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    private final AndroidStudioEvent.Builder createTrackerEvent(File file, AndroidStudioEvent.EventKind kind) {
        Project project;
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GOOGLE_PLAY_SDK_INDEX).setKind(kind);
        Project project2 = project = file != null ? this.findProject(file) : null;
        if (project != null) {
            Intrinsics.checkNotNull((Object)event);
            UsageTrackerUtils.withProjectId(event, project);
        }
        Intrinsics.checkNotNull((Object)event);
        return event;
    }

    private final SdkIndexLoadingDetails.SourceType toTrackerType(NetworkCache.DataSourceType $this$toTrackerType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toTrackerType.ordinal()]) {
            case 1 -> SdkIndexLoadingDetails.SourceType.UNKNOWN_SOURCE;
            case 2 -> SdkIndexLoadingDetails.SourceType.TEST_DATA;
            case 3 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_EXPIRED_NO_NETWORK;
            case 4 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_EXPIRED_NETWORK_ERROR;
            case 5 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_EXPIRED_UNKNOWN;
            case 6 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_RECENT;
            case 7 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_NEW;
            case 8 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_NOT_MODIFIED;
            case 9 -> SdkIndexLoadingDetails.SourceType.DEFAULT_DATA;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final SdkIndexLoadingDetails.ReadErrorType toTrackerType(GooglePlaySdkIndex.ReadDataErrorType $this$toTrackerType) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toTrackerType.ordinal()]) {
            case 1 -> SdkIndexLoadingDetails.ReadErrorType.NO_ERROR;
            case 2 -> SdkIndexLoadingDetails.ReadErrorType.DATA_FUNCTION_EXCEPTION;
            case 3 -> SdkIndexLoadingDetails.ReadErrorType.DATA_FUNCTION_NULL_ERROR;
            case 4 -> SdkIndexLoadingDetails.ReadErrorType.GZIP_EXCEPTION;
            case 5 -> SdkIndexLoadingDetails.ReadErrorType.INDEX_PARSE_EXCEPTION;
            case 6 -> SdkIndexLoadingDetails.ReadErrorType.INDEX_PARSE_NULL_ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit generateSdkLinkLintFix$lambda$1(String $groupId, String $artifactId, String $versionString, boolean $isBlocking, File $buildFile) {
        INSTANCE.logTrackerEventForLibraryVersion($groupId, $artifactId, $versionString, $isBlocking, $buildFile, AndroidStudioEvent.EventKind.SDK_INDEX_LINK_FOLLOWED);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(((Object)((Object)INSTANCE)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        IdeGooglePlaySdkIndex.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[NetworkCache.DataSourceType.values().length];
            try {
                nArray[NetworkCache.DataSourceType.UNKNOWN_SOURCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.TEST_DATA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_EXPIRED_NO_NETWORK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_EXPIRED_NETWORK_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_EXPIRED_UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_RECENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_NEW.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_NOT_MODIIFED_SINCE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.DEFAULT_DATA.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GooglePlaySdkIndex.ReadDataErrorType.values().length];
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.NO_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.DATA_FUNCTION_EXCEPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.DATA_FUNCTION_NULL_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.GZIP_EXCEPTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.INDEX_PARSE_EXCEPTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.INDEX_PARSE_NULL_ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

