/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.RenderResources;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0007\u0018\u0000 $2\u00020\u0001:\u0002#$BC\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\b\u00a2\u0006\u0004\b\r\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000fJ$\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\u000bH\u0007J\u0010\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\tJ\"\u0010!\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\u000bH\u0003J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00068B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/rendering/GutterIconCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "highDpiSupplier", "Lkotlin/Function0;", "", "renderIcon", "Lkotlin/Function3;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/android/ide/common/rendering/api/RenderResources;", "Lorg/jetbrains/android/facet/AndroidFacet;", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function3;)V", "(Lcom/intellij/openapi/project/Project;)V", "thumbnailCache", "", "", "Lcom/android/tools/idea/rendering/GutterIconCache$TimestampedIcon;", "<set-?>", "highDpiDisplay", "getHighDpiDisplay", "()Z", "setHighDpiDisplay", "(Z)V", "highDpiDisplay$delegate", "Lkotlin/properties/ReadWriteProperty;", "getIcon", "file", "resolver", "facet", "getIconIfCached", "renderAndCacheIcon", "getTimestampedIconFromCache", "TimestampedIcon", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nGutterIconCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GutterIconCache.kt\ncom/android/tools/idea/rendering/GutterIconCache\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n33#2,3:92\n1#3:95\n*S KotlinDebug\n*F\n+ 1 GutterIconCache.kt\ncom/android/tools/idea/rendering/GutterIconCache\n*L\n49#1:92,3\n*E\n"})
public final class GutterIconCache {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<Boolean> highDpiSupplier;
    @NotNull
    private final Function3<VirtualFile, RenderResources, AndroidFacet, Icon> renderIcon;
    @NotNull
    private final Map<String, TimestampedIcon> thumbnailCache;
    @NotNull
    private final ReadWriteProperty highDpiDisplay$delegate;

    @TestOnly
    public GutterIconCache(@NotNull Project project, @NotNull Function0<Boolean> highDpiSupplier, @NotNull Function3<? super VirtualFile, ? super RenderResources, ? super AndroidFacet, ? extends Icon> renderIcon) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(highDpiSupplier, (String)"highDpiSupplier");
        Intrinsics.checkNotNullParameter(renderIcon, (String)"renderIcon");
        this.project = project;
        this.highDpiSupplier = highDpiSupplier;
        this.renderIcon = renderIcon;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"newConcurrentMap(...)");
        this.thumbnailCache = concurrentMap;
        Delegates delegates = Delegates.INSTANCE;
        Boolean initialValue$iv = false;
        boolean $i$f$observable = false;
        this.highDpiDisplay$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ GutterIconCache this$0;
            {
                this.this$0 = gutterIconCache;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property2, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean oldValue2 = (Boolean)oldValue;
                boolean bl2 = false;
                if (oldValue2 != newValue2) {
                    GutterIconCache.access$getThumbnailCache$p(this.this$0).clear();
                }
            }
        };
    }

    private final boolean getHighDpiDisplay() {
        return (Boolean)this.highDpiDisplay$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setHighDpiDisplay(boolean bl) {
        this.highDpiDisplay$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    public GutterIconCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, (Function0<Boolean>)((Function0)1.INSTANCE), (Function3<? super VirtualFile, ? super RenderResources, ? super AndroidFacet, ? extends Icon>)((Function3)2.INSTANCE));
    }

    @Slow
    @Nullable
    public final Icon getIcon(@NotNull VirtualFile file, @Nullable RenderResources resolver, @NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        TimestampedIcon timestampedIcon = this.getTimestampedIconFromCache(file);
        if (timestampedIcon == null) {
            timestampedIcon = this.renderAndCacheIcon(file, resolver, facet);
        }
        return timestampedIcon.getIcon();
    }

    @Nullable
    public final Icon getIconIfCached(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TimestampedIcon timestampedIcon = this.getTimestampedIconFromCache(file);
        return timestampedIcon != null ? timestampedIcon.getIcon() : null;
    }

    @Slow
    private final TimestampedIcon renderAndCacheIcon(VirtualFile file, RenderResources resolver, AndroidFacet facet) {
        TimestampedIcon timestampedIcon;
        TimestampedIcon it = timestampedIcon = new TimestampedIcon((Icon)this.renderIcon.invoke((Object)file, (Object)resolver, (Object)facet), file.getModificationStamp());
        boolean bl = false;
        this.thumbnailCache.put(file.getPath(), it);
        return timestampedIcon;
    }

    private final TimestampedIcon getTimestampedIconFromCache(VirtualFile file) {
        TimestampedIcon timestampedIcon;
        this.setHighDpiDisplay((Boolean)this.highDpiSupplier.invoke());
        TimestampedIcon timestampedIcon2 = this.thumbnailCache.get(file.getPath());
        if (timestampedIcon2 != null) {
            TimestampedIcon timestampedIcon3;
            TimestampedIcon it = timestampedIcon3 = timestampedIcon2;
            boolean bl = false;
            timestampedIcon = it.isAsNewAs(file) ? timestampedIcon3 : null;
        } else {
            timestampedIcon = null;
        }
        return timestampedIcon;
    }

    @JvmStatic
    @NotNull
    public static final GutterIconCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Map access$getThumbnailCache$p(GutterIconCache $this) {
        return $this.thumbnailCache;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GutterIconCache.class, "highDpiDisplay", "getHighDpiDisplay()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/rendering/GutterIconCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/rendering/GutterIconCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nGutterIconCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GutterIconCache.kt\ncom/android/tools/idea/rendering/GutterIconCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,91:1\n30#2,2:92\n*S KotlinDebug\n*F\n+ 1 GutterIconCache.kt\ncom/android/tools/idea/rendering/GutterIconCache$Companion\n*L\n88#1:92,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GutterIconCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GutterIconCache> serviceClass$iv = GutterIconCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GutterIconCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/rendering/GutterIconCache$TimestampedIcon;", "", "icon", "Ljavax/swing/Icon;", "timestamp", "", "<init>", "(Ljavax/swing/Icon;J)V", "getIcon", "()Ljavax/swing/Icon;", "getTimestamp", "()J", "isAsNewAs", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    public static final class TimestampedIcon {
        @Nullable
        private final Icon icon;
        private final long timestamp;

        public TimestampedIcon(@Nullable Icon icon, long timestamp) {
            this.icon = icon;
            this.timestamp = timestamp;
        }

        @Nullable
        public final Icon getIcon() {
            return this.icon;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final boolean isAsNewAs(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.timestamp == file.getModificationStamp() && !FileDocumentManager.getInstance().isFileModified(file);
        }

        @Nullable
        public final Icon component1() {
            return this.icon;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final TimestampedIcon copy(@Nullable Icon icon, long timestamp) {
            return new TimestampedIcon(icon, timestamp);
        }

        public static /* synthetic */ TimestampedIcon copy$default(TimestampedIcon timestampedIcon, Icon icon, long l, int n, Object object) {
            if ((n & 1) != 0) {
                icon = timestampedIcon.icon;
            }
            if ((n & 2) != 0) {
                l = timestampedIcon.timestamp;
            }
            return timestampedIcon.copy(icon, l);
        }

        @NotNull
        public String toString() {
            return "TimestampedIcon(icon=" + this.icon + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result2 = this.icon == null ? 0 : this.icon.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimestampedIcon)) {
                return false;
            }
            TimestampedIcon timestampedIcon = (TimestampedIcon)other;
            if (!Intrinsics.areEqual((Object)this.icon, (Object)timestampedIcon.icon)) {
                return false;
            }
            return this.timestamp == timestampedIcon.timestamp;
        }
    }
}

