/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.configurations.StudioConfigurationModelModule;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.StudioResourceIdManager;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.ids.ResourceIdManager;
import com.android.tools.sdk.AndroidTargetData;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.uipreview.StudioModuleClassLoaderManager;
import org.jetbrains.annotations.NotNull;

public class RenderUtils {
    public static void clearCache(@NotNull Collection<Configuration> configurations) {
        configurations.forEach(configuration2 -> {
            ResourceClassRegistry resourceClassRegistry;
            IAndroidTarget target2 = configuration2.getTarget();
            Module module = ((StudioConfigurationModelModule)configuration2.getConfigModule()).getModule();
            StudioModuleClassLoaderManager.get().clearCache(module);
            ResourceIdManager studioResourceIdManager = StudioResourceIdManager.getInstanceIfCreated(module);
            if (studioResourceIdManager != null) {
                studioResourceIdManager.resetDynamicIds();
            }
            if ((resourceClassRegistry = ResourceClassRegistry.getInstanceIfCreated(module.getProject())) != null) {
                resourceClassRegistry.clearCache();
            }
            if (target2 != null) {
                AndroidTargetData targetData = AndroidTargetData.getTargetData(target2, AndroidPlatforms.getInstance(module));
                if (targetData != null) {
                    targetData.clearAllCaches(configuration2.getConfigModule().getModuleKey());
                }
                AndroidFacet facet = AndroidFacet.getInstance((Module)module);
                Stream.concat(AndroidDependenciesCache.getAllAndroidDependencies(module, true).stream(), Stream.of(facet)).filter(Objects::nonNull).forEach(f -> StudioResourceRepositoryManager.getInstance(f).resetAllCaches());
            }
        });
    }
}

