/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.environment.Logger;
import com.android.tools.rendering.HtmlLinkManager;
import com.android.tools.rendering.RenderProblem;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowExceptionFix
implements HtmlLinkManager.Action {
    @NotNull
    private final WeakReference<RenderProblem> myRenderProblemWeakReference;
    @Nullable
    private final Throwable myThrowable;

    public ShowExceptionFix(@NotNull Throwable throwable) {
        this.myThrowable = throwable;
        this.myRenderProblemWeakReference = new WeakReference<Object>(null);
    }

    public ShowExceptionFix(@NotNull RenderProblem problem) {
        this.myThrowable = null;
        this.myRenderProblemWeakReference = new WeakReference<RenderProblem>(problem);
    }

    @Override
    public void actionPerformed(@Nullable Module module) {
        throw new UnsupportedOperationException("This is a noop. Use showException method instead.");
    }

    public void showException(@Nullable Module module, PsiFile file, HtmlLinkManager linkManager) {
        if (module == null) {
            Logger.getInstance(ShowExceptionFix.class).warn("Module has been disposed");
            return;
        }
        Throwable t = this.myThrowable;
        if (t == null) {
            RenderProblem problem = (RenderProblem)this.myRenderProblemWeakReference.get();
            Throwable throwable = t = problem != null ? problem.getThrowable() : null;
        }
        if (t == null) {
            return;
        }
        while (t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
        }
        AndroidUtils.showStackStace(module, new Throwable[]{t}, file, linkManager);
    }
}

