/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.rendering.webp.WebpConversionDialog;
import com.android.tools.idea.rendering.webp.WebpConversionSettings;
import com.android.tools.idea.rendering.webp.WebpConvertedFile;
import com.android.tools.idea.rendering.webp.WebpPreviewDialog;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.module.AndroidModuleInfo;
import com.android.utils.SdkUtils;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.EdtReplacementThread;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToWebpAction
extends DumbAwareAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public static final String TASK_NAME = "Converting images to WebP";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module == null) {
            module = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        }
        int minSdkVersion2 = Integer.MAX_VALUE;
        if (module != null) {
            AndroidModuleInfo info = StudioAndroidModuleInfo.getInstance(module);
            if (info != null) {
                minSdkVersion2 = info.getMinSdkVersion().getFeatureLevel();
            }
        } else {
            Module[] modules = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
            if (modules != null) {
                for (Module m : modules) {
                    AndroidModuleInfo info = StudioAndroidModuleInfo.getInstance(m);
                    if (info == null) continue;
                    minSdkVersion2 = Math.min(minSdkVersion2, info.getMinSdkVersion().getFeatureLevel());
                }
            }
        }
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 == null) {
            return;
        }
        this.perform(project, minSdkVersion2, files2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void perform(@NotNull Project project, int minSdkVersion2, VirtualFile[] files2) {
        WebpConversionSettings settings = new WebpConversionSettings();
        settings.skipTransparentImages = minSdkVersion2 < 18;
        settings.allowLossless = minSdkVersion2 >= 18;
        boolean singleFile = files2.length == 1 && ConvertToWebpAction.isEligibleForConversion(files2[0], null);
        WebpConversionDialog dialog2 = new WebpConversionDialog(project, minSdkVersion2, settings, singleFile);
        if (!dialog2.showAndGet()) {
            return;
        }
        dialog2.toSettings(settings);
        this.convert(project, settings, true, Arrays.asList(files2));
    }

    private static boolean isResourceDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file.isDirectory()) {
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)file.getName());
            if (folderType != null) {
                return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
            }
            return IdeResourcesUtil.isLocalResourceDirectory(file, project);
        }
        return false;
    }

    private static boolean isAssetDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet != null) {
            NamedIdeaSourceProvider mainIdeaSourceProvider = SourceProviderManager.getInstance(facet).getMainIdeaSourceProvider();
            if (mainIdeaSourceProvider == null) {
                return false;
            }
            for (VirtualFile dir : mainIdeaSourceProvider.getAssetsDirectories()) {
                if (!file.equals(dir)) continue;
                return true;
            }
        }
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null && e.getProject() != null) {
            for (VirtualFile file : files2) {
                boolean directory = file.isDirectory();
                if ((!directory || !ConvertToWebpAction.isResourceDirectory(file, e.getProject()) && !ConvertToWebpAction.isAssetDirectory(file, e.getProject())) && (directory || !ConvertToWebpAction.isEligibleForConversion(file, null))) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void convert(@NotNull Project project, @NotNull WebpConversionSettings settings, boolean showBalloon, @NotNull Collection<VirtualFile> files2) {
        WebpConversionTask task2 = new WebpConversionTask(project, settings, showBalloon, files2);
        ProgressManager.getInstance().run((Task)task2);
    }

    public static boolean isEligibleForConversion(@Nullable VirtualFile file, @Nullable WebpConversionSettings settings) {
        if (file != null && !file.isDirectory()) {
            String name2 = file.getName();
            if (name2.endsWith(".png")) {
                if (settings != null && settings.skipNinePatches && SdkUtils.endsWithIgnoreCase((String)name2, (String)".9.png")) {
                    return false;
                }
                if (settings != null && settings.skipTransparentImages) {
                    try {
                        BufferedImage image = ImageIO.read(file.getInputStream());
                        if (image != null && ImageUtils.isNonOpaque((BufferedImage)image)) {
                            return false;
                        }
                    }
                    catch (IOException image) {
                        // empty catch block
                    }
                }
                return true;
            }
            if (SdkUtils.endsWithIgnoreCase((String)name2, (String)".jpg") || SdkUtils.endsWith((CharSequence)name2, (CharSequence)".jpeg")) {
                return true;
            }
            if (SdkUtils.endsWithIgnoreCase((String)name2, (String)".bmp")) {
                return true;
            }
            if (SdkUtils.endsWithIgnoreCase((String)name2, (String)".gif")) {
                ImageReader is = ImageIO.getImageReadersBySuffix("GIF").next();
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(file.getInputStream());
                    is.setInput(iis);
                    return is.getNumImages(true) == 1;
                }
                catch (IOException ignore) {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean isNinePatchFile(@NotNull VirtualFile file) {
        return file.getName().endsWith(".9.png") && !file.isDirectory();
    }

    static String formatSize(long bytes2) {
        int unit = 1024;
        if (bytes2 < (long)unit) {
            return bytes2 + " bytes";
        }
        int exp = (int)(Math.log(bytes2) / Math.log(unit));
        String pre = Character.toString("KMGTPE".charAt(exp - 1));
        return String.format(Locale.US, "%.1f %sB", (double)bytes2 / Math.pow(unit, exp), pre);
    }

    private static void refreshFolders(List<VirtualFile> toRefresh) {
        for (VirtualFile dir : toRefresh) {
            dir.refresh(true, true);
        }
    }

    @NotNull
    private static List<VirtualFile> computeParentFolders(@NotNull List<WebpConvertedFile> files2) {
        ArrayList<VirtualFile> toRefresh = new ArrayList<VirtualFile>();
        for (WebpConvertedFile file : files2) {
            VirtualFile parent = file.sourceFile.getParent();
            if (parent == null || toRefresh.contains(parent)) continue;
            toRefresh.add(parent);
        }
        return toRefresh;
    }

    static class WebpConversionTask
    extends Task.Backgroundable {
        private final Project myProject;
        private final boolean myShowBalloon;
        private final Collection<VirtualFile> myFiles;
        private final WebpConversionSettings mySettings;
        private int myNinePatchCount;
        private int myTransparentCount;
        private int myFileCount;
        private long mySaved;
        private int mySkipped;
        private List<VirtualFile> myParentFolders;
        private List<WebpConvertedFile> myConvertedFiles;

        public WebpConversionTask(Project project, WebpConversionSettings settings, boolean showBalloon, Collection<VirtualFile> files2) {
            super(project, ConvertToWebpAction.TASK_NAME, true);
            this.mySettings = settings;
            this.myProject = project;
            this.myShowBalloon = showBalloon;
            this.myFiles = files2;
        }

        public void onFinished() {
            boolean skipAlreadyEncoded;
            if (this.mySettings.previewConversion && !this.mySettings.lossless && !this.myConvertedFiles.isEmpty()) {
                WebpPreviewDialog dialog2 = new WebpPreviewDialog(this.myProject, this.mySettings, this.myConvertedFiles);
                if (!dialog2.showAndGet()) {
                    return;
                }
                skipAlreadyEncoded = true;
            } else {
                skipAlreadyEncoded = false;
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Converting files"){

                public void run(@NotNull ProgressIndicator indicator) {
                    this.encode(myConvertedFiles, skipAlreadyEncoded, indicator);
                }

                public void onSuccess() {
                    this.writeImages((Object)this, this.myProject, myConvertedFiles);
                    ConvertToWebpAction.refreshFolders(myParentFolders);
                    if (myShowBalloon) {
                        StringBuilder sb = new StringBuilder();
                        if (myFiles.size() > 1 || myFileCount == 0) {
                            if (myFileCount == 1) {
                                sb.append("1 file was converted");
                            } else {
                                sb.append(myFileCount).append(" files were converted");
                            }
                        }
                        if (mySaved > 0L || myTransparentCount == 0 && myNinePatchCount == 0 && mySkipped == 0) {
                            if (mySaved > 0L) {
                                sb.append("<br/>").append(ConvertToWebpAction.formatSize(mySaved)).append(" saved");
                            } else {
                                sb.append("<br/>").append("size increased by ").append(ConvertToWebpAction.formatSize(-mySaved));
                            }
                        }
                        if (myNinePatchCount > 0) {
                            if (myNinePatchCount == 1) {
                                sb.append("<br>").append("1 9-patch file was skipped");
                            } else {
                                sb.append("<br>").append(myNinePatchCount).append(" 9-patch files were skipped");
                            }
                        }
                        if (myTransparentCount > 0) {
                            if (myTransparentCount == 1) {
                                sb.append("<br>").append("1 transparent image was skipped");
                            } else {
                                sb.append("<br>").append(myTransparentCount).append(" transparent images were skipped");
                            }
                        }
                        if (mySkipped > 0) {
                            if (mySkipped == 1) {
                                sb.append("<br>").append("1 file was skipped because there was no net space saving");
                            } else {
                                sb.append("<br>").append(mySkipped).append(" files were skipped because there was no net space saving");
                            }
                        }
                        String message = sb.toString();
                        NotificationGroup group2 = NotificationGroup.findRegisteredGroup((String)"Convert to WebP");
                        assert (group2 != null);
                        group2.createNotification(message, NotificationType.INFORMATION).notify(this.myProject);
                    }
                }

                @NotNull
                public EdtReplacementThread whereToRunCallbacks() {
                    return EdtReplacementThread.WT;
                }
            });
        }

        private void writeImages(Object requestor, Project project, List<WebpConvertedFile> files2) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (WebpConvertedFile convertedFile : files2) {
                    try {
                        if (convertedFile.encoded == null) {
                            ++this.myTransparentCount;
                            continue;
                        }
                        if (this.mySettings.skipLargerImages && convertedFile.saved < 0L) {
                            ++this.mySkipped;
                            continue;
                        }
                        this.mySaved += convertedFile.saved;
                        ++this.myFileCount;
                        convertedFile.apply(requestor);
                    }
                    catch (IOException e) {
                        Logger.getInstance(ConvertToWebpAction.class).warn((Throwable)e);
                    }
                }
            });
        }

        public void run(@NotNull ProgressIndicator progressIndicator) {
            LinkedList<VirtualFile> images = new LinkedList<VirtualFile>(this.myFiles);
            this.myConvertedFiles = this.findImages(progressIndicator, images);
            this.myParentFolders = ConvertToWebpAction.computeParentFolders(this.myConvertedFiles);
        }

        void encode(@NotNull List<WebpConvertedFile> files2, boolean skipAlreadyEncoded, @NotNull ProgressIndicator indicator) {
            double fraction = 0.0;
            double fileFraction = 1.0 / (double)files2.size();
            for (WebpConvertedFile file : files2) {
                ProgressManager.checkCanceled();
                indicator.setText2("Converting " + file.sourceFile.getName());
                indicator.setFraction(fraction);
                fraction += fileFraction;
                if ((!skipAlreadyEncoded || file.encoded == null) && (this.mySettings.skipNinePatches && ConvertToWebpAction.isNinePatchFile(file.sourceFile) ? !$assertionsDisabled : !file.convert(this.mySettings) && !$assertionsDisabled)) {
                    throw new AssertionError(file);
                }
            }
        }

        @NotNull
        private List<WebpConvertedFile> findImages(@NotNull ProgressIndicator progressIndicator, @NotNull LinkedList<VirtualFile> images) {
            ArrayList<WebpConvertedFile> files2 = new ArrayList<WebpConvertedFile>();
            while (!images.isEmpty()) {
                progressIndicator.checkCanceled();
                VirtualFile file = images.pop();
                progressIndicator.setText(file.getPresentableUrl());
                if (file.isDirectory()) {
                    for (VirtualFile f : file.getChildren()) {
                        images.push(f);
                    }
                    continue;
                }
                if (!ConvertToWebpAction.isEligibleForConversion(file, null)) continue;
                if (ConvertToWebpAction.isEligibleForConversion(file, this.mySettings)) {
                    WebpConvertedFile convertedFile = WebpConvertedFile.create(file, this.mySettings);
                    if (convertedFile == null) continue;
                    files2.add(convertedFile);
                    continue;
                }
                if (this.mySettings.skipNinePatches && ConvertToWebpAction.isNinePatchFile(file)) {
                    ++this.myNinePatchCount;
                    continue;
                }
                ++this.myTransparentCount;
            }
            return files2;
        }
    }
}

