/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.projectmodel.ResourceFolder;
import com.android.resources.aar.AarProtoResourceRepository;
import com.android.resources.aar.AarResourceRepository;
import com.android.resources.aar.AarSourceResourceRepository;
import com.android.resources.aar.CachingData;
import com.android.tools.concurrency.AndroidIoManager;
import com.android.tools.res.CodeVersionAdapter;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\u0011J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002RN\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\t\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000b0\u000b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/res/AarResourceRepositoryCache;", "", "<init>", "()V", "myProtoRepositories", "Lcom/google/common/cache/Cache;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Lcom/android/resources/aar/AarProtoResourceRepository;", "mySourceRepositories", "Lcom/android/projectmodel/ResourceFolder;", "Lcom/android/resources/aar/AarSourceResourceRepository;", "getSourceRepository", "library", "Lcom/android/projectmodel/ExternalAndroidLibrary;", "getProtoRepository", "removeProtoRepository", "", "resApkFile", "removeSourceRepository", "resourceFolder", "clear", "createCachingData", "Lcom/android/resources/aar/CachingData;", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAarResourceRepositoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AarResourceRepositoryCache.kt\ncom/android/tools/idea/res/AarResourceRepositoryCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,166:1\n24#2:167\n*S KotlinDebug\n*F\n+ 1 AarResourceRepositoryCache.kt\ncom/android/tools/idea/res/AarResourceRepositoryCache\n*L\n130#1:167\n*E\n"})
public class AarResourceRepositoryCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Cache<Path, AarProtoResourceRepository> myProtoRepositories = CacheBuilder.newBuilder().softValues().build();
    private final Cache<ResourceFolder, AarSourceResourceRepository> mySourceRepositories = CacheBuilder.newBuilder().softValues().build();

    protected AarResourceRepositoryCache() {
    }

    @NotNull
    public final AarSourceResourceRepository getSourceRepository(@NotNull ExternalAndroidLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        ResourceFolder resourceFolder = library.getResFolder();
        if (resourceFolder == null) {
            throw new IllegalArgumentException("No resources for " + library.libraryName());
        }
        ResourceFolder resFolder = resourceFolder;
        if (resFolder.getRoot().toPath() == null) {
            throw new IllegalArgumentException("Cannot find resource directory " + resFolder.getRoot() + " for " + library.libraryName());
        }
        Cache<ResourceFolder, AarSourceResourceRepository> cache = this.mySourceRepositories;
        Intrinsics.checkNotNullExpressionValue(cache, (String)"mySourceRepositories");
        AarResourceRepository aarResourceRepository = AarResourceRepositoryCache.Companion.getRepository(resFolder, cache, () -> AarResourceRepositoryCache.getSourceRepository$lambda$0(resFolder, library, this));
        Intrinsics.checkNotNullExpressionValue((Object)aarResourceRepository, (String)"access$getRepository(...)");
        return (AarSourceResourceRepository)aarResourceRepository;
    }

    @NotNull
    public final AarProtoResourceRepository getProtoRepository(@NotNull ExternalAndroidLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        PathString pathString = library.getResApkFile();
        if (pathString == null) {
            throw new IllegalArgumentException("No res.apk for " + library.libraryName());
        }
        PathString resApkPath = pathString;
        Path path = resApkPath.toPath();
        if (path == null) {
            throw new IllegalArgumentException("Cannot find " + resApkPath + " for " + library.libraryName());
        }
        Path resApkFile = path;
        Cache<Path, AarProtoResourceRepository> cache = this.myProtoRepositories;
        Intrinsics.checkNotNullExpressionValue(cache, (String)"myProtoRepositories");
        AarResourceRepository aarResourceRepository = AarResourceRepositoryCache.Companion.getRepository(resApkFile, cache, () -> AarResourceRepositoryCache.getProtoRepository$lambda$1(resApkFile, library));
        Intrinsics.checkNotNullExpressionValue((Object)aarResourceRepository, (String)"access$getRepository(...)");
        return (AarProtoResourceRepository)aarResourceRepository;
    }

    public final void removeProtoRepository(@NotNull Path resApkFile) {
        Intrinsics.checkNotNullParameter((Object)resApkFile, (String)"resApkFile");
        this.myProtoRepositories.invalidate((Object)resApkFile);
    }

    public final void removeSourceRepository(@NotNull ResourceFolder resourceFolder) {
        Intrinsics.checkNotNullParameter((Object)resourceFolder, (String)"resourceFolder");
        this.mySourceRepositories.invalidate((Object)resourceFolder);
    }

    public final void clear() {
        this.myProtoRepositories.invalidateAll();
        this.mySourceRepositories.invalidateAll();
    }

    private final CachingData createCachingData(ExternalAndroidLibrary library) {
        Comparable<FileTime> modificationTime;
        ResourceFolder resFolder;
        block9: {
            FileTime fileTime;
            resFolder = library.getResFolder();
            if (resFolder == null || resFolder.getResources() != null) {
                return null;
            }
            modificationTime = null;
            try {
                Path path = resFolder.getRoot().toPath();
                Intrinsics.checkNotNull((Object)path);
                fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            }
            catch (NoSuchFileException e) {
                return null;
            }
            modificationTime = fileTime;
            PathString pathString = library.getLocation();
            if (pathString != null) {
                PathString it = pathString;
                boolean bl = false;
                try {
                    Path libraryPath = it.toPath();
                    if (libraryPath == null) {
                        AarResourceRepositoryCache $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(AarResourceRepositoryCache.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Library " + library.libraryName() + " has an invalid location: \"" + it + "\"");
                        break block9;
                    }
                    Comparable comparable = modificationTime;
                    FileTime fileTime2 = Files.getLastModifiedTime(libraryPath, new LinkOption[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
                    modificationTime = RangesKt.coerceAtLeast((Comparable)comparable, (Comparable)fileTime2);
                }
                catch (NoSuchFileException libraryPath) {
                }
            }
        }
        String string = modificationTime.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String contentVersion = string;
        String string2 = CodeVersionAdapter.Companion.getCodeVersion();
        if (string2 == null) {
            return null;
        }
        String codeVersion = string2;
        PathString path = resFolder.getRoot();
        String string3 = Hashing.farmHashFingerprint64().hashUnencodedChars((CharSequence)path.getPortablePath()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String pathHash = string3;
        String[] $i$f$thisLogger = "%s_%s.dat";
        Object[] objectArray = new Object[2];
        Object object = library.getLocation();
        if (object == null || (object = object.getFileName()) == null) {
            object = "";
        }
        objectArray[0] = object;
        objectArray[1] = pathHash;
        String string4 = String.format((String)$i$f$thisLogger, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        String filename = string4;
        $i$f$thisLogger = new String[]{"caches/resources", filename};
        Path cacheFile = Paths.get(PathManager.getSystemPath(), $i$f$thisLogger);
        Executor executor = ApplicationManager.getApplication().isUnitTestMode() ? AarResourceRepositoryCache::createCachingData$lambda$3 : (Executor)AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
        Intrinsics.checkNotNull((Object)cacheFile);
        return new CachingData(cacheFile, contentVersion, codeVersion, executor);
    }

    private static final AarSourceResourceRepository getSourceRepository$lambda$0(ResourceFolder $resFolder, ExternalAndroidLibrary $library, AarResourceRepositoryCache this$0) {
        return AarSourceResourceRepository.create((PathString)$resFolder.getRoot(), (Collection)$resFolder.getResources(), (String)$library.libraryName(), (CachingData)this$0.createCachingData($library));
    }

    private static final AarProtoResourceRepository getProtoRepository$lambda$1(Path $resApkFile, ExternalAndroidLibrary $library) {
        return AarProtoResourceRepository.create((Path)$resApkFile, (String)$library.libraryName());
    }

    private static final void createCachingData$lambda$3(Runnable it) {
    }

    @NotNull
    public static final AarResourceRepositoryCache getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\n*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\n0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\n0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/res/AarResourceRepositoryCache$Companion;", "", "<init>", "()V", "instance", "Lcom/android/tools/idea/res/AarResourceRepositoryCache;", "getInstance$annotations", "getInstance", "()Lcom/android/tools/idea/res/AarResourceRepositoryCache;", "getRepository", "T", "K", "Lcom/android/resources/aar/AarResourceRepository;", "key", "cache", "Lcom/google/common/cache/Cache;", "factory", "Lkotlin/Function0;", "(Ljava/lang/Object;Lcom/google/common/cache/Cache;Lkotlin/jvm/functions/Function0;)Lcom/android/resources/aar/AarResourceRepository;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AarResourceRepositoryCache getInstance() {
            Object object = ApplicationManager.getApplication().getService(AarResourceRepositoryCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AarResourceRepositoryCache)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        private final <K, T extends AarResourceRepository> T getRepository(K key, Cache<K, T> cache, Function0<? extends T> factory2) {
            return (T)((AarResourceRepository)CacheUtils.getAndUnwrap(cache, key, () -> Companion.getRepository$lambda$0(factory2)));
        }

        private static final AarResourceRepository getRepository$lambda$0(Function0 $factory) {
            return (AarResourceRepository)$factory.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

