/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.sdklib.devices.Device;
import com.android.tools.configurations.Configuration;
import com.intellij.openapi.diagnostic.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FloatResources {
    private static final Logger LOG = Logger.getInstance(FloatResources.class);
    private static final String DIMENSION_ERROR_FORMAT = "The specified dimension %1$s does not have a unit";
    private static final Pattern sFloatPattern = Pattern.compile("(-?[0-9]+(?:\\.[0-9]+)?)(.*)");
    private static final float[] sFloatOut = new float[1];
    private static final UnitEntry[] sUnitNames = new UnitEntry[]{new UnitEntry("px", 5, 0, 1.0f), new UnitEntry("dip", 5, 1, 1.0f), new UnitEntry("dp", 5, 1, 1.0f), new UnitEntry("sp", 5, 2, 1.0f), new UnitEntry("pt", 5, 3, 1.0f), new UnitEntry("in", 5, 4, 1.0f), new UnitEntry("mm", 5, 5, 1.0f)};

    private FloatResources() {
    }

    public static boolean parseFloatAttribute(@NotNull String value2, TypedValue outValue, boolean requireUnit) {
        int len = (value2 = value2.trim()).length();
        if (len <= 0) {
            return false;
        }
        char[] buf = value2.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= '\u00ff') continue;
            return false;
        }
        if ((buf[0] < '0' || buf[0] > '9') && buf[0] != '.' && buf[0] != '-' && buf[0] != '+') {
            return false;
        }
        Matcher m = sFloatPattern.matcher(value2);
        if (m.matches()) {
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (!end.isEmpty() && end.charAt(0) != ' ') {
                if (FloatResources.parseUnit(end, outValue)) {
                    FloatResources.computeTypedValue(outValue, f, sFloatOut[0]);
                    return true;
                }
                return false;
            }
            if ((end = end.trim()).isEmpty() && outValue != null) {
                if (!requireUnit) {
                    outValue.type = 4;
                    outValue.data = Float.floatToIntBits(f);
                } else {
                    FloatResources.applyUnit(sUnitNames[1], outValue);
                    FloatResources.computeTypedValue(outValue, f, sFloatOut[0]);
                    if (!value2.equals("-1") && !value2.equals("-2")) {
                        LOG.warn(String.format(DIMENSION_ERROR_FORMAT, value2));
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static void computeTypedValue(TypedValue outValue, float value2, float scale) {
        int shift;
        int radix;
        long bits;
        boolean neg;
        boolean bl = neg = (value2 *= scale) < 0.0f;
        if (neg) {
            value2 = -value2;
        }
        if (((bits = (long)(value2 * 8388608.0f + 0.5f)) & 0x7FFFFFL) == 0L) {
            radix = 0;
            shift = 23;
        } else if ((bits & 0xFFFFFFFFFF800000L) == 0L) {
            radix = 3;
            shift = 0;
        } else if ((bits & Integer.MIN_VALUE) == 0L) {
            radix = 2;
            shift = 8;
        } else if ((bits & 0xFFFFFF8000000000L) == 0L) {
            radix = 1;
            shift = 16;
        } else {
            radix = 0;
            shift = 23;
        }
        int mantissa = (int)(bits >> shift & 0xFFFFFFL);
        if (neg) {
            mantissa = -mantissa & 0xFFFFFF;
        }
        outValue.data |= radix << 4 | mantissa << 8;
    }

    private static boolean parseUnit(String str, TypedValue outValue) {
        str = str.trim();
        for (UnitEntry unit : sUnitNames) {
            if (!unit.name.equals(str)) continue;
            FloatResources.applyUnit(unit, outValue);
            return true;
        }
        return false;
    }

    private static void applyUnit(UnitEntry unit, TypedValue outValue) {
        outValue.type = unit.type;
        outValue.data = unit.unit << 0;
        FloatResources.sFloatOut[0] = unit.scale;
    }

    public static class TypedValue {
        static final int TYPE_FLOAT = 4;
        static final int TYPE_DIMENSION = 5;
        static final int COMPLEX_UNIT_SHIFT = 0;
        static final int COMPLEX_UNIT_MASK = 15;
        static final int COMPLEX_UNIT_PX = 0;
        static final int COMPLEX_UNIT_DIP = 1;
        static final int COMPLEX_UNIT_SP = 2;
        static final int COMPLEX_UNIT_PT = 3;
        static final int COMPLEX_UNIT_IN = 4;
        static final int COMPLEX_UNIT_MM = 5;
        static final int COMPLEX_RADIX_SHIFT = 4;
        static final int COMPLEX_RADIX_MASK = 3;
        static final int COMPLEX_RADIX_23p0 = 0;
        static final int COMPLEX_RADIX_16p7 = 1;
        static final int COMPLEX_RADIX_8p15 = 2;
        static final int COMPLEX_RADIX_0p23 = 3;
        static final int COMPLEX_MANTISSA_SHIFT = 8;
        static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
        private static final float MANTISSA_MULT = 0.00390625f;
        private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
        public int type;
        public int data;

        public static int complexToDimensionPixelSize(int data2, Configuration config) {
            float value2 = TypedValue.complexToFloat(data2);
            float f = TypedValue.applyDimension(data2 >> 0 & 0xF, value2, config);
            int res2 = (int)(f + 0.5f);
            if (res2 != 0) {
                return res2;
            }
            if (value2 == 0.0f) {
                return 0;
            }
            if (value2 > 0.0f) {
                return 1;
            }
            return -1;
        }

        static float complexToFloat(int complex) {
            return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
        }

        static float applyDimension(int unit, float value2, Configuration config) {
            Device device2 = config.getCachedDevice();
            float xdpi = 493.0f;
            if (device2 != null) {
                xdpi = (float)device2.getDefaultHardware().getScreen().getXdpi();
            }
            switch (unit) {
                case 0: {
                    return value2;
                }
                case 1: {
                    return value2 * (float)config.getDensity().getDpiValue() / 160.0f;
                }
                case 2: {
                    return value2 * (float)config.getDensity().getDpiValue() / 160.0f;
                }
                case 3: {
                    return value2 * xdpi * 0.013888889f;
                }
                case 4: {
                    return value2 * xdpi * 0.013888889f;
                }
                case 5: {
                    return value2 * xdpi * 0.013888889f;
                }
            }
            return 0.0f;
        }
    }

    private static final class UnitEntry {
        private final String name;
        private final int type;
        private final int unit;
        private final float scale;

        UnitEntry(String name2, int type, int unit, float scale) {
            this.name = name2;
            this.type = type;
            this.unit = unit;
            this.scale = scale;
        }
    }
}

