/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/res/RootsChangedDumbModeTask;", "Lcom/intellij/openapi/project/DumbModeTask;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "performInDumbMode", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "tryMergeWith", "taskFromQueue", "moduleRootsOrDependenciesChanged", "module", "Lcom/intellij/openapi/module/Module;", "intellij.android.core"})
final class RootsChangedDumbModeTask
extends DumbModeTask {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger log;

    public RootsChangedDumbModeTask(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this));
        Logger logger = Logger.getInstance(RootsChangedDumbModeTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (this.project.isDisposed()) {
            this.log.warn("Project is disposed, skipping resource update.");
            return;
        }
        indicator.setText("Updating resource repository roots");
        for (Module module : ModuleManager.Companion.getInstance(this.project).getModules()) {
            indicator.checkCanceled();
            if (this.project.isDisposed()) {
                this.log.warn("Project is disposed, aborting resource update.");
                return;
            }
            this.moduleRootsOrDependenciesChanged(module);
        }
    }

    @Nullable
    public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
        RootsChangedDumbModeTask rootsChangedDumbModeTask;
        Intrinsics.checkNotNullParameter((Object)taskFromQueue, (String)"taskFromQueue");
        RootsChangedDumbModeTask it = rootsChangedDumbModeTask = this;
        boolean bl = false;
        return taskFromQueue instanceof RootsChangedDumbModeTask && Intrinsics.areEqual((Object)((RootsChangedDumbModeTask)taskFromQueue).project, (Object)this.project) ? rootsChangedDumbModeTask : null;
    }

    private final void moduleRootsOrDependenciesChanged(Module module) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet facet = androidFacet;
        if (AndroidModel.Companion.isRequired(facet) && AndroidModel.Companion.get(facet) == null) {
            return;
        }
        AndroidDependenciesCache.getInstance(module).dropCache();
        ResourceFolderManager.Companion.getInstance(facet).checkForChanges();
        StudioResourceRepositoryManager.getInstance(facet).updateRootsAndLibraries();
    }
}

