/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.fonts.StudioDownloadableFontCacheService;
import com.android.tools.idea.projectsystem.DependencyScopeType;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.res.AssetFileOpener;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.google.common.collect.Streams;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioAssetFileOpener
implements AssetFileOpener {
    private static Path myFrameworkResDirOrJar;
    private AndroidFacet myFacet;

    public StudioAssetFileOpener(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
    }

    @Override
    @Nullable
    public InputStream openAssetFile(@NotNull String path) {
        assert (this.myFacet != null);
        return StudioAssetFileOpener.getDirectories(this.myFacet, IdeaSourceProvider::getAssetsDirectories, ExternalAndroidLibrary::getAssetsFolder).map(assetDir -> assetDir.findFileByRelativePath(path)).map(assetDir -> {
            if (assetDir == null) {
                return null;
            }
            try {
                return assetDir.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static boolean isCachedFontFile(@NotNull VirtualFile file) {
        File fontCachePathFile = StudioDownloadableFontCacheService.getInstance().getFontCachePath();
        if (fontCachePathFile == null) {
            return false;
        }
        VirtualFile fontCachePath = VirtualFileManager.getInstance().findFileByNioPath(fontCachePathFile.toPath());
        if (fontCachePath == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)fontCachePath, (VirtualFile)file, (boolean)true);
    }

    @Override
    @Nullable
    public InputStream openNonAssetFile(@NotNull String path) {
        Object url;
        assert (this.myFacet != null);
        if (path.startsWith("file://")) {
            url = path;
        } else {
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            url = "file://" + path;
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl((String)url);
        if (file == null) {
            return null;
        }
        return StudioAssetFileOpener.getDirectories(this.myFacet, IdeaSourceProvider::getResDirectories, it -> it.getResFolder() != null ? it.getResFolder().getRoot() : null).filter(resDir -> VfsUtilCore.isAncestor((VirtualFile)resDir, (VirtualFile)file, (boolean)true)).map(resDir -> {
            try {
                return file.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).findAny().orElseGet(() -> {
            if (StudioAssetFileOpener.isCachedFontFile(file) || this.isSdkFile(file).booleanValue()) {
                try {
                    return file.getInputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        });
    }

    @NotNull
    private static Stream<VirtualFile> getDirectories(@NotNull AndroidFacet facet, @NotNull Function<IdeaSourceProvider, Iterable<VirtualFile>> sourceMapper, @NotNull Function<ExternalAndroidLibrary, PathString> aarMapper) {
        Stream dirsFromSources = Stream.concat(Stream.of(facet), AndroidDependenciesCache.getAllAndroidDependencies(facet.getModule(), true).stream()).flatMap(f -> {
            SourceProviders sourceProviders = SourceProviderManager.getInstance(f);
            ArrayList<IdeaSourceProvider> providers = new ArrayList<IdeaSourceProvider>();
            providers.addAll(sourceProviders.getCurrentAndSomeFrequentlyUsedInactiveSourceProviders());
            providers.add(sourceProviders.getGeneratedSources());
            return providers.stream();
        }).distinct().map(sourceMapper).flatMap(Streams::stream);
        VirtualFileManager manager = VirtualFileManager.getInstance();
        Stream<VirtualFile> libraryDepAarDirs = ProjectSystemUtil.getModuleSystem(facet.getModule()).getAndroidLibraryDependencies(DependencyScopeType.MAIN).stream().map(aarMapper).filter(Objects::nonNull).map(path -> manager.findFileByUrl("file://" + path.getPortablePath())).filter(Objects::nonNull);
        Stream<VirtualFile> frameworkDirs = Stream.of(StudioAssetFileOpener.getSdkResDirOrJar(facet)).filter(Objects::nonNull).map(path -> manager.findFileByUrl("file://" + String.valueOf(path))).filter(Objects::nonNull);
        Stream<VirtualFile> sampleDataDirs = Stream.of(ResourceContent.getSampleDataBaseDir(), ResourceContent.getSampleDataUserDir(facet)).filter(Objects::nonNull).distinct().map(dir -> manager.findFileByUrl("file://" + String.valueOf(dir.toAbsolutePath()))).filter(Objects::nonNull);
        return Stream.of(dirsFromSources, frameworkDirs, sampleDataDirs, libraryDepAarDirs).flatMap(stream -> stream);
    }

    @Nullable
    private static Path getSdkResDirOrJar(@NotNull AndroidFacet facet) {
        if (myFrameworkResDirOrJar == null) {
            ConfigurationManager manager = ConfigurationManager.getOrCreateInstance(facet.getModule());
            IAndroidTarget target2 = manager.getHighestApiTarget();
            if (target2 == null) {
                return null;
            }
            CompatibilityRenderTarget compatibilityTarget = StudioEmbeddedRenderTarget.getCompatibilityTarget(target2);
            myFrameworkResDirOrJar = compatibilityTarget.getPath(11);
        }
        return myFrameworkResDirOrJar;
    }

    private Boolean isSdkFile(@NotNull VirtualFile file) {
        for (Sdk sdk : AndroidSdks.getInstance().getAllAndroidSdks()) {
            VirtualFile sdkHome = sdk.getHomeDirectory();
            if (sdkHome == null || !VfsUtilCore.isAncestor((VirtualFile)sdkHome, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }
}

