/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.concurrency.AndroidIoManager;
import com.android.tools.idea.AndroidProjectModelUtils;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.AarResourceRepositoryCache;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.res.TestAppResourceRepository;
import com.android.tools.res.FrameworkOverlay;
import com.android.tools.res.LocalResourceRepository;
import com.android.tools.res.ResourceNamespacing;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidTargetData;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class StudioResourceRepositoryManager
implements Disposable,
ResourceRepositoryManager {
    private static final Key<StudioResourceRepositoryManager> KEY = Key.create((String)StudioResourceRepositoryManager.class.getName());
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private static final Object TEST_RESOURCES_LOCK = new Object();
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceNamespacing myNamespacing;
    @Nullable
    private ResourceNamespace mySharedNamespaceInstance;
    @Nullable
    private ResourceNamespace mySharedTestNamespaceInstance;
    private AppResourceRepository myAppResources;
    private LocalResourceRepository<VirtualFile> myProjectResources;
    private LocalResourceRepository<VirtualFile> myModuleResources;
    private LocalResourceRepository<VirtualFile> myTestAppResources;
    private LocalResourceRepository<VirtualFile> myTestModuleResources;
    private SampleDataResourceRepository mySampleDataResources;
    private final Object mySampleDataLock = new Object();
    private CachedValue<LocalesAndLanguages> myLocalesAndLanguages;
    private Map<ExternalAndroidLibrary, AarResourceRepository> myLibraryResourceMap;
    private final Object myLibraryLock = new Object();

    @Nullable
    public static StudioResourceRepositoryManager getInstanceIfCreated(@NotNull AndroidFacet facet) {
        return (StudioResourceRepositoryManager)facet.getUserData(KEY);
    }

    @NotNull
    public static StudioResourceRepositoryManager getInstance(@NotNull AndroidFacet facet) {
        ResourceNamespacing namespacing = StudioResourceRepositoryManager.toResourceNamespacing(AndroidProjectModelUtils.getNamespacing(facet));
        StudioResourceRepositoryManager instance = (StudioResourceRepositoryManager)facet.getUserData(KEY);
        if (instance != null && instance.myNamespacing != namespacing) {
            if (facet.replace(KEY, (Object)instance, null)) {
                Disposer.dispose((Disposable)instance);
            }
            instance = null;
        }
        if (instance == null) {
            StudioResourceRepositoryManager manager = new StudioResourceRepositoryManager(facet, namespacing, (Disposable)facet);
            instance = (StudioResourceRepositoryManager)facet.putUserDataIfAbsent(KEY, (Object)manager);
            if (instance == manager) {
                AndroidProjectRootListener.ensureSubscribed(manager.getProject());
            } else {
                Disposer.dispose((Disposable)manager);
            }
        }
        return instance;
    }

    @Nullable
    public static StudioResourceRepositoryManager getInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        return facet == null ? null : StudioResourceRepositoryManager.getInstance(facet);
    }

    @Nullable
    public static StudioResourceRepositoryManager getInstance(@NotNull PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return null;
        }
        return StudioResourceRepositoryManager.getInstance(facet);
    }

    @Slow
    @Nullable
    public static LocalResourceRepository<VirtualFile> getAppResources(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        return facet != null ? StudioResourceRepositoryManager.getAppResources(facet) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository<VirtualFile> getAppResources(@NotNull AndroidFacet facet) {
        return StudioResourceRepositoryManager.getInstance(facet).getAppResources();
    }

    @Slow
    @Nullable
    public static LocalResourceRepository<VirtualFile> getProjectResources(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        return facet != null ? StudioResourceRepositoryManager.getProjectResources(facet) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository<VirtualFile> getProjectResources(@NotNull AndroidFacet facet) {
        return StudioResourceRepositoryManager.getInstance(facet).getProjectResources();
    }

    @Slow
    @Nullable
    public static LocalResourceRepository<VirtualFile> getModuleResources(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        return facet != null ? StudioResourceRepositoryManager.getModuleResources(facet) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository<VirtualFile> getModuleResources(@NotNull AndroidFacet facet) {
        return StudioResourceRepositoryManager.getInstance(facet).getModuleResources();
    }

    private static ResourceNamespacing toResourceNamespacing(@NotNull Namespacing namespacing) {
        return switch (namespacing) {
            default -> throw new MatchException(null, null);
            case Namespacing.DISABLED -> ResourceNamespacing.DISABLED;
            case Namespacing.REQUIRED -> ResourceNamespacing.REQUIRED;
        };
    }

    private StudioResourceRepositoryManager(@NotNull AndroidFacet facet, @NotNull ResourceNamespacing namespacing, @NotNull Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myFacet = facet;
        this.myNamespacing = namespacing;
        this.myLocalesAndLanguages = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(this::newLocalesAndLanguagesCachedValue);
    }

    @Slow
    @Nullable
    public ResourceRepository getResourcesForNamespace(@NotNull ResourceNamespace namespace) {
        return namespace.equals((Object)ResourceNamespace.ANDROID) ? this.getFrameworkResources(Collections.emptySet()) : this.getAppResources();
    }

    @Override
    @Slow
    @NotNull
    public LocalResourceRepository<VirtualFile> getAppResources() {
        LocalResourceRepository<VirtualFile> appResources = this.getCachedAppResources();
        if (appResources != null) {
            return appResources;
        }
        this.getLibraryResources();
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = APP_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myAppResources = AppResourceRepository.create(this.myFacet, this);
                }
                return this.myAppResources;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository<VirtualFile> getCachedAppResources() {
        Object object = APP_RESOURCES_LOCK;
        synchronized (object) {
            return this.myAppResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Slow
    @NotNull
    public LocalResourceRepository<VirtualFile> getProjectResources() {
        LocalResourceRepository<VirtualFile> projectResourceRepositoryToReturn;
        LocalResourceRepository<VirtualFile> projectResources = this.getCachedProjectResources();
        if (projectResources != null) {
            return projectResources;
        }
        ProjectResourceRepository projectResourceRepository = (ProjectResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            if (this.myFacet.isDisposed()) {
                return null;
            }
            return ProjectResourceRepository.create(this.myFacet, this);
        });
        if (projectResourceRepository == null) {
            return new LocalResourceRepository.EmptyRepository<VirtualFile>(this.getNamespace());
        }
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources == null) {
                this.myProjectResources = projectResourceRepository;
            }
            projectResourceRepositoryToReturn = this.myProjectResources;
        }
        if (projectResourceRepositoryToReturn != projectResourceRepository) {
            Disposer.dispose((Disposable)projectResourceRepository);
        }
        return projectResourceRepositoryToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository<VirtualFile> getCachedProjectResources() {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            return this.myProjectResources;
        }
    }

    @Override
    @Slow
    @NotNull
    public LocalResourceRepository<VirtualFile> getModuleResources() {
        LocalResourceRepository<VirtualFile> moduleResources2 = this.getCachedModuleResources();
        if (moduleResources2 != null) {
            return moduleResources2;
        }
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = MODULE_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myModuleResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myModuleResources = ModuleResourceRepository.forMainResources(this.myFacet, this, this.getNamespace());
                }
                return this.myModuleResources;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository<VirtualFile> getCachedModuleResources() {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            return this.myModuleResources;
        }
    }

    @NotNull
    public LocalResourceRepository<VirtualFile> getTestAppResources() {
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getTestNamespace());
                    }
                    this.myTestAppResources = TestAppResourceRepository.create(this.myFacet, this);
                }
                return this.myTestAppResources;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private LocalResourceRepository<VirtualFile> getCachedTestAppResources() {
        Object object = TEST_RESOURCES_LOCK;
        synchronized (object) {
            return this.myTestAppResources;
        }
    }

    @NotNull
    public LocalResourceRepository<VirtualFile> getTestModuleResources() {
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestModuleResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getTestNamespace());
                    }
                    this.myTestModuleResources = ModuleResourceRepository.forTestResources(this.myFacet, this, this.getTestNamespace());
                }
                return this.myTestModuleResources;
            }
        });
    }

    @Slow
    @NotNull
    public LocalResourceRepository<VirtualFile> getSampleDataResources() {
        LocalResourceRepository<VirtualFile> sampleDataResources = this.getCachedSampleDataResources();
        if (sampleDataResources != null) {
            return sampleDataResources;
        }
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.mySampleDataLock;
            synchronized (object) {
                if (this.mySampleDataResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.mySampleDataResources = new SampleDataResourceRepository(this.myFacet, this);
                }
                return this.mySampleDataResources;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository<VirtualFile> getCachedSampleDataResources() {
        Object object = this.mySampleDataLock;
        synchronized (object) {
            return this.mySampleDataResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSampleResources() {
        Object object = this.mySampleDataLock;
        synchronized (object) {
            if (this.mySampleDataResources == null) {
                return;
            }
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.mySampleDataLock;
            synchronized (object) {
                if (this.mySampleDataResources != null) {
                    this.mySampleDataResources.reload();
                }
            }
        });
    }

    @Override
    @Slow
    @Nullable
    public ResourceRepository getFrameworkResources(@NotNull Set<String> languages, @NotNull List<? extends FrameworkOverlay> overlays) {
        AndroidPlatform androidPlatform = AndroidPlatforms.getInstance(this.myFacet.getModule());
        if (androidPlatform == null) {
            return null;
        }
        return AndroidTargetData.get(androidPlatform.getSdkData(), androidPlatform.getTarget()).getFrameworkResources(languages, overlays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResources() {
        ArrayList<LocalResourceRepository<VirtualFile>> removedRepositories = new ArrayList<LocalResourceRepository<VirtualFile>>(6);
        Object object = this.myLibraryLock;
        synchronized (object) {
            this.myLibraryResourceMap = null;
        }
        object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources != null) {
                removedRepositories.add(this.myModuleResources);
                this.myModuleResources = null;
            }
        }
        object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources != null) {
                removedRepositories.add(this.myProjectResources);
                this.myProjectResources = null;
                this.myLocalesAndLanguages = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(this::newLocalesAndLanguagesCachedValue);
            }
        }
        object = APP_RESOURCES_LOCK;
        synchronized (object) {
            Iterator iterator2 = this.mySampleDataLock;
            synchronized (iterator2) {
                if (this.mySampleDataResources != null) {
                    removedRepositories.add(this.mySampleDataResources);
                    this.mySampleDataResources = null;
                }
            }
            if (this.myAppResources != null) {
                removedRepositories.add(this.myAppResources);
                this.myAppResources = null;
            }
        }
        object = TEST_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myTestAppResources != null) {
                removedRepositories.add(this.myTestAppResources);
                this.myTestAppResources = null;
            }
            if (this.myTestModuleResources != null) {
                removedRepositories.add(this.myTestModuleResources);
                this.myTestModuleResources = null;
            }
        }
        DisposeAndRefreshService disposeAndRefreshService = DisposeAndRefreshService.getInstance();
        for (LocalResourceRepository localResourceRepository : removedRepositories) {
            disposeAndRefreshService.disposeAndNotifyParents(localResourceRepository);
        }
    }

    public void dispose() {
    }

    public void resetAllCaches() {
        ResourceFolderRegistry.getInstance(this.getProject()).reset(this.myFacet);
        this.resetResources();
        ConfigurationManager.getOrCreateInstance(this.myFacet.getModule()).getResolverCache().reset();
        AarResourceRepositoryCache.getInstance().clear();
    }

    @NotNull
    private Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRootsAndLibraries() {
        block9: {
            try {
                Map<ExternalAndroidLibrary, AarResourceRepository> oldLibraryResourceMap;
                ProjectResourceRepository projectResources = (ProjectResourceRepository)this.getCachedProjectResources();
                AppResourceRepository appResources = (AppResourceRepository)this.getCachedAppResources();
                if (projectResources != null) {
                    projectResources.refreshChildren();
                }
                Object object = this.myLibraryLock;
                synchronized (object) {
                    oldLibraryResourceMap = this.myLibraryResourceMap;
                    this.myLibraryResourceMap = null;
                }
                if (appResources != null) {
                    appResources.refreshChildren();
                }
                if (oldLibraryResourceMap != null && oldLibraryResourceMap.size() == Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                LocalResourceRepository<VirtualFile> localResourceRepository = this.getCachedTestAppResources();
                if (localResourceRepository instanceof TestAppResourceRepository) {
                    TestAppResourceRepository testAppResources = (TestAppResourceRepository)localResourceRepository;
                    testAppResources.refreshChildren();
                }
            }
            catch (IllegalStateException e) {
                if (this.myFacet.isDisposed()) break block9;
                throw e;
            }
        }
    }

    @Override
    @NotNull
    public ResourceNamespacing getNamespacing() {
        return this.myNamespacing;
    }

    @Override
    @NotNull
    public ResourceNamespace getNamespace() {
        if (this.myNamespacing == ResourceNamespacing.DISABLED) {
            return ResourceNamespace.RES_AUTO;
        }
        String packageName = (String)ReadAction.compute(() -> ProjectSystemUtil.getModuleSystem(this.myFacet).getPackageName());
        if (packageName == null) {
            return ResourceNamespace.RES_AUTO;
        }
        if (this.mySharedNamespaceInstance == null || !packageName.equals(this.mySharedNamespaceInstance.getPackageName())) {
            this.mySharedNamespaceInstance = ResourceNamespace.fromPackageName((String)packageName);
        }
        return this.mySharedNamespaceInstance;
    }

    @NotNull
    public ResourceNamespace getTestNamespace() {
        if (this.myNamespacing == ResourceNamespacing.DISABLED) {
            return ResourceNamespace.RES_AUTO;
        }
        String testPackageName = ProjectSystemUtil.getModuleSystem(this.myFacet).getTestPackageName();
        if (testPackageName == null) {
            return ResourceNamespace.RES_AUTO;
        }
        if (this.mySharedTestNamespaceInstance == null || !testPackageName.equals(this.mySharedTestNamespaceInstance.getPackageName())) {
            this.mySharedTestNamespaceInstance = ResourceNamespace.fromPackageName((String)testPackageName);
        }
        return this.mySharedTestNamespaceInstance;
    }

    @Slow
    @NotNull
    public Collection<VirtualFile> getAllResourceDirs() {
        return ((AppResourceRepository)this.getAppResources()).getAllResourceDirs();
    }

    @Nullable
    public AarResourceRepository findLibraryResources(@NotNull ExternalAndroidLibrary library) {
        return this.getLibraryResourceMap().get(library);
    }

    @Slow
    @NotNull
    public Collection<AarResourceRepository> getLibraryResources() {
        return this.getLibraryResourceMap().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<ExternalAndroidLibrary, AarResourceRepository> getLibraryResourceMap() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            if (this.myLibraryResourceMap == null) {
                this.myLibraryResourceMap = this.computeLibraryResourceMap();
            }
            return this.myLibraryResourceMap;
        }
    }

    @NotNull
    private Map<ExternalAndroidLibrary, AarResourceRepository> computeLibraryResourceMap() {
        Collection<ExternalAndroidLibrary> libraries = AndroidProjectModelUtils.findDependenciesWithResources(this.myFacet.getModule()).values();
        AarResourceRepositoryCache aarResourceRepositoryCache = AarResourceRepositoryCache.getInstance();
        Function<ExternalAndroidLibrary, AarResourceRepository> factory2 = this.myNamespacing == ResourceNamespacing.DISABLED ? aarResourceRepositoryCache::getSourceRepository : aarResourceRepositoryCache::getProtoRepository;
        ExecutorService executor = AndroidIoManager.getInstance().getBackgroundDiskIoExecutor();
        HashMap futures = Maps.newHashMapWithExpectedSize((int)libraries.size());
        for (ExternalAndroidLibrary library : libraries) {
            futures.put(library, executor.submit(() -> (AarResourceRepository)factory2.apply(library)));
        }
        ImmutableMap.Builder map2 = ImmutableMap.builder();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                map2.put((Object)((ExternalAndroidLibrary)entry.getKey()), (Object)((AarResourceRepository)((Future)entry.getValue()).get()));
            }
            catch (ExecutionException e) {
                StudioResourceRepositoryManager.cancelPendingTasks(futures.values());
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new UncheckedExecutionException(e.getCause());
            }
            catch (InterruptedException e) {
                StudioResourceRepositoryManager.cancelPendingTasks(futures.values());
                throw new ProcessCanceledException((Throwable)e);
            }
        }
        return map2.build();
    }

    private static void cancelPendingTasks(Collection<Future<AarResourceRepository>> futures) {
        futures.forEach(f -> f.cancel(true));
    }

    @Override
    @NotNull
    public ImmutableList<Locale> getLocalesInProject() {
        return this.getLocalesAndLanguages().locales;
    }

    @Override
    @NotNull
    public ImmutableSet<String> getLanguagesInProject() {
        return this.getLocalesAndLanguages().languages;
    }

    @NotNull
    private CachedValueProvider.Result<LocalesAndLanguages> newLocalesAndLanguagesCachedValue() {
        LocalResourceRepository<VirtualFile> projectResources = StudioResourceRepositoryManager.getProjectResources(this.myFacet);
        ModificationTracker tracker = projectResources::getModificationCount;
        SortedSet localeQualifiers = ResourceRepositoryUtil.getLocales(projectResources);
        ImmutableList.Builder localesBuilder = ImmutableList.builderWithExpectedSize((int)localeQualifiers.size());
        ImmutableSortedSet.Builder languagesBuilder = ImmutableSortedSet.naturalOrder();
        for (LocaleQualifier localeQualifier : localeQualifiers) {
            localesBuilder.add((Object)Locale.create((LocaleQualifier)localeQualifier));
            String language = localeQualifier.getLanguage();
            if (language == null) continue;
            languagesBuilder.add((Object)language);
        }
        return CachedValueProvider.Result.create((Object)new LocalesAndLanguages((ImmutableList<Locale>)localesBuilder.build(), (ImmutableSortedSet<String>)languagesBuilder.build()), (Object[])new Object[]{tracker});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private LocalesAndLanguages getLocalesAndLanguages() {
        CachedValue<LocalesAndLanguages> localesAndLanguages;
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            localesAndLanguages = this.myLocalesAndLanguages;
        }
        return (LocalesAndLanguages)localesAndLanguages.getValue();
    }

    @Service
    @VisibleForTesting
    static final class DisposeAndRefreshService
    implements Disposable {
        private final ExecutorService executor = Executors.newSingleThreadExecutor();

        DisposeAndRefreshService() {
        }

        public void dispose() {
            this.executor.shutdown();
        }

        public void disposeAndNotifyParents(LocalResourceRepository<VirtualFile> repository2) {
            if (repository2 instanceof Disposable) {
                Disposable disposable = (Disposable)repository2;
                Disposer.register((Disposable)this, (Disposable)disposable);
            }
            this.executor.submit(() -> this.doDisposeAndNotify(repository2));
        }

        private void doDisposeAndNotify(LocalResourceRepository<VirtualFile> repository2) {
            if (repository2 instanceof Disposable) {
                Disposable disposable = (Disposable)repository2;
                Disposer.dispose((Disposable)disposable);
            }
            repository2.notifyParentsOfReset();
        }

        @TestOnly
        public boolean waitForRunningTasks(long timeout, TimeUnit unit) throws InterruptedException {
            Semaphore semaphore = new Semaphore(0);
            this.executor.submit(semaphore::release);
            return semaphore.tryAcquire(timeout, unit);
        }

        public static DisposeAndRefreshService getInstance() {
            return (DisposeAndRefreshService)ApplicationManager.getApplication().getService(DisposeAndRefreshService.class);
        }
    }

    private record LocalesAndLanguages(@NotNull ImmutableList<Locale> locales, @NotNull ImmutableSortedSet<String> languages) {
    }
}

