/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidConfigurationProducer
extends JavaRunConfigurationProducerBase<AndroidRunConfiguration> {
    public AndroidConfigurationProducer() {
        super((ConfigurationType)AndroidRunConfigurationType.getInstance());
    }

    @Nullable
    private static PsiClass getActivityClass(ConfigurationContext context) {
        GlobalSearchScope scope;
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        if ((location = JavaExecutionUtil.stepIntoSingleClass((Location)location)) == null) {
            return null;
        }
        PsiElement element = location.getPsiElement();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiClass activityClass = facade.findClass("android.app.Activity", scope = module.getModuleWithDependenciesAndLibrariesScope(true));
        if (activityClass == null) {
            return null;
        }
        PsiClass elementClass = (PsiClass)AndroidPsiUtils.getPsiParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        while (elementClass != null) {
            if (elementClass.isInheritor(activityClass, true)) {
                return elementClass;
            }
            elementClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementClass, PsiClass.class);
        }
        return null;
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(@NotNull ConfigurationContext context) {
        return AndroidConfigurationProducer.getActivityClass(context) == null ? null : super.createConfigurationFromContext(context);
    }

    protected boolean setupConfigurationFromContext(@NotNull AndroidRunConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        TargetSelectionMode targetSelectionMode;
        PsiClass activity = AndroidConfigurationProducer.getActivityClass(context);
        if (activity == null) {
            return false;
        }
        String activityName = activity.getQualifiedName();
        if (activityName == null) {
            return false;
        }
        sourceElement.set((Object)activity);
        configuration2.setLaunchActivity(activityName);
        configuration2.setName(JavaExecutionUtil.getPresentableClassName((String)activityName));
        this.setupConfigurationModule(context, configuration2);
        Project project = context.getProject();
        if (project != null && (targetSelectionMode = AndroidUtils.getDefaultTargetSelectionMode(project, (ConfigurationType)AndroidRunConfigurationType.getInstance(), AndroidTestRunConfigurationType.getInstance())) != null) {
            configuration2.getDeployTargetContext().setTargetSelectionMode(targetSelectionMode);
        }
        return true;
    }

    protected Module findModule(AndroidRunConfiguration configuration2, Module contextModule) {
        Module module = super.findModule((ModuleBasedConfiguration)configuration2, contextModule);
        return module == null ? null : ProjectSystemUtil.getModuleSystem(module).getHolderModule();
    }

    public boolean isConfigurationFromContext(@NotNull AndroidRunConfiguration configuration2, @NotNull ConfigurationContext context) {
        Module confModule;
        PsiClass activity = AndroidConfigurationProducer.getActivityClass(context);
        if (activity == null) {
            return false;
        }
        String activityName = activity.getQualifiedName();
        if (activityName == null) {
            return false;
        }
        Module contextModule = this.findModule(configuration2, AndroidUtils.getAndroidModule(context));
        return Objects.equals(contextModule, confModule = ((AndroidRunConfigurationModule)configuration2.getConfigurationModule()).getModule()) && configuration2.isLaunchingActivity(activityName);
    }
}

