/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.res.FileRelevanceKt;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\b\u0010\t\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\bH\u0000\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\b\u0010\r\u001a\u00020\u0003H\u0000\u001a\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"kotlinPluginId", "", "prebuildChecks", "", "project", "Lcom/intellij/openapi/project/Project;", "changedFiles", "", "Lcom/intellij/psi/PsiFile;", "checkIwiAvailable", "checkSupportedFiles", "file", "checkJetpackCompose", "checkKotlinPluginBundled", "isKotlinPluginBundled", "", "readActionPrebuildChecks", "intellij.android.core"})
public final class PrebuildChecksKt {
    @NotNull
    private static final String kotlinPluginId = "org.jetbrains.kotlin";

    public static final void prebuildChecks(@NotNull Project project, @NotNull List<? extends PsiFile> changedFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(changedFiles, (String)"changedFiles");
        PrebuildChecksKt.checkIwiAvailable();
        for (PsiFile psiFile : changedFiles) {
            PrebuildChecksKt.checkSupportedFiles(psiFile);
        }
        PrebuildChecksKt.checkJetpackCompose(project);
        PrebuildChecksKt.checkKotlinPluginBundled();
    }

    public static final void checkIwiAvailable() {
        if (StudioFlags.OPTIMISTIC_INSTALL_SUPPORT_LEVEL.get() == StudioFlags.OptimisticInstallSupportLevel.DISABLED) {
            throw LiveEditUpdateException.Companion.iwiDisabled();
        }
    }

    public static final void checkSupportedFiles(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (FileRelevanceKt.isGradleFile(file)) {
            throw LiveEditUpdateException.Companion.gradleBuildFile(file);
        }
        if (Intrinsics.areEqual((Object)file.getLanguage(), (Object)JavaLanguage.INSTANCE)) {
            throw LiveEditUpdateException.Companion.nonKotlinIsJava(file);
        }
        if (file instanceof XmlFile) {
            throw LiveEditUpdateException.Companion.nonKotlinIsXml(file);
        }
        if (!(file instanceof KtFile)) {
            throw LiveEditUpdateException.Companion.nonKotlin(file);
        }
        String string = virtualFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"buildSrc", (boolean)false, (int)2, null)) {
            String string2 = ((KtFile)file).getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            throw LiveEditUpdateException.Companion.unsupportedBuildSrcChange(string2);
        }
        if (!virtualFile2.exists()) {
            throw LiveEditUpdateException.Companion.virtualFileNotExist(virtualFile2, file);
        }
    }

    public static final void checkJetpackCompose(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (KotlinPluginModeProvider.Companion.isK2Mode()) {
            return;
        }
        List pluginExtensions = IrGenerationExtension.Companion.getInstances(project);
        boolean found = false;
        for (IrGenerationExtension extension : pluginExtensions) {
            if (!Intrinsics.areEqual((Object)extension.getClass().getName(), (Object)"com.android.tools.compose.ComposePluginIrGenerationExtension")) continue;
            found = true;
            break;
        }
        if (!found) {
            throw LiveEditUpdateException.Companion.noComposePlugIn();
        }
    }

    public static final void checkKotlinPluginBundled() {
        if (!PrebuildChecksKt.isKotlinPluginBundled()) {
            throw LiveEditUpdateException.Companion.kotlinEap();
        }
    }

    public static final boolean isKotlinPluginBundled() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getInstance().findEnabledPlugin(PluginId.Companion.getId(kotlinPluginId));
        return ideaPluginDescriptor != null ? ideaPluginDescriptor.isBundled() : false;
    }

    public static final void readActionPrebuildChecks(@NotNull Project project, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!file.isValid()) {
            throw LiveEditUpdateException.Companion.fileNotValid(file);
        }
        Module module = ProjectStructureUtilKt.getModule((PsiElement)((PsiElement)file));
        if (module != null) {
            boolean isAndroidSpecificTestSource;
            Module module2 = module;
            boolean bl = false;
            boolean isTestSource = !module2.getModuleScope(false).accept(file.getVirtualFile());
            TestArtifactSearchScopes testArtifactSearchScopes = TestArtifactSearchScopes.Companion.getInstance(module2);
            if (testArtifactSearchScopes != null) {
                VirtualFile virtualFile = file.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                v3 = testArtifactSearchScopes.isTestSource(virtualFile);
            } else {
                v3 = isAndroidSpecificTestSource = false;
            }
            if (isAndroidSpecificTestSource || isTestSource) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                throw LiveEditUpdateException.Companion.unsupportedTestSrcChange(string);
            }
            if (module2.isDisposed()) {
                throw LiveEditUpdateException.Companion.moduleIsDisposed(module2);
            }
        }
    }
}

