/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit.analysis;

import com.android.annotations.Trace;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrInstruction;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrInstructionList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0001\u001a\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"kComposerClass", "", "kSourceInfo", "kSourceInfoMarker", "kTraceEventStart", "onlyComposeDebugConstantChanges", "", "old", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/leir/IrInstructionList;", "new", "isSourceInfoCall", "insn", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/leir/IrInstruction;", "isSourceInfoMarkerCall", "isTraceEventCall", "intellij.android.core"})
public final class ComposeDebugConstantsKt {
    @NotNull
    private static final String kComposerClass = "androidx/compose/runtime/ComposerKt";
    @NotNull
    private static final String kSourceInfo = "sourceInformation";
    @NotNull
    private static final String kSourceInfoMarker = "sourceInformationMarkerStart";
    @NotNull
    private static final String kTraceEventStart = "traceEventStart";

    @Trace
    public static final boolean onlyComposeDebugConstantChanges(@NotNull IrInstructionList old, @NotNull IrInstructionList irInstructionList) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)irInstructionList, (String)"new");
        IrInstruction oldInsn = old.getFirst();
        IrInstruction newInsn = irInstructionList.getFirst();
        while (oldInsn != null || newInsn != null) {
            if (Intrinsics.areEqual((Object)oldInsn, (Object)newInsn)) {
                IrInstruction irInstruction = oldInsn;
                oldInsn = irInstruction != null ? irInstruction.getNextInsn() : null;
                IrInstruction irInstruction2 = newInsn;
                newInsn = irInstruction2 != null ? irInstruction2.getNextInsn() : null;
                continue;
            }
            if (oldInsn == null || newInsn == null) {
                return false;
            }
            if (oldInsn.getOpcode() != 18 || newInsn.getOpcode() != 18) {
                return false;
            }
            if (oldInsn.getNextInsn() == null) {
                return false;
            }
            if (newInsn.getNextInsn() == null) {
                return false;
            }
            if (oldInsn.getParams().get(0) instanceof String && newInsn.getParams().get(0) instanceof String) {
                boolean isTraceEventCall;
                boolean isSourceInfoCall = ComposeDebugConstantsKt.isSourceInfoCall(oldNextInsn) && ComposeDebugConstantsKt.isSourceInfoCall(newNextInsn);
                boolean isSourceInfoMarkerCall = ComposeDebugConstantsKt.isSourceInfoMarkerCall(oldNextInsn) && ComposeDebugConstantsKt.isSourceInfoMarkerCall(newNextInsn);
                boolean bl = isTraceEventCall = ComposeDebugConstantsKt.isTraceEventCall(oldNextInsn) && ComposeDebugConstantsKt.isTraceEventCall(newNextInsn);
                if (!(isSourceInfoCall || isSourceInfoMarkerCall || isTraceEventCall)) {
                    return false;
                }
            } else if (oldInsn.getParams().get(0) instanceof Integer && newInsn.getParams().get(0) instanceof Integer) {
                IrInstruction irInstruction = oldNextInsn.getNextInsn();
                if (irInstruction == null) {
                    return false;
                }
                oldNextInsn = irInstruction;
                IrInstruction irInstruction3 = newNextInsn.getNextInsn();
                if (irInstruction3 == null) {
                    return false;
                }
                newNextInsn = irInstruction3;
                if (!ComposeDebugConstantsKt.isSourceInfoMarkerCall(oldNextInsn) || !ComposeDebugConstantsKt.isSourceInfoMarkerCall(newNextInsn)) {
                    return false;
                }
            } else {
                return false;
            }
            oldInsn = oldInsn.getNext();
            newInsn = newInsn.getNext();
        }
        return true;
    }

    private static final boolean isSourceInfoCall(IrInstruction insn) {
        Object object;
        return insn.getOpcode() == 184 && Intrinsics.areEqual((Object)((object = insn.getParams().get(0)) instanceof String ? (String)object : null), (Object)kComposerClass) && Intrinsics.areEqual((Object)((object = insn.getParams().get(1)) instanceof String ? (String)object : null), (Object)kSourceInfo);
    }

    private static final boolean isSourceInfoMarkerCall(IrInstruction insn) {
        Object object;
        return insn.getOpcode() == 184 && Intrinsics.areEqual((Object)((object = insn.getParams().get(0)) instanceof String ? (String)object : null), (Object)kComposerClass) && Intrinsics.areEqual((Object)((object = insn.getParams().get(1)) instanceof String ? (String)object : null), (Object)kSourceInfoMarker);
    }

    private static final boolean isTraceEventCall(IrInstruction insn) {
        Object object;
        return insn.getOpcode() == 184 && Intrinsics.areEqual((Object)((object = insn.getParams().get(0)) instanceof String ? (String)object : null), (Object)kComposerClass) && Intrinsics.areEqual((Object)((object = insn.getParams().get(1)) instanceof String ? (String)object : null), (Object)kTraceEventStart);
    }
}

