/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit.analysis;

import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.analysis.ComposeDebugConstantsKt;
import com.android.tools.idea.run.deployment.liveedit.analysis.RegularClassVisitorKt;
import com.android.tools.idea.run.deployment.liveedit.analysis.diffing.AnnotationDiff;
import com.android.tools.idea.run.deployment.liveedit.analysis.diffing.LocalVariableDiff;
import com.android.tools.idea.run.deployment.liveedit.analysis.diffing.MethodVisitor;
import com.android.tools.idea.run.deployment.liveedit.analysis.diffing.ParameterDiff;
import com.android.tools.idea.run.deployment.liveedit.analysis.diffing.TryCatchBlockDiff;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrAccessFlag;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrAnnotation;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrInstructionList;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrLocalVariable;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrParameter;
import com.android.tools.idea.run.deployment.liveedit.analysis.leir.IrTryCatchBlock;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015H\u0016J2\u0010\u001a\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015H\u0016J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J$\u0010!\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\u001c\u0010$\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/analysis/RegularMethodVisitor;", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/diffing/MethodVisitor;", "className", "", "methodName", "methodDesc", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getMethodName", "getMethodDesc", "value", "", "hasNonSourceInfoChanges", "getHasNonSourceInfoChanges", "()Z", "location", "visitLocalVariables", "", "added", "", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/leir/IrLocalVariable;", "removed", "modified", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/diffing/LocalVariableDiff;", "visitTryCatchBlocks", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/leir/IrTryCatchBlock;", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/diffing/TryCatchBlockDiff;", "visitInstructions", "old", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/leir/IrInstructionList;", "new", "visitAccess", "", "Lcom/android/tools/idea/run/deployment/liveedit/analysis/leir/IrAccessFlag;", "visitSignature", "intellij.android.core"})
final class RegularMethodVisitor
implements MethodVisitor {
    @NotNull
    private final String className;
    @NotNull
    private final String methodName;
    @NotNull
    private final String methodDesc;
    private boolean hasNonSourceInfoChanges;
    @NotNull
    private final String location;

    public RegularMethodVisitor(@NotNull String className, @NotNull String methodName, @NotNull String methodDesc) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)methodDesc, (String)"methodDesc");
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.location = StringsKt.replace$default((String)this.className, (char)'/', (char)'.', (boolean)false, (int)4, null) + "." + this.methodName + this.methodDesc;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final String getMethodDesc() {
        return this.methodDesc;
    }

    public final boolean getHasNonSourceInfoChanges() {
        return this.hasNonSourceInfoChanges;
    }

    @Override
    public void visitLocalVariables(@NotNull List<IrLocalVariable> added, @NotNull List<IrLocalVariable> removed, @NotNull List<? extends LocalVariableDiff> modified) {
        Intrinsics.checkNotNullParameter(added, (String)"added");
        Intrinsics.checkNotNullParameter(removed, (String)"removed");
        Intrinsics.checkNotNullParameter(modified, (String)"modified");
        this.hasNonSourceInfoChanges = true;
    }

    @Override
    public void visitTryCatchBlocks(@NotNull List<IrTryCatchBlock> added, @NotNull List<IrTryCatchBlock> removed, @NotNull List<? extends TryCatchBlockDiff> modified) {
        Intrinsics.checkNotNullParameter(added, (String)"added");
        Intrinsics.checkNotNullParameter(removed, (String)"removed");
        Intrinsics.checkNotNullParameter(modified, (String)"modified");
        this.hasNonSourceInfoChanges = true;
    }

    @Override
    public void visitInstructions(@NotNull IrInstructionList old, @NotNull IrInstructionList irInstructionList) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)irInstructionList, (String)"new");
        this.hasNonSourceInfoChanges = !ComposeDebugConstantsKt.onlyComposeDebugConstantChanges(old, irInstructionList);
    }

    @Override
    public void visitAccess(@NotNull Set<? extends IrAccessFlag> added, @NotNull Set<? extends IrAccessFlag> removed) {
        Intrinsics.checkNotNullParameter(added, (String)"added");
        Intrinsics.checkNotNullParameter(removed, (String)"removed");
        RegularClassVisitorKt.verifyAccess(added, removed, this.location);
    }

    @Override
    public void visitSignature(@Nullable String old, @Nullable String string) {
        throw LiveEditUpdateException.Companion.unsupportedSourceModificationSignature(this.location, "signature changed from '" + old + "' to '" + string + "'");
    }

    @Override
    public void visitParameters(@NotNull List<IrParameter> added, @NotNull List<IrParameter> removed, @NotNull List<? extends ParameterDiff> modified) {
        MethodVisitor.super.visitParameters(added, removed, modified);
    }

    @Override
    public void visitAnnotations(@NotNull List<IrAnnotation> added, @NotNull List<IrAnnotation> removed, @NotNull List<? extends AnnotationDiff> modified) {
        MethodVisitor.super.visitAnnotations(added, removed, modified);
    }
}

